<?php
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<!-- Classic Slider -->

	<div class="swiper-container ipp-slider flex relative overflow-hidden">
		<div class="swiper-wrapper items-center">
			<?php foreach ($integrate_palace_gallery as $attachment_id): ?>
				<?php
					// Get the image URL and title from the attachment ID
					$image_url = wp_get_attachment_url($attachment_id);
					$image_title = get_the_title($attachment_id);
				?>
				<?php if ($image_url): ?>
					<div class="swiper-slide rounded-lg overflow-hidden">
						<img class="swiper-slide_thumbnail block w-full max-h-[450px] object-cover hover:scale-110 cursor-pointer transition-all duration-500" 
							src="<?php echo esc_url($image_url); ?>" 
							alt="<?php echo esc_attr($image_title); ?>">
					</div>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>

		<div class="swiper-pagination"></div>
		<div class="ipp-slider-slide_expand flex items-center justify-center absolute bottom-2 right-2 bg-white rounded-md p-3 cursor-pointer z-10">
			<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke-width="1.5" xmlns="http://www.w3.org/2000/svg" class="w-6 h-6">
				<path d="M21 9V3h-6M3 15v6h6M21 3l-7.5 7.5m-3 3L3 21" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path>
			</svg>
		</div>
	</div>


	<div class="swiper-container ipp-slider-thumb mt-3 hidden md:flex relative overflow-hidden">
		<div class="swiper-wrapper">
			<?php foreach ($integrate_palace_gallery as $attachment_id): ?>
				<?php
					// Get the image URL and title from the attachment ID
					$image_url = wp_get_attachment_url($attachment_id);
					$image_title = get_the_title($attachment_id);
				?>
				<?php if ($image_url): ?>
					<div class="swiper-slide h-16 md:h-24 rounded-lg overflow-hidden">
						<img class="w-full h-full object-cover cursor-pointer hover:scale-110 transition-all duration-500" 
							src="<?php echo esc_url($image_url); ?>" 
							alt="<?php echo esc_attr($image_title); ?>">
					</div>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>
	</div>



