<?php
if ( ! defined( 'ABSPATH' ) ) exit;
?>
<!-- Default Slider -->

<div class="swiper-container ipp-classic-slider flex">
	<div class="swiper-wrapper items-center">
		<?php foreach ($integrate_palace_gallery as $attachment_id): ?>
			<?php
				// Get the image URL and title from the attachment ID
				$image_url = wp_get_attachment_url($attachment_id);
				$image_title = get_the_title($attachment_id);
			?>
			<?php if ($image_url): ?>
				<div class="swiper-slide">
					<img class="w-full max-h-[300px] lg:max-h-[500px] object-contain" 
						src="<?php echo esc_url($image_url); ?>" 
						alt="<?php echo esc_attr($image_title); ?>">
				</div>
			<?php endif; ?>
		<?php endforeach; ?>
	</div>

	<div class="swiper-button-next"></div>
	<div class="swiper-button-prev"></div>
</div>

<div class="swiper-container ipp-classic-slider-thumb mt-3 flex">
    <div class="swiper-wrapper">
        <?php foreach ($integrate_palace_gallery as $attachment_id): ?>
            <?php
                // Get the image URL and title from the attachment ID
                $image_url = wp_get_attachment_url($attachment_id);
                $image_title = get_the_title($attachment_id);
            ?>
            <?php if ($image_url): ?>
                <div class="swiper-slide h-12 md:h-24 lg:h-28 rounded-lg overflow-hidden">
                    <img class="w-full h-full object-cover cursor-pointer" 
                         src="<?php echo esc_url($image_url); ?>" 
                         alt="<?php echo esc_attr($image_title); ?>">
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</div>






