<?php
if ( ! defined( 'ABSPATH' ) ) exit;
?>
<section class="ipp-property-single_slider">
    <div class="flex flex-wrap">

        <!-- Slider Column -->
        <div class="w-full md:w-7/12 my-5 md:my-12">
            <div class="px-5">
                <?php
                    if ($integrate_palace_gallery):
                        include(plugin_dir_path(__FILE__) . '../slider/palace-property.php');
                    else: 
                        echo "<h3 class='px-12 py-12 text-lg '>No gallery images available for this property</h3>";
                    endif;
                ?>
            </div>
        </div>

        <!-- Content Column -->
        <div class="w-full md:w-5/12 my-5 md:my-12">

            <div class="px-5"> <!-- Content -->
                <h1 class="lg:text-3xl text-xl font-semibold text-gray-900 mt-0  mb-3"><?php echo esc_html(get_the_title()); ?></h1>
                <?php if ($information_address): ?>
                    <p class="text-base font-semibold text-gray-900 uppercase my-0">
                        <?php echo esc_html($information_address); ?>
                    </p>
                    
                    <div class="h-[1px] bg-gray-200 mt-2 mb-4"></div>
                <?php endif; ?>

                <?php if ($property_rent): ?>
                    <div class="flex items-center gap-3">
                        <div class="flex items-center justify-center rounded-full bg-gray-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" class="h-6 w-6" aria-labelledby="d3a3cf5b-2e72-4fff-ab01-2abdf4cbefae">
                                <title id="d3a3cf5b-2e72-4fff-ab01-2abdf4cbefae">dollar</title>
                                <path stroke="#333" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8.672 14.33c0 1.29.99 2.33 2.22 2.33h2.51c1.07 0 1.94-.91 1.94-2.03 0-1.22-.53-1.65-1.32-1.93l-4.03-1.4c-.79-.28-1.32-.71-1.32-1.93 0-1.12.87-2.03 1.94-2.03h2.51c1.23 0 2.22 1.04 2.22 2.33M12 6v12"></path>
                            </svg>
                        </div>
                        <h3 class="text-base font-semibold my-0 "><?php echo esc_html($property_rent); ?>$ per <?php echo esc_html(strtolower($rental_period)); ?></h3>
                    </div>
                    
                    <div class="h-[1px] bg-gray-200 my-4"></div>
                <?php endif; ?>

                <?php if ($available_date): ?>
                    <div class="flex flex-wrap gap-y-5 my-3">
                        <div class="w-full flex items-center">
                            <h3 class="w-[200px] text-sm font-medium my-0 ">Date Available</h3>
                            <p class="w-full text-gray-900 sm:w-auto my-0 text-sm"><?php echo esc_html(gmdate('l, j F, Y', strtotime($available_date))); ?></p>
                        </div>
                    </div>

                    <div class="h-[1px] bg-gray-200 mt-4 mb-8"></div>
                <?php endif; ?>

                <div class="flex justify-between my-5">
                    <div class="flex  flex-wrap items-center gap-5 text-sm font-medium">
                        <?php if ($bedroom): ?>
                            <div class="flex gap-3">
                                <div class="flex items-center justify-center bg-gray-200 w-10 h-10 rounded-md">
                                    <img class="" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__, 2)) . 'assets/img/ipp-bed.svg'); ?>" alt="Bedrooms" />
                                </div>
                                <div>
                                    <h3 class="text-sm font-medium my-0 ">Bedrooms</h3>
                                    <?php echo esc_html($bedroom); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($bathroom): ?>
                            <div class="flex gap-3">
                                <div class="flex items-center justify-center bg-gray-200 w-10 h-10 rounded-md">
                                    <img class="" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__, 2)) . 'assets/img/ipp-bathroom.svg'); ?>" alt="Bathrooms" />
                                </div>
                                <div>
                                    <h3 class="text-sm font-medium my-0 ">Bathrooms</h3>
                                    <?php echo esc_html($bathroom); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($carsno): ?>
                            <div class="flex gap-3">
                                <div class="flex items-center justify-center bg-gray-200 w-10 h-10 rounded-md">
                                    <img class="" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__, 2)) . 'assets/img/ipp-parking.svg'); ?>" alt="Carparks" />
                                </div>
                                <div>
                                    <h3 class="text-sm font-medium my-0 ">Carparks</h3>
                                    <?php echo esc_html($carsno); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div> <!-- Content -->
        </div>
    </div>
</section>

<section class="property-single_content">
    <div class="flex flex-wrap">
        <!-- Content Column -->
        <div class="w-full md:w-2/3 lg:w-3/4 my-5">
            <div class="px-5 pb-5 single-property_content text-gray-700"> <!-- Content -->
                <div class="h-[1px] bg-[#cccccc]"></div>

                <?php if ($description): ?>
                    <div class="w-full flex items-center justify-between my-5">
                        <h3 class="text-xl font-semibold m-0">Property details</h3>
                        <p class="m-0">Listed on <?php echo esc_html(gmdate('j F', strtotime($available_date))); ?></p>
                    </div>

                    <div class="ipp-single-property_details text-base mb-5">
                        <div class="ipp-details_excerpt"><?php echo wp_kses_post($integrate_palace_details_excerpt); ?></div>
                        <div class="ipp-details_content hidden"><?php echo wp_kses_post($integrate_palace_details_content); ?></div>
                        <button class="ipp-single-read-more_button cursor-pointer bg-transparent border-0 text-sm font-semibold flex items-center mt-5" style="color:<?php echo esc_attr($primary_color); ?>;">
                            Show more
                            <span class="ipp-single-read-more_arrow ms-2 flex items-center -rotate-180">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="18 15 12 9 6 15"></polyline>
                                </svg>
                            </span>
                        </button>
                    </div>
                <?php endif; ?>

                <!--
                <div class="w-full flex items-center justify-between py-5">
                    <h3 class="text-xl font-semibold m-0">Map</h3>
                    <a href="#!">
                        <button type="button" class="ipp-primary-button inline-flex items-center justify-center">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" width="24" height="24" class="w-6 h-6 me-2">
                                <path stroke="currentColor" stroke-width="1.5" d="M7.313 3.12c-1.448-.846-3.287.692-3.772 2.297a5.467 5.467 0 00-.187 1.037c.035 2.852 2.427 5.78 5.143 8.494 1.343 1.341 2.802 2.687 4.255 3.681 1.453.994 2.922 1.7 4.397 1.476h.017c1.364-.232 1.8-.476 2.985-1.599.674-.793.644-1.983.009-2.641l-2.275-2.273a2.38 2.38 0 00-2.6-.268l-1.239.899c-.246.18-.564.24-.832.093a3.629 3.629 0 01-.33-.204c-.588-.42-1.285-1.107-1.854-1.677-.586-.585-1.28-1.243-1.695-1.803a1.465 1.465 0 01-.271-.455c-.091-.233-.017-.487.13-.688.321-.438.65-.883.955-1.313.436-.91.334-1.952-.26-2.566L7.63 3.346a2.27 2.27 0 00-.318-.226z"></path>
                            </svg>Directions
                        </button>
                    </a>
                </div>

                <div class="w-full shadow-card relative min-h-[225px] cursor-pointer bg-white p-3 rounded-lg">
                    <div class="mapouter">
                        <div class="gmap_canvas">
                            <iframe width="1200" height="292" id="gmap_canvas" src="https://maps.google.com/maps?q=64A+Newlands+Road%2C+Newlands%2C+Wellington+6037%2C+New+Zealand&t=&z=13&ie=UTF8&iwloc=&output=embed" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"></iframe>
                        </div>
                    </div>
                </div>
                -->
                
            </div> <!-- Content -->
        </div>

        <!-- Sidebar Column -->
        <div class="w-full md:w-1/3 lg:w-1/4 my-5">
            <div class="px-5"> <!-- Sidebar -->
                <div class="bg-white shadow rounded-lg p-5 pb-2">
                    <div class="pb-4">
                        <a href="#">
                            <div class="agent-profile mx-auto rounded-full w-24 h-24 overflow-hidden border border-solid border-gray-500">
                                <img class="w-full" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__, 2)) . 'assets/img/dummy-profile-pic-300x300-1.png'); ?>" alt="agent name"/>
                            </div>
                            <h3 class="text-base text-black font-semibold mx-auto py-2 text-center m-0">AG Name</h3>
                        </a>
                        <div class="text-gray-400 mx-auto text-center text-sm leading-snug">Lorem ipsum odor amet, consectetuer adipiscing elit. Porttitor laoreet eget varius phasellus, vulputate aptent id. Mollis vitae metus ad phasellus neque ultrices sollicitudin nam. Fames magna diam turpis praesent tempor auctor.</div>
                    </div>
                    <div class="mx-auto flex flex-col items-center space-y-2.5 pb-5">
                        <button type="button" class="ipp-secondary-button max-w-60 min-w-52 font-medium text-sm text-center inline-flex items-center justify-center border-solid cursor-pointer transition-all duration-300">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" class="w-6 h-6 me-2" style="color:<?php echo esc_attr($button_background); ?>;">
                                <path stroke="currentColor" stroke-width="1.5" d="M7.313 3.12c-1.448-.846-3.287.692-3.772 2.297a5.467 5.467 0 00-.187 1.037c.035 2.852 2.427 5.78 5.143 8.494 1.343 1.341 2.802 2.687 4.255 3.681 1.453.994 2.922 1.7 4.397 1.476h.017c1.364-.232 1.8-.476 2.985-1.599.674-.793.644-1.983.009-2.641l-2.275-2.273a2.38 2.38 0 00-2.6-.268l-1.239.899c-.246.18-.564.24-.832.093a3.629 3.629 0 01-.33-.204c-.588-.42-1.285-1.107-1.854-1.677-.586-.585-1.28-1.243-1.695-1.803a1.465 1.465 0 01-.271-.455c-.091-.233-.017-.487.13-.688.321-.438.65-.883.955-1.313.436-.91.334-1.952-.26-2.566L7.63 3.346a2.27 2.27 0 00-.318-.226z"></path>
                            </svg>Call
                        </button>

                        <button type="button" class="ipp-primary-button max-w-60 min-w-52 font-medium text-sm text-center inline-flex items-center justify-center border-solid cursor-pointer transition-all duration-300">
                            <svg class="w-6 h-6 me-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 16" style="color:<?php echo esc_attr($button_text); ?>;">
                                <path d="m10.036 8.278 9.258-7.79A1.979 1.979 0 0 0 18 0H2A1.987 1.987 0 0 0 .641.541l9.395 7.737Z"/>
                                <path d="M11.241 9.817c-.36.275-.801.425-1.255.427-.428 0-.845-.138-1.187-.395L0 2.6V14a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2.5l-8.759 7.317Z"/>
                            </svg>Email agent
                        </button>
                    </div>
                </div>
            </div> <!-- Sidebar -->
        </div>
    </div>
</section>
