<?php
if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="flex flex-wrap">

    <!-- Content Column -->
    <div class="w-full md:w-1/2 lg:w-1/2 my-5 md:my-12">
        <?php
            if ($integrate_palace_gallery):
                include(plugin_dir_path(__FILE__) . '../slider/classic.php');
                else: echo "<h3 class='px-12 py-12 text-lg '>No gallery images available for this property</h3>";
            endif;
        ?>
    </div>

    <!-- Sidebar Column -->
    <div class="w-full md:w-1/2 lg:w-1/2 mt-5 md:mt-12">


    <div class="px-5 md:px-10"> <!-- Content -->
    <h1 class="lg:text-3xl text-xl font-semibold text-d-global-0 mt-0  mb-3"><?php echo esc_html( get_the_title() ); ?></h1>
    <p class="text-xl text-black my-0"><?php echo esc_html( get_post_meta( $post_id, 'information_address', true ) ); ?></p>

            <div class="flex gap-x-4 text-xs font-bold mt-2 mb-4">

                <?php if ($bedroom){ ?>
                    <div class="flex items-center gap-x-2">
                    <img class="w-5" src="<?php echo esc_url( plugin_dir_url( dirname(__FILE__, 1) ) . 'public/assets/img/bedroom.svg' ); ?>" />
                    <div class="bedroom">
                    <?php echo esc_html( $bedroom ); ?>
                    </div>
                    </div>
                <?php } ?>

                <?php if ($bathroom){ ?>
                <div class="flex items-center gap-x-2">
                <img class="w-5" src="<?php echo esc_url( plugin_dir_url( dirname(__FILE__, 1) ) . 'public/assets/img/bathroom.svg' ); ?>" />
                <div class="bathroom">
                <?php echo esc_html( $bathroom ); ?>
                </div>
                </div>
                <?php } ?>

                <?php if ($carsno){ ?>
                <div class="flex items-center gap-x-2">
                <img class="w-5" src="<?php echo esc_url( plugin_dir_url( dirname(__FILE__, 1) ) . 'public/assets/img/automobile.svg' ); ?>" />
                <div class="room">
                <?php echo esc_html( $carsno ); ?>
                </div>
                </div>
                <?php } ?>

            </div>
            
            <div class="h-[1px] bg-[#cccccc]"></div>

            <div class="flex flex-wrap gap-y-5 my-3">

                <div class="w-full flex flex-wrap md:flex-nowrap items-center">
                    <h3 class="w-full sm:w-[200px] text-base font-bold my-0 ">Accommodation</h3>
                    <p class="w-full sm:w-auto my-0 text-base">
                        <?php echo esc_html( get_post_meta( $post_id, 'accommodation_bed_room', true ) ); ?> bedroom(s), 
                        <?php echo esc_html( get_post_meta( $post_id, 'accommodation_bath_room', true ) ); ?> bathroom(s)
                    </p>
                </div>
                
                <div class="w-full flex flex-wrap md:flex-nowrap items-center">
                    <h3 class="w-full sm:w-[200px] text-base font-bold my-0 ">Rent</h3>
                    <p class="w-full sm:w-auto my-0 text-base">$<?php echo esc_html( get_post_meta( $post_id, 'information_rent', true ) ); ?></p>
                    </div>
                
                <div class="w-full flex flex-wrap md:flex-nowrap items-center">
                    <h3 class="w-full sm:w-[200px] text-base font-bold my-0 ">Date Available</h3>
                    <p class="w-full sm:w-auto my-0 text-base"><?php echo esc_html( get_post_meta( $post_id, 'information_date', true ) ); ?></p>
                    </div>
            </div>
        </div> <!-- Content -->
    </div>
</div>

<div class="h-[1px] bg-[#cccccc]"></div>
<div class="flex flex-wrap">
    <!-- Content Column -->
    <div class="w-full md:w-2/3 lg:w-3/4">
        <div class="px-5 pb-5"> <!-- Content -->
            <?php if ($description): ?>
                <h3 class="text-xl font-semibold ">Property details</h3>
                <div class="pro-description text-base">
                <?php echo wp_kses_post( $description ); ?>
                </div>
            <?php endif; ?>
        </div> <!-- Content -->
    </div>

    <!-- Sidebar Column -->
    <div class="w-full md:w-1/3 lg:w-1/4">
        <div class="px-5 pb-5"> <!-- Sidebar -->
            <h3 class="text-lg font-bold">Share On Social Media</h3>

            <div class="flex items-center gap-3 mb-10">
                <a class="w-12 h-12 flex justify-center items-center no-underline text-white bg-[#1DB4D6] rounded-full hover:text-white hover:bg-d-global-0 transition duration-100 ease-in-out mb-5" href="!#">
                    <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 18 18">
                        <path d="M3 7H1a1 1 0 0 0-1 1v8a2 2 0 0 0 4 0V8a1 1 0 0 0-1-1Zm12.954 0H12l1.558-4.5a1.778 1.778 0 0 0-3.331-1.06A24.859 24.859 0 0 1 6 6.8v9.586h.114C8.223 16.969 11.015 18 13.6 18c1.4 0 1.592-.526 1.88-1.317l2.354-7A2 2 0 0 0 15.954 7Z"/>
                    </svg>
                </a>
                <a class="w-12 h-12 flex justify-center items-center no-underline text-white bg-[#1DB4D6] rounded-full hover:text-white hover:bg-d-global-0 transition duration-100 ease-in-out mb-5" href="!#">
                    <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 18 18">
                        <path d="M3 7H1a1 1 0 0 0-1 1v8a2 2 0 0 0 4 0V8a1 1 0 0 0-1-1Zm12.954 0H12l1.558-4.5a1.778 1.778 0 0 0-3.331-1.06A24.859 24.859 0 0 1 6 6.8v9.586h.114C8.223 16.969 11.015 18 13.6 18c1.4 0 1.592-.526 1.88-1.317l2.354-7A2 2 0 0 0 15.954 7Z"/>
                    </svg>
                </a>
                <a class="w-12 h-12 flex justify-center items-center no-underline text-white bg-[#1DB4D6] rounded-full hover:text-white hover:bg-d-global-0 transition duration-100 ease-in-out mb-5" href="!#">
                    <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 18 18">
                        <path d="M3 7H1a1 1 0 0 0-1 1v8a2 2 0 0 0 4 0V8a1 1 0 0 0-1-1Zm12.954 0H12l1.558-4.5a1.778 1.778 0 0 0-3.331-1.06A24.859 24.859 0 0 1 6 6.8v9.586h.114C8.223 16.969 11.015 18 13.6 18c1.4 0 1.592-.526 1.88-1.317l2.354-7A2 2 0 0 0 15.954 7Z"/>
                    </svg>
                </a>

            </div>

            <div class="btn-group">
                <a class="min-w-56 inline-flex px-7 justify-between items-center py-2.5 text-base text-d-global-0 no-underline border-2 border-d-global-0 border-solid rounded-full hover:text-white hover:bg-d-global-0 transition duration-100 ease-in-out mb-5" href="!#">
                    Apply Now
                    <svg class="ms-3 transition duration-200 ease-in-out" viewBox="326.172 261.6169 8.1 12.7998" width="8.1" height="12.7998" xmlns="http://www.w3.org/2000/svg">
                        <path id="Path_152" data-name="Path 152" d="M 333.261 261.617 C 332.992 261.615 332.734 261.712 332.542 261.885 L 326.466 267.39 C 326.074 267.749 326.074 268.327 326.466 268.685 L 332.542 274.192 C 333.13 274.654 334.052 274.366 334.2 273.673 C 334.258 273.395 334.174 273.111 333.97 272.897 L 328.612 268.043 L 333.97 263.188 C 334.525 262.692 334.279 261.837 333.527 261.649 C 333.44 261.629 333.351 261.617 333.261 261.617 Z" fill="currentColor" style="transform-origin: 330.222px 268.017px;" transform="matrix(-1, 0, 0, -1, 0, 0)"/>
                    </svg>
                </a>
            
                <a class="min-w-56 inline-flex px-7 justify-between items-center py-2.5 text-base text-d-global-0 no-underline border-2 border-d-global-0 border-solid rounded-full hover:text-white hover:bg-d-global-0 transition duration-100 ease-in-out mb-5" href="!#">
                    Book a viewing time
                    <svg class="ms-3 transition duration-200 ease-in-out" viewBox="326.172 261.6169 8.1 12.7998" width="8.1" height="12.7998" xmlns="http://www.w3.org/2000/svg">
                        <path id="Path_152" data-name="Path 152" d="M 333.261 261.617 C 332.992 261.615 332.734 261.712 332.542 261.885 L 326.466 267.39 C 326.074 267.749 326.074 268.327 326.466 268.685 L 332.542 274.192 C 333.13 274.654 334.052 274.366 334.2 273.673 C 334.258 273.395 334.174 273.111 333.97 272.897 L 328.612 268.043 L 333.97 263.188 C 334.525 262.692 334.279 261.837 333.527 261.649 C 333.44 261.629 333.351 261.617 333.261 261.617 Z" fill="currentColor" style="transform-origin: 330.222px 268.017px;" transform="matrix(-1, 0, 0, -1, 0, 0)"/>
                    </svg>
                </a>
            </div>




        </div> <!-- Sidebar -->
    </div>

</div>