<?php
if ( ! defined( 'ABSPATH' ) ) exit;

$weekly_rental = get_post_meta($post_id , 'information_rent' , true);
$available_date = get_post_meta($post_id , 'information_date' , true);
$bedroom = get_post_meta($post_id , 'accommodation_bed_room' , true);
$bathroom = get_post_meta($post_id , 'accommodation_bath_room' , true);
$carsno = intval(get_post_meta($post_id, 'accommodation_automobile', true)) + intval(get_post_meta($post_id, 'other_parking', true));
$address = get_post_meta($post_id , 'information_address' , true);
$avail_date = get_post_meta($post_id , 'information_date' , true);
$property_rent = get_post_meta($post_id , 'information_rent', true);
$rental_period = get_post_meta($post_id , 'property_rental_period', true);


// Primary Colors
$pColor = sanitize_hex_color($template_colors['ipp_primary_color'] ?? '#1d4ed8');
$pColorH = sanitize_hex_color($template_colors['ipp_primary_color_h'] ?? '#091057');

// Secondary Colors
$sColor = sanitize_hex_color($template_colors['ipp_secondary_color'] ?? '#0433ff');
$sColorH = sanitize_hex_color($template_colors['ipp_secondary_color_h'] ?? '#020fa6');

?>


<a class="w-full no-underline whitespace-nowrap overflow-hidden drop-shadow-md" href="<?php echo esc_url( get_permalink() ); ?>">
    <div class="ipp-archive_property text-gray-600 rounded-xl overflow-hidden bg-white">

        <div class="ipp-archive-property_thumbnail w-full h-72 overflow-hidden">
            <?php 
                if ( has_post_thumbnail( get_the_ID() ) ) {
                    echo get_the_post_thumbnail( 
                        get_the_ID(), 
                        'thumbnail', // Use the 'thumbnail' size here
                        array( 'class' => 'w-full h-full object-cover object-center hover:scale-110 transition-transform duration-500' ) 
                    );
                } else {
                    echo '<img src="' . esc_url( plugin_dir_url( dirname( __FILE__, 2 ) ) . 'assets/img/placeholder-image.jpg' ) . '" alt="Placeholder" class="w-full h-full object-cover object-center hover:scale-110 transition-transform duration-500" />';
                }
            ?>
        </div>

        <div class="ipp-archive-property_content flex px-5 py-8 transition-all duration-300">
            <div class="w-full">
            <h3 class="ipp-archive-property_title text-black text-xl lowercase font-semibold mb-0 truncate"> <?php echo esc_html( strtoupper( strtolower( get_the_title() ) ) ); ?></h3>

                <?php if ($address): ?>
                <div class="flex items-center mt-1">
                <img class="me-1" src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__, 2 ) ) . 'assets/img/ipp-location.svg' ); ?>" />
                <div class="text-base my-0.5 overflow-hidden text-ellipsis"><?php echo esc_html($address) ?></div>
                </div>
                <?php endif;?>

                <div class="ipp-archive-property_rentalBlock flex justify-between mt-5">
                    <?php if ($weekly_rental): ?>
                    <div class="flex items-center me-5">
                        <div class="ipp-primary-color text-base font-bold  me-1">$<?php echo esc_html($weekly_rental) ?></div>
                        <span class="text-sm">/<?php echo esc_attr($rental_period) ?></span>
                    </div>
                    <?php endif;?>

                    <div class="flex items-center gap-x-2 text-xs font-medium">
                        <?php if ($bedroom): ?>
                        <div class="flex items-center">
                        <img class="me-1" src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__, 2 ) ) . 'assets/img/ipp-bed.svg' ); ?>" />
                        <div><?php echo esc_html($bedroom) ?></div>
                        </div>
                        <?php endif; ?>

                        <?php if ($bathroom): ?>
                        <div class="flex items-center">
                        <img class="me-1" src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__, 2 ) ) . 'assets/img/ipp-bathroom.svg' ); ?>" />
                        <div><?php echo esc_html($bathroom) ?></div>
                        </div>
                        <?php endif; ?>

                        <?php if ($carsno): ?>
                        <div class="flex items-center">
                        <img class="me-1" src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__, 2 ) ) . 'assets/img/ipp-parking.svg' ); ?>" />
                        <div><?php echo esc_html($carsno) ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if ($avail_date): ?>
                <div class="flex items-center mt-2">
                    <span class="text-sm me-1">Available Date:</span>
                    <div class="text-sm"><?php echo esc_html($avail_date) ?></div>
                </div>
                <?php endif; ?>



                
            </div>
        </div>

        
    </div>
</a>