<?php
if ( ! defined( 'ABSPATH' ) ) exit;
    $columns = get_option(''); // Ensure an option key is defined
?>

<div class="columns-3" data-aos="fade-up" data-aos-delay="400" data-aos-offset="100">
    <a href="<?php echo esc_url(get_permalink()); ?>">
        <?php
            echo get_the_post_thumbnail(get_the_ID(), 'large', array('class' => 'alignleft'));
        ?>
    </a>
    <div class="title">
        <a href="<?php echo esc_url(get_permalink()); ?>">
            <h3><?php echo esc_html(strtoupper(strtolower(get_the_title()))); ?></h3>
        </a>
        <p><?php echo esc_html(get_post_meta($post_id, 'information_address', true)); ?></p>
    </div>
    <div class="divider"></div>
    <div class="details">
        <?php
            $weekly_rent = get_post_meta($post_id, 'information_rent', true);
            $available_date = get_post_meta($post_id, 'information_date', true);
        ?>
        <div class="rent_type">Weekly Rental: $<?php echo esc_html($weekly_rent); ?></div>
        <div class="time">Available date: <?php echo esc_html($available_date); ?></div>
    </div>
    <div class="amenities">
        <span class="bedroom"><?php echo esc_html(get_post_meta($post_id, 'accommodation_bed_room', true)); ?></span>
        <span class="bathroom"><?php echo esc_html(get_post_meta($post_id, 'accommodation_bath_room', true)); ?></span>
        <span class="room"><?php echo esc_html(intval(get_post_meta($post_id, 'accommodation_automobile', true)) + intval(get_post_meta($post_id, 'other_parking', true))); ?></span>
    </div>
    <div class="divider"></div>
</div>
