<?php
if ( ! defined( 'ABSPATH' ) ) exit;

?>

<div class="px-">
    <a href="<?php echo esc_url(get_permalink()); ?>">
        <div class="w-full rounded-lg overflow-hidden h-[235px]">
        <?php
            echo get_the_post_thumbnail(get_the_ID(), 'large', array('class' => 'w-full h-full object-cover object-center'));
        ?>
        </div>
    </a>
    <div class="flex flex-wrap">
        <a class="w-full no-underline whitespace-nowrap overflow-hidden mt-3" href="<?php echo esc_url(get_permalink()); ?>">
            <h3 class="text-lg text-d-global-0 font-bold mb-0 overflow-hidden text-ellipsis"><?php echo esc_html(strtoupper(strtolower(get_the_title()))); ?></h3>
        </a>
        <p class="text-base text-gray-800 mb-3"><?php echo esc_html(get_post_meta($post_id, 'information_address', true)); ?></p>
    </div>

    <div class="h-[1px] bg-[#cccccc]"></div>
    
    <div class="flex justify-between mt-3">
        <?php
            $weekly_rental = get_post_meta($post_id, 'information_rent', true);
            $available_date = get_post_meta($post_id, 'information_date', true);

            if ($weekly_rental) {
                echo '<div class="text-sm">Weekly Rental: $' . esc_html($weekly_rental) . '</div>';
            }
            if ($available_date) {
                echo '<div class="text-xs">Available date: ' . esc_html($available_date) . '</div>';
            }
        ?>
    </div>

    <div class="flex gap-x-4 text-xs font-bold my-4">
        <?php
            $bedroom = get_post_meta($post_id, 'accommodation_bed_room', true);
            if ($bedroom) :
        ?>
            <div class="flex items-center gap-x-2">
                <img class="w-5" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__, 1)) . 'public/assets/img/bedroom.svg'); ?>" alt="Bedroom icon"/>
                <div class="bedroom"><?php echo esc_html($bedroom); ?></div>
            </div>
        <?php endif; ?>
        
        <?php
            $bathroom = get_post_meta($post_id, 'accommodation_bath_room', true);
            if ($bathroom) :
        ?>
            <div class="flex items-center gap-x-2">
                <img class="w-5" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__, 1)) . 'public/assets/img/bathroom.svg'); ?>" alt="Bathroom icon"/>
                <div class="bathroom"><?php echo esc_html($bathroom); ?></div>
            </div>
        <?php endif; ?>

        <?php
            $carsno = intval(get_post_meta($post_id, 'accommodation_automobile', true)) + intval(get_post_meta($post_id, 'other_parking', true));
            if ($carsno) :
        ?>
            <div class="flex items-center gap-x-2">
                <img class="w-5" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__, 1)) . 'public/assets/img/automobile.svg'); ?>" alt="Car icon"/>
                <div class="room"><?php echo esc_html($carsno); ?></div>
            </div>
        <?php endif; ?>
    </div>

    <div class="h-[1px] bg-[#cccccc]"></div>
</div>
