<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class IntegratePalace_Properties_Public {
    private $plugin_name;
    private $version;

    public function __construct( $plugin_name, $version ) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
        add_action( 'wp_ajax_nopriv_ajax_load_button', array($this, 'ajax_load_button' ));
        add_action( 'wp_ajax_ajax_load_button', array($this, 'ajax_load_button' ));
    }

    public function enqueue_styles() {
        wp_enqueue_style( 'swiper-style', INTEGRATE_PALACE_P_PLUGIN_URI . 'public/assets/css/swiper-bundle.min.css', array(), $this->version, 'all' );
        wp_enqueue_style( $this->plugin_name, INTEGRATE_PALACE_P_PLUGIN_URI . 'public/assets/css/ipp-main.css', array(), $this->version, 'all' );
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'swiper-script', INTEGRATE_PALACE_P_PLUGIN_URI . 'public/assets/js/swiper-bundle.min.js', array( 'jquery' ), $this->version, false );
        wp_enqueue_script( $this->plugin_name, INTEGRATE_PALACE_P_PLUGIN_URI . 'public/assets/js/ipp-scripts.js', array( 'jquery' ), $this->version, false );

        // Localize script with AJAX URL
        wp_localize_script($this->plugin_name, 'ajax_params', array(
            'ajax_url' => esc_url(admin_url('admin-ajax.php')),
        ));
    }

    public function integrate_palace_enqueue_fonts() {
        $options = get_option(IPPR_SETTINGS, []);
        $heading_font = $options["heading_font_family"] ?? 'Euclid Circular B';
        $body_font = $options["body_font_family"] ?? 'Euclid Circular B';
        $button_font = $options["btn_font_family"] ?? 'Euclid Circular B';

        if ($heading_font === 'initial' && $body_font === 'initial' && $button_font === 'initial') {
            return;
        }
    
        $euclid_font_enqueued = false;
    
        if ($heading_font !== 'initial') {
            if ($heading_font === 'Euclid Circular B') {
                wp_enqueue_style('ipp-heading-font', plugin_dir_url(__FILE__) . 'assets/fonts/ipp-fonts.css', array(), null, 'all');
                $euclid_font_enqueued = true;
            } else {
                $heading_font_url = 'https://fonts.googleapis.com/css?family=' . urlencode($heading_font);
                wp_enqueue_style('ipp-heading-font', esc_url($heading_font_url), array(), null);
            }
        }
    
        if ($body_font !== 'initial') {
            if ($body_font === 'Euclid Circular B') {
                if (!$euclid_font_enqueued) {
                    wp_enqueue_style('ipp-body-font', plugin_dir_url(__FILE__) . 'assets/fonts/ipp-fonts.css', array(), null, 'all');
                }
            } else {
                $body_font_url = 'https://fonts.googleapis.com/css?family=' . urlencode($body_font);
                wp_enqueue_style('ipp-body-font', esc_url($body_font_url), array(), null);
            }
        }

        if ($button_font !== 'initial') {
            if ($button_font === 'Euclid Circular B') {
                if (!$euclid_font_enqueued) {
                    wp_enqueue_style('ipp-body-font', plugin_dir_url(__FILE__) . 'assets/fonts/ipp-fonts.css', array(), null, 'all');
                }
            } else {
                $button_font_url = 'https://fonts.googleapis.com/css?family=' . urlencode($body_font);
                wp_enqueue_style('ipp-button-font', esc_url($button_font_url), array(), null);
            }
        }
    }

    public function use_palace_property_template( $template ) {
        $property_post_type = 'palace-properties';
        if ( is_singular( $property_post_type ) ) {
            $theme_template = locate_template( 'single-palace_property.php' );
            return $theme_template ?: INTEGRATE_PALACE_P_PLUGIN_DIR . 'public/single-palace_property.php';
        } elseif ( is_post_type_archive( $property_post_type ) ) {
            $theme_template = locate_template( 'archive-palace_property.php' );
            return $theme_template ?: INTEGRATE_PALACE_P_PLUGIN_DIR . 'public/archive-palace_property.php';
        }
        return $template;
    }

    public function ajax_load_button() {
        $options = get_option( 'ipp_settings' );
        $template_type = sanitize_text_field(get_option('ipp_select_template', 'palace-property'));
        $paged = isset($_POST['page']) ? intval($_POST['page']) : 1;
        $posts_per_page = absint($options['property_per_page'] ?? 9);
        
        $query_args = array(
            'post_type'      => 'palace-properties',
            'orderby'        => 'date',
            'order'          => 'DESC',
            'posts_per_page' => $posts_per_page,
            'paged'          => $paged,
        );
    
        $the_query = new WP_Query( $query_args );
        $response = '';
    
        // Generate content
        if ( $the_query->have_posts() ) :
            while ( $the_query->have_posts() ) :
                $the_query->the_post();
    
                ob_start(); // Capture the output
                $post_id = get_the_ID();
                
                // Sanitize and include the template file
                $template_path = dirname( plugin_dir_path( __FILE__ ) ) . '/public/content/archive/' . sanitize_file_name( $template_type ) . '.php';
                if ( file_exists( $template_path ) ) {
                    include $template_path;
                }
                $response .= ob_get_clean();
    
            endwhile;
        endif;
    
        // Reset post data
        wp_reset_postdata();
    
        // Return response as JSON
        wp_send_json_success( array(
            'content'    => $response,
            'max_pages'  => $the_query->max_num_pages,
        ) );
    
        wp_die();
    }
    
}
