jQuery(document).ready(function ($) {
  /* --------------------------------
  Default slider
  ------------------------------ */

  const wppThumbSwiper = new Swiper(".ipp-slider-thumb", {
    slidesPerView: 4,
    spaceBetween: 5,
    freeMode: true,
    watchSlidesVisibility: true,
    watchSlidesProgress: true,
  });

  const wppSwiper = new Swiper(".ipp-slider", {
    slidesPerView: 1,
    spaceBetween: 0,
    pagination: {
      el: ".swiper-pagination",
      dynamicBullets: true,
    },
    thumbs: {
      swiper: wppThumbSwiper,
    },
  });

  /* --------------------------------
  Classic slider
  ------------------------------ */

  const classicThumbSwiper = new Swiper(".ipp-classic-slider-thumb", {
    slidesPerView: 7,
    spaceBetween: 10,
    freeMode: true,
    watchSlidesVisibility: true,
    watchSlidesProgress: true,
  });

  const classicSwiper = new Swiper(".ipp-classic-slider", {
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    thumbs: {
      swiper: classicThumbSwiper,
    },
  });

  /* --------------------------------
  load prperties archive page
  ------------------------------ */

  let page = 1;
  let max_pages = 1;

  $("#ipp-load-more").on("click", function () {
    const $button = $(this);
    page++;

    $button.html(
      '<svg aria-hidden="true" role="status" class="inline w-4 h-4 me-3 text-gray-200 animate-spin dark:text-gray-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/><path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="#1C64F2"/></svg> Loading'
    );
    $button.prop("disabled", true);

    $.ajax({
      url: ajax_params.ajax_url,
      type: "post",
      data: {
        action: "ajax_load_button",
        page: page,
      },
      success: function (response) {
        if (response.success) {
          // Append the new posts content
          $(".ipp-archive-properties").append(response.data.content);
          max_pages = response.data.max_pages;
          if (page >= max_pages) {
            $button.hide();
          }
        }
      },
      error: function (xhr, status, error) {
        console.error("AJAX Error:", status, error);
      },
      complete: function () {
        $button.prop("disabled", false);
        $button.html("Load More");
      },
    });
  });

  /* --------------------------------
  Archive parallax header
  ------------------------------ */

  $(window).scroll(function () {
    var scrollPos = $(this).scrollTop();
    $("#proprety-search").css(
      "background-position",
      "center " + -scrollPos * 0.2 + "px"
    );
  });

  /* --------------------------------
  Swiper lightbox for gallery modal
  ------------------------------ */

  $(".swiper-slide_thumbnail, .ipp-slider-slide_expand").on(
    "click",
    function () {
      var clickedIndex = $(this).parent().index();

      // Preloader HTML
      var modalSlider = `
    <div class="ipp-gallery-modal">
      <div class="ipp-gallery-modal_content">
        <!-- Close Button -->
        <span class="ipp-gallery-modal_close">&times;</span>
        <div class="swiper-pagination"></div>
        <!-- Main Slider for Modal -->
        <div class="swiper-container ipp-modal-slider flex">
          <div class="swiper-wrapper items-center" id="ipp-modal-slider">
            <!-- Slides will be inserted dynamically -->
          </div>
          <!-- Navigation for Modal Slider -->
          <div class="swiper-button-next rounded-full bg-gray-200 hover:bg-white w-8 md:w-12 h-8 md:h-12"></div>
          <div class="swiper-button-prev rounded-full bg-gray-200 hover:bg-white w-8 md:w-12 h-8 md:h-12"></div>
        </div>

        <!-- Thumbnail Slider for Modal -->
        <div class="w-full hidden md:flex justify-center absolute inset-x-0 bottom-0">
          <div class="swiper-container ipp-modal-slider_thumbs">
            <div class="swiper-wrapper items-center" id="ipp-modal-slider_thumbs">
              <!-- Thumbnail slides will be inserted dynamically -->
            </div>
          </div>
        </div>
      </div>
    </div>
  `;

      // Add the modal slider HTML to the page
      $("#ipp-gallery-modal_slider").html(modalSlider);

      // Show preloader (optional, you can use your own loader)
      $("#ipp-gallery-modal_slider").append(`
    <div id="ipp-preloader">
      <svg aria-hidden="true" role="status" class="w-10 h-10 text-white animate-spin" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/>
        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="#0433ff"/>
      </svg>
    </div>
    `);
      $("#ipp-preloader").show();

      // Fetch all image src links from the gallery
      var imageSrcArray = [];

      $(".swiper-slide_thumbnail").each(function () {
        var imgSrc = $(this).attr("src");
        imageSrcArray.push(imgSrc);
      });

      // Append custom HTML for the main modal slider
      imageSrcArray.forEach(function (src) {
        var WPPModalSlide =
          `
      <div class="swiper-slide overflow-hidden cursor-zoom-in">
        <div class="swiper-zoom-container">
          <img src="` +
          src +
          `" class="ipp-modal-img w-full object-contain" alt="palace-properties"/>
        </div>
      </div>
    `;
        $("#ipp-modal-slider").append(WPPModalSlide);
      });

      // Append custom HTML for the thumbnail slider
      imageSrcArray.forEach(function (src) {
        var WPPModalThumbs =
          `
      <div class="swiper-slide h-16 md:h-20 rounded-lg overflow-hidden">
        <img src="` +
          src +
          `" class="w-full h-full object-cover cursor-pointer hover:scale-110 transition-all duration-500" alt="palace-properties"/>
      </div>
    `;
        $("#ipp-modal-slider_thumbs").append(WPPModalThumbs);
      });

      // Hide preloader and show the modal content
      $("#ipp-preloader").fadeOut(function () {
        $("#ipp-preloader").remove(); // Remove preloader after hiding it
      });

      // Initialize Swiper for the modal thumbnail slider
      const integrate_palace_ModalSliderThumbs = new Swiper(
        ".ipp-modal-slider_thumbs",
        {
          slidesPerView: 7,
          spaceBetween: 10,
          freeMode: true,
          watchSlidesVisibility: true,
          watchSlidesProgress: true,
        }
      );

      // Initialize Swiper for the modal main slider
      const integrate_palace_ModalSlider = new Swiper(".ipp-modal-slider", {
        slidesPerView: 1,
        spaceBetween: 0,
        pagination: {
          el: ".swiper-pagination",
          type: "fraction",
        },
        navigation: {
          nextEl: ".swiper-button-next",
          prevEl: ".swiper-button-prev",
        },
        loop: false,
        initialSlide: clickedIndex,
        thumbs: {
          swiper: integrate_palace_ModalSliderThumbs,
        },
        zoom: {
          maxRatio: 2,
          toggle: true,
        },
      });

      $(".ipp-modal-slider .swiper-slide").on("click", function () {
        // Toggle zoom on single click
        integrate_palace_ModalSlider.zoom.toggle();
      });

      // Close modal on clicking close button
      $(".ipp-gallery-modal_close").on("click", function () {
        $(".ipp-gallery-modal").fadeOut(function () {
          $("#ipp-gallery-modal_slider").empty(); // Clear modal content
        });
      });
    }
  );

  /* --------------------------------
  Limit single property details
  ------------------------------ */

  $(".ipp-single-read-more_button").click(function () {
    var detailsContent = $(".ipp-details_content");
    var arrow = $(".ipp-single-read-more_arrow");

    if (detailsContent.is(":visible")) {
      detailsContent.hide();
      arrow.addClass("-rotate-180");
    } else {
      detailsContent.show();
      arrow.removeClass("-rotate-180");
    }
  });

  /* --------------------------------
    load prperties archive page
    ------------------------------ */

  $('[data-test="search__mode-switch"]').on("click", function () {
    const checkbox = $(this).find('input[type="checkbox"]');
    const isChecked = !checkbox.prop("checked");

    checkbox.prop("checked", isChecked);

    if (isChecked) {
      $('[data-test="search-autocomplete"]').addClass("hidden");
      $('[data-test="search-byregion"]').removeClass("hidden");
      $('[data-test="search-autocomplete-divider"]').addClass("hidden");
    } else {
      $('[data-test="search-autocomplete"]').removeClass("hidden");
      $('[data-test="search-byregion"]').addClass("hidden");
      $('[data-test="search-autocomplete-divider"]').removeClass("hidden");
    }
  });

  $(".ipp-archive-list").on("click", function () {
    const postContainer = $(".ipp-archive-properties");
    postContainer.addClass("ipp-archive-layout_list");
  });

  $(".ipp-archive-grid").on("click", function () {
    const postContainer = $(".ipp-archive-properties");
    postContainer.removeClass("ipp-archive-layout_list");
  });
});
