<?php
/**
 * Template Name: Property
 * Template Post Type: page
 *
 * @link https://developer.wordpress.org/themes/template-files-section/page-template-files/
 *
 * @package Kiwi
 */
if ( ! defined( 'ABSPATH' ) ) exit;
get_header();

$options = get_option( 'integrate_palace_settings' );
$template_type = sanitize_text_field(get_option('integrate_palace_select_template', 'palace-property'));
$container = isset( $options['archive_layout_type'] ) ? sanitize_text_field($options['archive_layout_type']) : 'w-full';
$search_filter = isset( $options['archive_search_filter'] ) ? sanitize_text_field($options['archive_search_filter']) : 'palace-property-search';
$integrate_palace_property_layout = isset( $options['property_layout'] ) ? sanitize_text_field($options['property_layout']) : 'grid-layout';
$template_colors = get_option('integrate_palace_settings')[$template_type] ?? [];



        $primary_btn_color = get_option('ipp_settings')[$template_type] ?? [];

        $primary_button_colors = array(
            'ipp_primary_button_color' => '#fff',
            'ipp_primary_button_color_h' => '#fff',
            'ipp_primary_button_bg_color' => '#1d4ed8',
            'ipp_primary_button_bg_color_h' => '#091057',
            'ipp_primary_button_border_color' => '#1d4ed8',
            'ipp_primary_button_border_color_h' => '#091057',
        );

        $primary_button_color = array_merge($primary_button_colors, $primary_btn_color);

        $posts_per_page = isset( $options['property_per_page'] ) ? absint($options['property_per_page']) : 9;
?>

<!-- ======= Archive Property ======= -->
<div class="ipp-archive-page w-full">

<!-- Search Filter -->
<?php include( INTEGRATE_PALACE_P_PLUGIN_DIR . 'public/content/archive/' . sanitize_file_name($search_filter) . '.php'); ?>

<div class="<?php echo esc_attr($container); ?>">
    <div class="ipp-archive-content my-5 md:my-12">
        <div class="grid items-center justify-items-end my-5 pe-5">
            <div class="hidden sm:flex gap-2">
                <button class="ipp-archive-list bg-gray-200 hover:bg-gray-300 cursor-pointer border-0 rounded p-2 transition-all duration-300">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-list">
                        <line x1="8" y1="6" x2="21" y2="6"></line>
                        <line x1="8" y1="12" x2="21" y2="12"></line>
                        <line x1="8" y1="18" x2="21" y2="18"></line>
                        <line x1="3" y1="6" x2="3" y2="6"></line>
                        <line x1="3" y1="12" x2="3" y2="12"></line>
                        <line x1="3" y1="18" x2="3" y2="18"></line>
                    </svg>
                </button>
                <button class="ipp-archive-grid bg-gray-200 hover:bg-gray-300 cursor-pointer border-0 rounded p-2 transition-all duration-300">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-grid">
                        <rect x="3" y="3" width="7" height="7"></rect>
                        <rect x="14" y="3" width="7" height="7"></rect>
                        <rect x="14" y="14" width="7" height="7"></rect>
                        <rect x="3" y="14" width="7" height="7"></rect>
                    </svg>
                </button>
            </div>
        </div>
        <?php
            $layout_class = ($integrate_palace_property_layout == 'list-layout') ? 'ipp-archive-layout_list' : '';
            echo '<div class="ipp-archive-properties ' . esc_attr($layout_class) . ' px-1 md:px-5 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8 md:gap-y-12">';

            $meta_query = array('relation' => 'AND');
            $args = array(
                'post_type'         => 'palace-properties',
                'orderby'           => 'date',
                'order'             => 'DESC',
                'posts_per_page'    => $posts_per_page,
                'post_status'       => 'publish'
            );

            if ( isset( $_GET['filter'] ) ) {
                $args['orderby'] = 'id';
                $args['order'] = 'DESC';
            
                // Search text filter
                if ( isset( $_GET['search_text'] ) ) {
                    $meta_query[] = array(
                        'key'     => 'information_address',
                        'value'   => sanitize_text_field( wp_unslash( $_GET['search_text'] ) ),
                        'compare' => 'LIKE',
                    );
                }
            
                // Price range filter
                if ( isset( $_GET['price_from'] ) && isset( $_GET['price_to'] ) ) {
                    $meta_query[] = array(
                        'key'     => 'information_rent',
                        'value'   => array( absint( $_GET['price_from'] ), absint( $_GET['price_to'] ) ),
                        'type'    => 'NUMERIC',
                        'compare' => 'BETWEEN',
                    );
                }
            
                // Bedroom filter
                if ( isset( $_GET['bedroom'] ) && str_replace( '%20', ' ', $_GET['bedroom'] ) !== 'Any Bedrooms' ) {
                    $bedrooms = absint( $_GET['bedroom'] );
                    $meta_query[] = array(
                        'key'     => 'accommodation_bed_room',
                        'value'   => $bedrooms,
                        'compare' => ( $bedrooms === 6 ) ? '>=' : '=',
                        'type'    => 'NUMERIC',
                    );
                }
            
                // Bathroom filter
                if ( isset( $_GET['bathroom'] ) && str_replace( '%20', ' ', $_GET['bathroom'] ) !== 'Any Bathrooms' ) {
                    $bathrooms = absint( $_GET['bathroom'] );
                    $meta_query[] = array(
                        'key'     => 'accommodation_bath_room',
                        'value'   => $bathrooms,
                        'compare' => ( $bathrooms === 6 ) ? '>=' : '=',
                        'type'    => 'NUMERIC',
                    );
                }
            
                // Region filter
                if ( isset( $_GET['region'] ) && str_replace( '%20', ' ', $_GET['region'] ) !== 'All Region' ) {
                    $meta_query[] = array(
                        'key'     => 'information_region',
                        'value'   => sanitize_text_field( wp_unslash( $_GET['region'] ) ),
                        'compare' => '=',
                    );
                }
            }
            

            $the_query = new WP_Query($args);

            if ($the_query->have_posts()) :
                while ($the_query->have_posts()) :
                    $the_query->the_post();
                    $post_id = get_the_ID();
                    include(INTEGRATE_PALACE_P_PLUGIN_DIR . 'public/content/archive/' . sanitize_file_name($template_type) . '.php');
                endwhile;
                wp_reset_postdata();
            else :
                echo '<p>' . esc_html__('Sorry, no properties found.', 'integrate-palace-properties') . '</p>';
            endif;
        ?>
        </div>

        <!-- pagination here -->
        <?php if ($the_query->found_posts > $posts_per_page) : ?>
            <div class="w-full mt-5 md:mt-12">
                <div class="flex justify-center">
                    <button id="ipp-load-more" class="ipp-primary-button flex items-center justify-center gap-3 appearance-none cursor-pointer border-solid text-sm md:min-w-[170px] md:min-h-[52] box-border transition-all">
                        <?php esc_html_e('Load More', 'integrate-palace-properties'); ?>
                    </button>
                </div>
            </div>
        <?php endif; ?>
    </div> <!-- .ipp-archive-content -->
</div> <!-- .container -->
</div> <!-- .ipp-archive-page -->

<?php
get_footer();
