<?php
/**
 * Plugin Name: Integrate Palace Properties
 * Description: A plugin to syncronize wp palace properties to your wordpress blog/website.
 * Version: 1.0.0
 * Author: SAFDAR
 * Author URI: https://wp-palace.kiwibrain.co.nz/
 * Text Domain: integrate-palace-properties
 * License: GPLv2
 */

if ( ! defined( 'ABSPATH' ) ) exit;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

// Define plugin version.
define( 'INTEGRATE_PALACE_P_VERSION', '1.0.0' );
define( 'IPPR_SETTINGS', 'ippr-template-settings' );
define('INTEGRATE_PALACE_P_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('INTEGRATE_PALACE_P_PLUGIN_URI', plugin_dir_url( __FILE__ ));

// Activation and deactivation hooks.
function integrate_palace_activate() {

    $integrate_palace_activator = INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/class-integratepalacep-activator.php';

    if ( ! file_exists( $integrate_palace_activator ) ) {
        wp_die( __( 'Required activation files are missing. Please reinstall the plugin.', 'integrate-palace-properties' ) );
    }

    require_once $integrate_palace_activator;

    if ( class_exists( 'IntegratePalace_Properties_Activator' ) ) {
        IntegratePalace_Properties_Activator::activate();
    }

}

register_activation_hook( __FILE__, 'integrate_palace_activate' );

// Include the main class file.
require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/class-integratepalacep.php';

// Run the plugin.
function integrate_palace_run() {
    $plugin = new IntegratePalace_Properties();
    $plugin->run();

}

integrate_palace_run();
