<?php

if ( class_exists( 'WP_Customize_Section' ) && !class_exists( 'IntegratePalace_Properties_Property_Customize_Section' ) ) {

  class IntegratePalace_Properties_Property_Customize_Section extends WP_Customize_Section {

      public $section;

      public $type = 'ippr_section';

      public function json() {
          $array = wp_array_slice_assoc(
              (array) $this,
              array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section' )
          );
          $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
          $array['content'] = $this->get_content();
          $array['active'] = $this->active();
          $array['instanceNumber'] = $this->instance_number;

          if ( $this->panel ) {
            $array['customizeAction'] = sprintf(
                // translators: %s is the title of the panel in the customizer
                  __( 'Customizing &#9656; %s', 'integrate-palace-properties' ),
                  esc_html( $this->manager->get_panel( $this->panel )->title )
              );
          } else {
              $array['customizeAction'] = 'Customizing';
          }

          return $array;
      }

  }

}
