<?php

// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( class_exists( 'WP_Customize_Control' ) && !class_exists( 'IntegratePalace_Properties_Section_Heading' ) ) {


    // Section Heading 
    class IntegratePalace_Properties_Section_Heading extends WP_Customize_Control {

        public $type = 'section_heading';
    
        public function render_content() {
    
            if ( ! empty( $this->label ) ) {
                ?>
                <div class="ippr-heading-wrapper">
                    <label class="customizer-text">
                        <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                    </label>
                </div>
                <?php
            }
    
        }
    }
    
    // Section Heading Tabs
    class IPPR_Section_Tabs extends WP_Customize_Control {
        public $type = 'section_tabs';

        public function render_content() {
            if ( empty( $this->settings ) ) {
                return;
            }
            ?>
            <div class="nav-tab-wrapper ippr-section-tabs">
                <a href="#" 
                class="nav-tab ippr-heading-tabs-button ippr_primary_btn nav-tab-active" 
                aria-label="<?php esc_attr_e( 'Primary Button', 'integrate-palace-properties' ); ?>">
                    <span><?php esc_html_e( 'Primary', 'integrate-palace-properties' ); ?></span>
                </a>
                <a href="#" 
                class="nav-tab ippr-heading-tabs-button ippr_secondary_btn" 
                aria-label="<?php esc_attr_e( 'Secondary Button', 'integrate-palace-properties' ); ?>">
                    <span><?php esc_html_e( 'Secondary', 'integrate-palace-properties' ); ?></span>
                </a>
            </div>
            <?php
        }
    }


    // Layout Types
    class IPPR_Layout_Type extends WP_Customize_Control {
        public $type = 'layout_type';
        public $divider = '';
    
        public function to_json() {
            parent::to_json();
            $this->json['divider'] = $this->divider;
        }
    
        public function __construct( $wp_customize, $id, $args = [] ) {
            parent::__construct( $wp_customize, $id, $args );
    
            $this->divider = $args['divider'] ?? '';
        }
    
        public function render_content() {
            if ( empty( $this->choices ) ) {
                return;
            }
    
            if ( ! empty( $this->label ) ) {
                echo '<div class="ippr-title-wrapper"><span class="customize-control-title">' . esc_html( $this->label ) . '</span></div>';
            }
    
            ?>
            <label>
                <div class="customize-control-ippr-radio-image">
                    <?php foreach ( $this->choices as $value => $choice ) :
    
                        $label = isset( $choice['label'] ) ? $choice['label'] : '';
                        $tooltip = $label ? esc_attr( $label ) : '';
                        
                        // Generate the radio input and label
                        ?>
                        <input type="radio" 
                               name="<?php echo esc_attr( $this->id ); ?>" 
                               value="<?php echo esc_attr( $value ); ?>" 
                               id="<?php echo esc_attr( $this->id . '_' . $value ); ?>" 
                               <?php echo $this->link(); ?> 
                               <?php checked( $this->value(), $value ); ?> 
                               aria-label="<?php echo esc_attr( $tooltip ); ?>" />
                        <label for="<?php echo esc_attr( $this->id . '_' . $value ); ?>" class="ippr-radio-img-svg">
                            <?php echo Integrate_Palace_Properties_Icons::fetch_svg_icon( $value ); ?>
                            <?php if ( $label ) : ?>
                                <span class="ippr-tooltip" data-tooltip="<?php echo $tooltip; ?>"></span>
                            <?php endif; ?>
                        </label>
                    <?php endforeach; ?>
                </div>
            </label>
            <?php
        }
    }
    

    // Properties Per Page
    class IPPR_Property_Per_Page extends WP_Customize_Control {
        public $type = 'number';
        public $divider = '';
    
        public function to_json() {
            parent::to_json();
            $this->json['divider'] = $this->divider;
        }
    
        public function __construct( $wp_customize, $id, $args = [] ) {
            parent::__construct( $wp_customize, $id, $args );
    
            $this->divider = $args['divider'] ?? '';
        }
    
        public function render_content() {
            if ( ! empty( $this->label ) ) { ?>
                <div class="ippr-control-wrapper">
                    <div class="ippr-title-wrapper">
                        <span class="ippr-control-label"><?php echo esc_html( $this->label ); ?></span>
                    </div>
                    <div class="ippr-control-wrapper">
                        <div class="ippr-number-single">
                            <button type="button" class="ippr-minus" aria-label="<?php esc_attr_e( 'Decrease', 'integrate-palace-properties' ); ?>">
                                <span class="dashicons dashicons-minus"></span>
                            </button>
                            <div class="ippr-base-control ippr-input-control ippr-number-control">
                                <input type="number" 
                                       value="<?php echo esc_attr( $this->value() ); ?>" 
                                       <?php $this->link(); ?> 
                                       min="1" 
                                       step="1" 
                                       aria-label="<?php esc_attr_e( 'Property Per Page', 'integrate-palace-properties' ); ?>" />
                            </div>
                            <button type="button" class="ippr-plus" aria-label="<?php esc_attr_e( 'Increase', 'integrate-palace-properties' ); ?>">
                                <span class="dashicons dashicons-plus"></span>
                            </button>
                        </div>
                    </div>
                </div>
            <?php }
        }
    }
    

    // Color Picker
    class IPPR_Colors extends WP_Customize_Control {
        public $type = 'color';
        public $divider = '';
        public $tab = '';
        public $settings = [];
        public $color_label = [];
    
        public function to_json() {
            parent::to_json();
    
            $this->json['divider'] = $this->divider;
            $this->json['tab'] = $this->tab;
            $this->json['color_label'] = $this->color_label;
        }
    
        public function __construct( $wp_customize, $id, $args = array() ) {
            parent::__construct( $wp_customize, $id, $args );
    
            $this->divider     = $args['divider'] ?? '';
            $this->tab         = $args['tab'] ?? '';
            $this->color_label = $args['color_label'] ?? [];
        }
    
        public function render_content() {
            if ( empty( $this->settings ) ) {
                return;
            }
    
            if ( ! empty( $this->label ) ) {
                echo '<span class="customize-control-title title-bottom-border_dotted">' . esc_html( $this->label ) . '</span>';
            }
    
            ?>
    
            <div class="ippr-color-picker-wrapper">
                <div class="ippr-color-picker">
                    <div class="color-picker-grid">
                        <?php foreach ( $this->color_label as $color_key => $label ) : ?>
                            <div class="color-picker-row">
                                <div class="color-label"><?php echo esc_html( $label ); ?></div>
                                <div class="color-picker-set">
                                    <label>
                                        <input type="text" 
                                               class="ippr-color-picker-input"
                                               data-alpha-enabled="true"
                                               <?php $this->link( $color_key ); ?>
                                               value="<?php echo esc_attr( $this->value( $color_key ) ); ?>" />
                                    </label>
                                    <label>
                                        <input type="text" 
                                               class="ippr-color-picker-input"
                                               data-alpha-enabled="true"
                                               <?php $this->link( "{$color_key}_h" ); ?>
                                               value="<?php echo esc_attr( $this->value( "{$color_key}_h" ) ); ?>" />
                                    </label>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
    
            <?php
        }
    }
    


    class IPPR_Responsive_Button extends WP_Customize_Control {
        public $type = 'responsive_button';
        public $divider = '';
        public $settings = [];
        public $unit = '';
        public $tab = '';
        public $devices = ['desktop', 'tablet', 'mobile'];
        public $units = ['px', 'em', 'rem', '%'];
    
        // Constructor
        public function __construct($wp_customize, $id, $args = []) {
            parent::__construct($wp_customize, $id, $args);
            $this->divider = $args['divider'] ?? '';
            $this->tab = $args['tab'] ?? '';
        }
    
        // JSON serialization method for control
        public function to_json() {
            parent::to_json();
            $this->json['value'] = $this->value();
            $this->json['divider'] = $this->divider;
            $this->json['tab'] = $this->tab;
            $this->json['setting_id'] = $this->settings['default']->id;
            $this->json['unit'] = $this->value()['unit'] ?? 'rem';
        }
    
        // Render control content
        public function render_content() {
            if (empty($this->settings)) {
                return;
            }
    
            // Get the control value
            $btn_sides_value = $this->value();
            $setting_id = esc_attr($this->settings['default']->id);
    
            ?>
            <div class="ippr-responsive-button-control" data-setting-id="<?php echo $setting_id; ?>">
                <div class="ippr-responsive-button-wrapper">
                    <!-- Tabs Section -->
                    <div class="ippr-responsive-button-tabs">
                        <div class="ippr-responsive-button">
                            <label><?php echo esc_html($this->label); ?></label>
                            <?php foreach ($this->devices as $device): ?>
                                <div class="ippr-responsive-device-icon ippr-responsive-button-icon <?php echo esc_attr($device); ?>" data-device="<?php echo esc_attr($device); ?>">
                                    <?php echo Integrate_Palace_Properties_Icons::fetch_svg_icon($device); ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
    
                        <!-- Unit Selector -->
                        <div class="ippr-button-settings-unit">
                            <?php foreach ($this->units as $unit): ?>
                                <label>
                                    <input 
                                        type="radio" 
                                        name="<?php echo $setting_id ?>"
                                        value="<?php echo $unit; ?>" 
                                        <?php checked($btn_sides_value['unit'] ?? 'rem', $unit); ?>
                                    />
                                    <?php echo strtoupper($unit); ?>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>
    
                    <!-- Sides Input Section -->
                    <div class="ippr-responsive-button-sides">
                        <ul class="ippr-spacing-wrapper">
                            <?php foreach ($this->devices as $device): ?>
                                <li class="ippr-spacing-input-item ippr-number-control" data-device="<?php echo $device; ?>">
                                    <?php foreach (['top', 'right', 'bottom', 'left'] as $side): ?>
                                        <div class="ippr-spacing-input-item-group">
                                            <input 
                                                id="<?php echo esc_attr($setting_id . '_' .$device . '_' . $side); ?>" 
                                                type="number" 
                                                class="padding-<?php echo $side; ?> ippr-spacing-input" 
                                                value="<?php echo esc_attr($btn_sides_value[$device][$side] ?? ''); ?>" 
                                                data-side="<?php echo $side; ?>" 
                                                placeholder=""
                                            >
                                            <label for="<?php echo esc_attr($setting_id . '_' .$device . '_' . $side); ?>" class="ippr-spacing-title"><?php echo esc_attr($side); ?></label>
                                        </div>
                                    <?php endforeach; ?>
                                </li>
                            <?php endforeach; ?>
    
                            <!-- Uniform Spacing Toggle -->
                            <div class="ippr-spacing-input-item-uniform">
                                <div class="toggle-uniform">
                                    <span class="ippr-spacing-disconnected"><?= Integrate_Palace_Properties_Icons::fetch_svg_icon('spacing-disconnected'); ?></span>
                                    <span class="ippr-spacing-connected"><?= Integrate_Palace_Properties_Icons::fetch_svg_icon('spacing-connected'); ?></span>
                                </div>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
            <?php
        }
    }
    
    
    
    class IPPR_Default_Button extends WP_Customize_Control {
        public $type = 'default_button';
        public $divider = '';
        public $unit = '';
        public $settings = [];
        public $units = ['px'];
        public $tab = '';
    
        public function to_json() {
            parent::to_json();
    
            $this->json['value'] = $this->value();
            $this->json['divider'] = $this->divider;
            $this->json['tab'] = $this->tab;
            $this->json['setting_id'] = $this->settings['default']->id;
            $this->json['unit'] = $this->value()['unit'] ?? 'px';
        }
    
        public function __construct($wp_customize, $id, $args = []) {
            parent::__construct($wp_customize, $id, $args);
    
            // Ensure defaults are set correctly
            $this->divider = $args['divider'] ?? '';
            $this->tab = $args['tab'] ?? '';
        }
    
        public function render_content() {
            if (empty($this->settings)) {
                return;
            }
    
            $btn_sides_value = $this->value();
            $setting_id = esc_attr($this->settings['default']->id);
            //$unit_value = $btn_sides_value['unit'] ?? 'px';
    
            ?>
            <div class="ippr-responsive-button-control" data-setting-id="<?php echo $setting_id; ?>">
                <div class="ippr-responsive-button-wrapper">
                    <div class="ippr-responsive-button-tabs">
                        <div class="ippr-responsive-button">
                            <label><?php echo esc_html($this->label); ?></label>
                        </div>
    
                        <!-- Unit selector, simplified loop -->
                        <div class="ippr-button-settings-unit">
                            <?php foreach ($this->units as $unit): ?>
                                <label>
                                    <input 
                                        type="radio" 
                                        name="<?php echo $setting_id ?>"
                                        value="<?php echo esc_attr($unit); ?>" 
                                        <?php checked($btn_sides_value['unit'] ?? 'px', $unit); ?>
                                    />
                                    <?php echo strtoupper($unit); ?>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>
    
                    <!-- Spacing input, simplified for desktop (future-proofed) -->
                    <div class="ippr-responsive-button-sides">
                        <ul class="ippr-spacing-wrapper">
                            <?php foreach (['desktop'] as $device): ?>
                                <li class="ippr-spacing-input-item ippr-number-control" data-device="<?php echo esc_attr($device); ?>">
                                    <?php foreach (['top', 'right', 'bottom', 'left'] as $side): ?>
                                        <div class="ippr-spacing-input-item-group">
                                            <input 
                                                id="<?php echo esc_attr($setting_id . '_' .$device . '_' . $side); ?>" 
                                                type="number" 
                                                class="padding-<?php echo esc_attr($side); ?> ippr-spacing-input" 
                                                value="<?php echo esc_attr($btn_sides_value[$device][$side] ?? ''); ?>" 
                                                data-side="<?php echo esc_attr($side); ?>" 
                                                placeholder=""
                                            >
                                            <label for="<?php echo esc_attr($setting_id . '_' .$device . '_' . $side); ?>" class="ippr-spacing-title"><?php echo esc_attr(ucfirst($side)); ?></label>
                                        </div>
                                    <?php endforeach; ?>
                                </li>
                            <?php endforeach; ?>
    
                            <!-- Uniform spacing toggle -->
                            <div class="ippr-spacing-input-item-uniform">
                                <div class="toggle-uniform">
                                    <span class="ippr-spacing-disconnected">
                                        <?php echo Integrate_Palace_Properties_Icons::fetch_svg_icon('spacing-disconnected'); ?>
                                    </span>
                                    <span class="ippr-spacing-connected">
                                        <?php echo Integrate_Palace_Properties_Icons::fetch_svg_icon('spacing-connected'); ?>
                                    </span>
                                </div>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
            <?php
        }
    }
    

    class IPPR_Typography extends WP_Customize_Control {
        public $type = 'typography';
        public $divider = '';
        public $control_type = '';
        public $tab = '';
        public $settings = '';
        public $devices = ['desktop', 'tablet', 'mobile'];
    
        // Constructor
        public function __construct($wp_customize, $id, $args = []) {
            parent::__construct($wp_customize, $id, $args);
            $this->divider = $args['divider'] ?? '';
            $this->control_type = $args['control_type'] ?? '';
            $this->tab = $args['tab'] ?? '';
            $customizer_instance = IntegratePalace_Properties_Customizer::get_instance();
            $this->font_families = $customizer_instance->ippr_font_families();
            $this->font_weight = $customizer_instance->ippr_font_weight();
            $this->font_size_unit = $customizer_instance->ippr_font_size_unit();
        }
    
        // JSON serialization method for control
        public function to_json() {
            parent::to_json();
            $this->json['divider'] = $this->divider;
            $this->json['control_type'] = $this->control_type;
            $this->json['tab'] = $this->tab;
        }

        // Render control content
        public function render_content() {
            if (empty($this->settings)) {
                return;
            }

            $control_type = $this->control_type;
            $settings = $this->settings;
            $options = get_option(IPPR_SETTINGS, []);

            $cur_font_family = $options["{$control_type}_font_family"] ?? 'Euclid Circular B';
            $cur_font_weight = $options["{$control_type}_font_weight"] ?? '400';
            $cur_font_size_unit = $options["{$control_type}_font_size_unit"] ?? 'px';

            $cur_font_sizes = [
                'desktop' => $options["{$control_type}_font_size"]['desktop'] ?? '16',
                'tablet'  => $options["{$control_type}_font_size"]['tablet'] ?? '16',
                'mobile'  => $options["{$control_type}_font_size"]['mobile'] ?? '16',
            ];

            $setting_name = "{$control_type}_font_size";
            $setting_id = IPPR_SETTINGS . '[' . $setting_name . ']';

            ?>
            <?php if ( ! empty( $this->label ) ) : ?>
                <div class="ippr-control-wrapper">
                    <label>
                        <span class="customize-text"><?php echo esc_html( $this->label ); ?></span>
                    </label>
                    <span class="dashicons ippr-fs-toggle-icon"></span>
                </div>
            <?php endif; ?>

            <!-- Modal Structure -->
            <div class="ippr-field-settings-wrap">
                <div class="ippr-field-settings-modal">

                    <?php if (isset($settings['font_family'])): ?>
                        <div class="ippr-btn-font-family ippr-bottom-border-dotted">
                            <!-- Font Family -->
                            <label><?php _e('Font Family', 'integrate-palace-properties'); ?></label>
                            <select class="ippr-btn-font-family-control" <?php $this->link( 'font_family' ); ?>>
                                <?php foreach ( $this->font_families as $font_family ) : ?>
                                    <option value="<?php echo esc_attr( $font_family ); ?>" <?php selected( $cur_font_family, $font_family ); ?>><?php echo esc_html( $font_family ); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($settings['font_weight'])): ?>
                        <div class="ippr-btn-font-weight ippr-bottom-border-dotted">
                            <!-- Font Weight -->
                            <label><?php _e('Font Weight', 'integrate-palace-properties'); ?></label>
                            <select class="ippr-btn-font-weight-control" <?php $this->link( 'font_weight' ); ?>>
                                <?php foreach ( $this->font_weight as $font_weight ) : ?>
                                    <option value="<?php echo esc_attr( $font_weight ); ?>" <?php selected( $cur_font_weight, $font_weight ); ?>><?php echo esc_html( $font_weight ); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    <?php endif; ?>
 
                    <?php if (isset($settings['font_size'])): ?>
                        <div class="ippr-responsive-button-tabs">
                            <div class="ippr-responsive-device-icons">
                                <label><?php echo __( 'Size', 'integrate-palace-properties' ); ?></label>
                                <?php foreach ($this->devices as $device): ?>
                                    <div class="ippr-responsive-device-icon ippr-responsive-font-icon<?php echo esc_attr($device); ?>">
                                        <?php echo Integrate_Palace_Properties_Icons::fetch_svg_icon($device); ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>

                            <!-- Unit Selector -->
                            <div class="ippr-responsive-font-unit ippr-button-settings-unit">
                                <?php foreach ( $this->font_size_unit as $font_unit ) : ?>
                                    <label>
                                        <input type="radio" name="<?php echo esc_attr( "{$control_type}_font_size_unit" ); ?>" value="<?php echo esc_attr( $font_unit ); ?>" <?php checked( $cur_font_size_unit, $font_unit ); ?>  <?php $this->link( 'font_unit' ); ?>/>
                                        <?php echo strtoupper(esc_html($font_unit)); ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>

                        </div>

                        <div class="ippr-spacing-wrapper ippr-responsive-font-size" data-setting-id="<?php echo $setting_id ?>">
                            <!-- Font Size -->
                            <div class="ippr-responsive-font-size-slider">
                                <input type="range" id="ippr-responsive-font-size-slider-input" min="0" max="200" value="16">
                            </div>

                            <div class="ippr-responsive-font-size-input-wrapper">
                                <?php foreach ($this->devices as $device): ?>
                                    <div class="ippr-spacing-input-item ippr-responsive-font-size-input" data-device="<?php echo esc_attr($device); ?>">
                                        <input type="number" class="ippr-spacing-input" value="<?php echo esc_attr($cur_font_sizes[$device]); ?>" />
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>

                    </br>
                <?php endif; ?>

                </div>
            </div>
            
            <?php
        }
    }



    
}



