<?php
if ( ! class_exists( 'IntegratePalace_Properties_Typography' ) ) {

    class IntegratePalace_Properties_Typography extends IntegratePalace_Properties_Customizer_Config_Base {

        public function register_configuration( $configurations, $wp_customize ) {

            $_configs[] = [
                'name' => IPPR_SETTINGS . '[body_font_size]',
                'default' => [
                    'desktop' => 16,
                    'tablet'  => 16,
                    'mobile'  => 16,
                ],
                'type' => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_font_size'],
            ];
    
            $_configs[] = [
                'name' => IPPR_SETTINGS . '[body_font_family]',
                'default' => 'Euclid Circular B',
                'type' => 'setting',
                'sanitize_callback' => 'sanitize_text_field',
            ];
    
            $_configs[] = [
                'name' => IPPR_SETTINGS . '[body_font_weight]',
                'default' => '400',
                'type' => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_font_weight'],
            ];
    
            $_configs[] = [
                'name' => IPPR_SETTINGS . '[body_font_size_unit]',
                'default' => 'px',
                'type' => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_units'],
            ];
    
            $_configs[] = [
                'name' => IPPR_SETTINGS . '[body_typography_control]',
                'type' => 'control',
                'control' => 'IPPR_Typography',
                'label' => __('Body Font', 'integrate-palace-properties'),
                'section' => IPPR_SETTINGS . '[template_typography_section]',
                'settings' => [
                    'font_size' => IPPR_SETTINGS . '[body_font_size]',
                    'font_family' => IPPR_SETTINGS . '[body_font_family]',
                    'font_weight' => IPPR_SETTINGS . '[body_font_weight]',
                    'font_unit' => IPPR_SETTINGS . '[body_font_size_unit]',
                ],
                'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted '],
                'priority' => 10,
                'control_type' => 'body',
            ];

            $_configs[] = [
                'name' => IPPR_SETTINGS . '[heading_font_family]',
                'default' => 'Euclid Circular B',
                'type' => 'setting',
                'sanitize_callback' => 'sanitize_text_field',
            ];
    
            $_configs[] = [
                'name' => IPPR_SETTINGS . '[heading_font_weight]',
                'default' => '700',
                'type' => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_font_weight'],
            ];
    
            $_configs[] = [
                'name' => IPPR_SETTINGS . '[heading_font_size_unit]',
                'default' => 'px',
                'type' => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_units'],
            ];
    
            $_configs[] = [
                'name' => IPPR_SETTINGS . '[heading_typography_control]',
                'type' => 'control',
                'control' => 'IPPR_Typography',
                'label' => __('Heading Font', 'integrate-palace-properties'),
                'section' => IPPR_SETTINGS . '[template_typography_section]',
                'settings' => [
                    'font_family' => IPPR_SETTINGS . '[heading_font_family]',
                    'font_weight' => IPPR_SETTINGS . '[heading_font_weight]',
                    'font_unit' => IPPR_SETTINGS . '[heading_font_size_unit]',
                ],
                'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted '],
                'priority' => 10,
                'control_type' => 'heading',
            ];

            return array_merge( $configurations, $_configs );
        }

    }
}

new IntegratePalace_Properties_Typography();
