<?php

    // Block direct access to the file.
    if ( ! defined( 'ABSPATH' ) ) {
        exit;
    }

    // Bail if Customizer config base class does not exist.
    if ( ! class_exists( 'IntegratePalace_Properties_Customizer_Config_Base' ) || class_exists( 'IntegratePalace_Properties_Template_Single' ) ) {
        return;
    }

    class IntegratePalace_Properties_Template_Single extends IntegratePalace_Properties_Customizer_Config_Base {

        public function register_configuration( $configurations, $wp_customize ) {
      
            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[single_layout]',
                'default'  => 'w-full',
                'type'     => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_layout_type'],
            ];

            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[single_layout-control]',
                'type'     => 'control',
                'control'  => 'IPPR_Layout_Type',
                'label'    => __( ' Container Layout ', 'integrate-palace-properties' ),
                'section'  => IPPR_SETTINGS . '[single_page_section]',
                'settings' => IPPR_SETTINGS . '[single_layout]',
                'priority' => 10,
                'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted'],
                'choices' => [
                    'w-full' => [
                        'label' => __( 'Default', 'integrate-palace-properties' ),
                    ],
                    'container' => [
                        'label' => __( 'Boxed', 'integrate-palace-properties' ),
                    ],
                ],
            ];
            

            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[single_sidebar_layout]',
                'default'  => 'right-sidebar',
                'type'     => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_layout_type'],
            ];

            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[single_sidebar_layout_control]',
                'type'     => 'control',
                'control'  => 'IPPR_Layout_Type',
                'label'    => __( ' Sidebar Layout ', 'integrate-palace-properties' ),
                'section'  => IPPR_SETTINGS . '[single_page_section]',
                'settings' => IPPR_SETTINGS . '[single_sidebar_layout]',
                'priority' => 10,
                'choices' => [
                    'right-sidebar' => [
                        'label' => __( 'Default', 'integrate-palace-properties' ),
                    ],
                    'left-sidebar' => [
                        'label' => __( 'Left Sidebar', 'integrate-palace-properties' ),
                    ],
                    'no-sidebar' => [
                        'label' => __( 'No Sidebar', 'integrate-palace-properties' ),
                    ],
                ],
            ];
            
            return array_merge( $configurations, $_configs );

        }
    }

new IntegratePalace_Properties_Template_Single();