<?php

// Block direct access to the file.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Bail if Customizer config base class does not exist.
if ( ! class_exists( 'IntegratePalace_Properties_Customizer_Config_Base' ) || class_exists( 'IntegratePalace_Properties_Template_Colors' ) ) {
    return;
}

class IntegratePalace_Properties_Template_Colors extends IntegratePalace_Properties_Customizer_Config_Base {

    public function register_configuration( $configurations, $wp_customize ) {

        $template_type = get_option( 'ipp_select_template', 'palace-property' );
        $template_name = ucwords( str_replace( '-', ' ', sanitize_text_field( $template_type ) ) );
        $setting_type  = 'colors';

        $defaults = get_option( 'IPPR_CUSTOMIZER_SETTING_DEFAULTS', [] );
        $template_settings = $defaults[ $template_type ][ $setting_type ] ?? [];

        $template_settings = is_array( $template_settings ) ? $template_settings : [];

        $_configs = [];
        $settings_map = [];

        foreach ( $template_settings as $template_key => $template_values ) {
            $setting_name = IPPR_SETTINGS . '[' . $template_type . '_' . $template_key . ']';
            $value = $template_values ?? '';

            $_configs[] = [
                'name'              => $setting_name,
                'default'           => $value,
                'type'              => 'setting',
                'sanitize_callback' => 'sanitize_hex_color',
            ];

            $settings_map[ $template_key ] = $setting_name;
        }

        $_configs[] = [
            'name'       => "template_colors_{$template_type}_control",
            'type'       => 'control',
            'control'    => 'IPPR_Colors',
            'label'      => sprintf( __( '%s', 'integrate-palace-properties' ), $template_name ),
            'section'    => IPPR_SETTINGS . '[template_colors_section]',
            'settings'   => $settings_map,
            'color_label' => [
                'primary_color'   => __( 'Primary Color', 'integrate-palace-properties' ),
                'secondary_color' => __( 'Secondary Color', 'integrate-palace-properties' ),
            ],
            'priority'   => 10,
        ];

        return array_merge( $configurations, $_configs );
    }
}

new IntegratePalace_Properties_Template_Colors();
