<?php

// Block direct access to the file.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Bail if Customizer config base class does not exist.
if ( ! class_exists( 'IntegratePalace_Properties_Customizer_Config_Base' ) || class_exists( 'IntegratePalace_Properties_Template_Buttons' ) ) {
    return;
}

class IntegratePalace_Properties_Template_Buttons extends IntegratePalace_Properties_Customizer_Config_Base {

    public function register_configuration( $configurations, $wp_customize ) {

        $template_type = get_option( 'ipp_select_template', 'palace-property' );
        $buttons_section = IPPR_SETTINGS . '[template_buttons_section]';
        
        $setting_type_p = 'buttons_primary';
        $setting_type_s = 'buttons_secondary';

        $defaults = get_option( 'IPPR_CUSTOMIZER_SETTING_DEFAULTS', [] );
        $template_settings_p = $defaults[ $template_type ][ $setting_type_p ] ?? [];
        $template_settings_s = $defaults[ $template_type ][ $setting_type_s ] ?? [];

        $template_settings = array_merge( 
            $template_settings_p, 
            $template_settings_s 
        );

        $_configs = [];
        $settings_map = [];

        foreach ( $template_settings as $template_key => $template_values ) {
            $setting_name = IPPR_SETTINGS . '[' . $template_type . '_' . $template_key . ']';
            $value = $template_values ?? '';

            $_configs[] = [
                'name'              => $setting_name,
                'default'           => $value,
                'type'              => 'setting',
                'sanitize_callback' => 'sanitize_hex_color',
            ];

            $settings_map[ $template_key ] = $setting_name;
        }

        $_configs[] = [
            'name'     => IPPR_SETTINGS . '[section_tab_control]',
            'type'     => 'control',
            'control'  => 'IPPR_Section_Tabs',
            'label'    => __( 'Button Tab', 'integrate-palace-properties' ),
            'section'  =>$buttons_section,
            'settings' => IPPR_SETTINGS . '[section_tab_setting]',
            'priority' => 5,
        ];

        $_configs[] = [
            'name'     => "template_button_p_{$template_type}_control",
            'type'     => 'control',
            'control'  => 'IPPR_Colors',
            'section'  =>$buttons_section,
            'settings' => $settings_map,
            'color_label' => [
                'button_primary_color'      => 'Text Color',
                'button_primary_bg_color'   => 'Background Color',
                'button_primary_border_color'=> 'Border Color',
            ],
            'divider'  => ['ippr_class' => 'ippr-spacing-top ippr-bottom-border-dotted'],
            'tab' => 'primary',
            'priority' => 10,
        ];

        $_configs[] = [
            'name'     => "template_button_s_{$template_type}_control",
            'type'     => 'control',
            'control'  => 'IPPR_Colors',
            'section'  =>$buttons_section,
            'settings' => $settings_map,
            'color_label' => [
                'button_secondary_color'      => 'Text Color',
                'button_secondary_bg_color'   => 'Background Color',
                'button_secondary_border_color'=> 'Border Color',
            ],
            'divider'  => ['ippr_class' => 'ippr-spacing-top ippr-bottom-border-dotted'],
            'tab' => 'secondary',
            'priority' => 10,
        ];
        
        // Primary Button Configurations
        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_font_size]',
            'default' => [
                'desktop' => 16,
                'tablet'  => 16,
                'mobile'  => 16,
            ],
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_font_size'],
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_font_family]',
            'default' => 'Euclid Circular B',
            'type' => 'setting',
            'sanitize_callback' => 'sanitize_text_field',
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_font_weight]',
            'default' => '400',
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_font_weight'],
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_font_size_unit]',
            'default' => 'px',
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_units'],
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_typography_control]',
            'type' => 'control',
            'control' => 'IPPR_Typography',
            'label' => __('Font', 'integrate-palace-properties'),
            'section' => $buttons_section,
            'settings' => [
                'font_size' => IPPR_SETTINGS . '[primary_btn_font_size]',
                'font_family' => IPPR_SETTINGS . '[primary_btn_font_family]',
                'font_weight' => IPPR_SETTINGS . '[primary_btn_font_weight]',
                'font_unit' => IPPR_SETTINGS . '[primary_btn_font_size_unit]',
            ],
            'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted '],
            'control_type' => 'primary_btn',
            'tab' => 'primary',
            'priority' => 10,
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_paddings]',
            'default' => [
                'desktop' => ['top' => 0.625, 'right' => 1.5, 'bottom' => 0.625, 'left' => 1.5],
                'tablet'  => ['top' => 0.625, 'right' => 1.5, 'bottom' => 0.625, 'left' => 1.5],
                'mobile'  => ['top' => 0.625, 'right' => 1.5, 'bottom' => 0.625, 'left' => 1.5],
                'unit' => 'rem',
            ],
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_button'],
        ];
        
        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_paddings_control]',
            'type' => 'control',
            'control' => 'IPPR_Responsive_Button',
            'label' => __('Padding', 'integrate-palace-properties'),
            'section' => $buttons_section,
            'settings' => IPPR_SETTINGS . '[primary_btn_paddings]',
            'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted'],
            'tab' => 'primary',
            'priority' => 10,
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_border_radius]',
            'default' => [
                'desktop' => ['top' => 0.25, 'right' => 0.25, 'bottom' => 0.25, 'left' => 0.25],
                'tablet' => ['top' => 0.25, 'right' => 0.25, 'bottom' => 0.25, 'left' => 0.25],
                'mobile' => ['top' => 0.25, 'right' => 0.25, 'bottom' => 0.25, 'left' => 0.25],
                'unit' => 'rem',
            ],
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_button'],
        ];
        
        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_border_radius_control]',
            'type' => 'control',
            'control' => 'IPPR_Responsive_Button',
            'label' => __('Border Radius', 'integrate-palace-properties'),
            'section' => $buttons_section,
            'settings' => IPPR_SETTINGS . '[primary_btn_border_radius]',
            'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted'],
            'tab' => 'primary',
            'priority' => 10,
        ];

        // Secondary Button Configurations
        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_font_size]',
            'default' => [
                'desktop' => 16,
                'tablet'  => 16,
                'mobile'  => 16,
            ],
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_font_size'],
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_font_family]',
            'default' => 'Euclid Circular B',
            'type' => 'setting',
            'sanitize_callback' => 'sanitize_text_field',
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_font_weight]',
            'default' => '400',
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_font_weight'],
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_font_size_unit]',
            'default' => 'em',
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_units'],
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_typography_control]',
            'type' => 'control',
            'control' => 'IPPR_Typography',
            'label' => __('Font', 'integrate-palace-properties'),
            'section' => $buttons_section,
            'settings' => [
                'font_size' => IPPR_SETTINGS . '[secondary_btn_font_size]',
                'font_family' => IPPR_SETTINGS . '[secondary_btn_font_family]',
                'font_weight' => IPPR_SETTINGS . '[secondary_btn_font_weight]',
                'font_unit' => IPPR_SETTINGS . '[secondary_btn_font_size_unit]',
            ],
            'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted '],
            'control_type' => 'secondary_btn',
            'tab' => 'secondary',
            'priority' => 10,
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_paddings]',
            'default' => [
                'desktop' => ['top' => 0.625, 'right' => 1.5, 'bottom' => 0.625, 'left' => 1.5],
                'tablet'  => ['top' => 0.625, 'right' => 1.5, 'bottom' => 0.625, 'left' => 1.5],
                'mobile'  => ['top' => 0.625, 'right' => 1.5, 'bottom' => 0.625, 'left' => 1.5],
                'unit' => 'rem',
            ],
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_button'],
        ];
        
        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_paddings_control]',
            'type' => 'control',
            'control' => 'IPPR_Responsive_Button',
            'label' => __('Padding', 'integrate-palace-properties'),
            'section' => $buttons_section,
            'settings' => IPPR_SETTINGS . '[secondary_btn_paddings]',
            'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted'],
            'tab' => 'secondary',
            'priority' => 10,
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_border_radius]',
            'default' => [
                'desktop' => ['top' => 0.25, 'right' => 0.25, 'bottom' => 0.25, 'left' => 0.25],
                'tablet' => ['top' => 0.25, 'right' => 0.25, 'bottom' => 0.25, 'left' => 0.25],
                'mobile' => ['top' => 0.25, 'right' => 0.25, 'bottom' => 0.25, 'left' => 0.25],
                'unit' => 'rem',
            ],
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_button'],
        ];
        
        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_border_radius_control]',
            'type' => 'control',
            'control' => 'IPPR_Responsive_Button',
            'label' => __('Border Radius', 'integrate-palace-properties'),
            'section' => $buttons_section,
            'settings' => IPPR_SETTINGS . '[secondary_btn_border_radius]',
            'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted'],
            'tab' => 'secondary',
            'priority' => 10,
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_border_width]',
            'default' => [
                'desktop' => ['top' => 2, 'right' => 2, 'bottom' => 2, 'left' => 2],
                'unit' => 'px',
            ],
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_button'],
        ];
        
        $_configs[] = [
            'name' => IPPR_SETTINGS . '[primary_btn_border_width_control]',
            'type' => 'control',
            'control' => 'IPPR_Default_Button',
            'label' => __('Border', 'integrate-palace-properties'),
            'section' => $buttons_section,
            'settings' => IPPR_SETTINGS . '[primary_btn_border_width]',
            'tab' => 'primary',
            'priority' => 10,
        ];

        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_border_width]',
            'default' => [
                'desktop' => ['top' => 2, 'right' => 2, 'bottom' => 2, 'left' => 2],
                'unit' => 'px',
            ],
            'type' => 'setting',
            'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_responsive_button'],
        ];
        
        $_configs[] = [
            'name' => IPPR_SETTINGS . '[secondary_btn_border_width_control]',
            'type' => 'control',
            'control' => 'IPPR_Default_Button',
            'label' => __('Border', 'integrate-palace-properties'),
            'section' => $buttons_section,
            'settings' => IPPR_SETTINGS . '[secondary_btn_border_width]',
            'tab' => 'secondary',
            'priority' => 10,
        ];
        
        return array_merge( $configurations, $_configs );
    }
}

new IntegratePalace_Properties_Template_Buttons();
