<?php

    // Block direct access to the file.
    if ( ! defined( 'ABSPATH' ) ) {
        exit;
    }

    // Bail if Customizer config base class does not exist.
    if ( ! class_exists( 'IntegratePalace_Properties_Customizer_Config_Base' ) || class_exists( 'IntegratePalace_Properties_Template_Archive' ) ) {
        return;
    }

    class IntegratePalace_Properties_Template_Archive extends IntegratePalace_Properties_Customizer_Config_Base {

        public function register_configuration( $configurations, $wp_customize ) {
      
            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[archive_layout]',
                'default'  => 'w-full',
                'type'     => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_layout_type'],
            ];

            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[archive_layout_control]',
                'type'     => 'control',
                'control'  => 'IPPR_Layout_Type',
                'label'    => __( ' Container Layout ', 'integrate-palace-properties' ),
                'section'  => IPPR_SETTINGS . '[archive_page_section]',
                'settings' => IPPR_SETTINGS . '[archive_layout]',
                'priority' => 10,
                'divider'  => ['ippr_class' => 'ippr-bottom-border-dotted'],
                'choices' => [
                    'w-full' => [
                        'label' => __( 'Default', 'integrate-palace-properties' ),
                    ],
                    'container' => [
                        'label' => __( 'Boxed', 'integrate-palace-properties' ),
                    ],
                ],
            ];
            
            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[archive_property_layout_heading]',
                'type'     => 'control',
                'control'  => 'IntegratePalace_Properties_Section_Heading',
                'label'    => __( ' Archive Layout ', 'integrate-palace-properties' ),
                'section'  => IPPR_SETTINGS . '[archive_page_section]',
                'settings' => IPPR_SETTINGS . '[section_heading_setting]',
                'priority' => 10,
                
            ];

            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[archive_property_layout]',
                'default'  => 'grid-layout',
                'type'     => 'setting',
                'sanitize_callback' => ['IntegratePalace_Properties_Customizer_Sanitizes', 'sanitize_layout_type'],
            ];

            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[archive_property_layout_control]',
                'type'     => 'control',
                'control'  => 'IPPR_Layout_Type',
                'label'    => __( ' Layout ', 'integrate-palace-properties' ),
                'section'  => IPPR_SETTINGS . '[archive_page_section]',
                'settings' => IPPR_SETTINGS . '[archive_property_layout]',
                'priority' => 10,
                'choices' => [
                    'classic-layout' => [
                        'label' => __( 'Classic Layout', 'integrate-palace-properties' ),
                    ],
                    'grid-layout' => [
                        'label' => __( 'Grid Layout', 'integrate-palace-properties' ),
                    ],
                    'list-layout' => [
                        'label' => __( 'List Layout', 'integrate-palace-properties' ),
                    ],
                    'cover-layout' => [
                        'label' => __( 'Cover Layout', 'integrate-palace-properties' ),
                    ],
                ],
            ];
            
            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[archive_property_perpage]',
                'default'  => '9',
                'type'     => 'setting',
                'sanitize_callback'      => 'absint',
            ];

            $_configs[] = [
                'name'     => IPPR_SETTINGS . '[archive_property_perpage_control]',
                'type'     => 'control',
                'control'  => 'IPPR_Property_Per_Page',
                'label'    => __( ' Property Per Page ', 'integrate-palace-properties' ),
                'section'  => IPPR_SETTINGS . '[archive_page_section]',
                'settings' => IPPR_SETTINGS . '[archive_property_perpage]',
                'priority' => 10,
                'divider'  => ['ippr_class' => 'ippr-top-border-solid ippr-bottom-border-solid'],
            ];

            return array_merge( $configurations, $_configs );

        }
    }

new IntegratePalace_Properties_Template_Archive();