<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if ( class_exists( 'WP_Customize_Control' ) ) {

    // Container
    class IntegratePalace_Properties_Layout_Type extends WP_Customize_Control {
        public $type = 'radio';
        public $divider = '';
        public $tooltips = array();

        public function to_json() {
            parent::to_json();
            $this->json['divider'] = $this->divider;
        }

        public function __construct( $wp_customize, $id, $args = array() ) {
            parent::__construct( $wp_customize, $id, $args );

            $this->divider  = isset($args['divider']) ? sanitize_text_field($args['divider']) : '';
            $this->tooltips = isset($args['tooltips']) ? array_map('sanitize_text_field', $args['tooltips']) : array();
        }

        public function render_content() {
            if ( empty( $this->choices ) ) {
                return;
            }
            if ( ! empty( $this->label ) ) {
                echo '<div class="ipp-title-wrapper"><span class="customize-control-title">' . esc_html( $this->label ) . '</span></div>';
            }
            ?>

            <div class="customize-control-ipp-radio-image">
                <?php foreach ( $this->choices as $value => $label ) :
                    $tooltip = isset( $this->tooltips[ $value ] ) ? esc_attr( $this->tooltips[ $value ] ) : ''; ?>
<input type="radio" name="<?php echo esc_attr( $this->id ); ?>" value="<?php echo esc_attr( $value ); ?>" id="<?php echo esc_attr( $this->id . '_' . $value ); ?>" <?php echo esc_attr( $this->link() ); ?> <?php checked( $this->value(), $value ); ?> />
<label for="<?php echo esc_attr( $this->id . '_' . $value ); ?>" class="ipp-radio-img-svg">
                    <?php echo wp_kses_post( IntegratePalace_Properties_Icons::fetch_svg_icon( esc_attr( $value ) ) ); ?>
                    <?php if ($tooltip): ?>
                        <span class="ipp-tooltip" data-tooltip="<?php echo esc_attr( $tooltip ); ?>"></span>
                    <?php endif; ?>
                    </label>
                <?php endforeach; ?>
            </div>
            <?php
        }
    }

    // Archive Properties Per Page
    class IntegratePalace_Properties_Property_Per_Page extends WP_Customize_Control {
        public $type = 'number';
        public $divider = '';

        public function to_json() {
            parent::to_json();
            $this->json['divider'] = $this->divider;
        }

        public function __construct( $wp_customize, $id, $args = array() ) {
            parent::__construct( $wp_customize, $id, $args );

            $this->divider = isset($args['divider']) ? sanitize_text_field($args['divider']) : '';
        }
    
        public function render_content() {
            if ( empty( $this->label ) ) {
                return;
            }
            ?>
            <div class="ipp-control-wrapper">
                <div class="ipp-title-wrapper">
                    <span class="ipp-control-label"><?php echo esc_html( $this->label ); ?></span>
                </div>
                <div class="ipp-control-wrapper">
                    <div class="ipp-number-single">
                        <div class="ipp-minus"><span class="dashicon dashicons dashicons-minus"></span></div>
                        <div class="ipp-base-control ipp-input-control ipp-number-control">
                            <input type="number" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?> min="1" step="1" />
                        </div>
                        <div class="ipp-plus"><span class="dashicon dashicons dashicons-plus"></span></div>
                    </div>
                </div>
            </div>
            <?php
        }
    }

    // Body Fonts
    class IntegratePalace_Font_Family extends WP_Customize_Control {
        public $type = 'integrate_palace_font_family';
        public $divider = '';

        public function to_json() {
            parent::to_json();
            $this->json['divider'] = $this->divider;
        }

        public function __construct( $wp_customize, $id, $args = array() ) {
            parent::__construct( $wp_customize, $id, $args );
            
            $this->divider = isset($args['divider']) ? sanitize_text_field($args['divider']) : '';
        }

        protected function include_font_family() {
            return array(
                'Initial', 
                'Euclid Circular B',
                'Roboto', 
                'Helvetica', 
                'Georgia', 
                'Times New Roman' 
            );
        }

        public function render_content() {
            if ( empty( $this->settings ) ) {
                return;
            }
            
            if ( ! empty( $this->label ) ) {
                echo '<span class="customize-control-title">' . esc_html( $this->label ) . '</span>';
            }

            $heading_font = esc_attr(get_option('integrate_palace_settings')['heading_font_family'] ?? 'Euclid Circular B');
            $body_font = esc_attr(get_option('integrate_palace_settings')['body_font_family'] ?? 'Euclid Circular B');

            ?>
            <div class="ipp-control-wrapper" style="background: #fff;padding:1rem;border-radius:5px;">
                <label>
                    <span class="customize-text"><?php echo esc_html__( 'Font Family', 'integrate-palace-properties' ); ?></span>
                </label>
                <span class="dashicons ipp-fs-toggle-icon"></span>
            </div>

            <div class="ipp-field-settings-wrap">
                <div class="ipp-field-settings-modal" style="display: none;">
                    <div class="body-font-family-control">
                        <label for="heading_font_family"><?php echo esc_html__( 'Heading Font Family', 'integrate-palace-properties' ); ?></label>
                        <select id="heading_font_family" <?php $this->link( 'heading_font_family' ); ?>>
                            <?php foreach ( $this->include_font_family() as $heading_font_family ) : ?>
                                <option value="<?php echo esc_attr( $heading_font_family ); ?>" <?php selected( $heading_font, $heading_font_family ); ?>><?php echo esc_html( $heading_font_family ); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    </br>
                    <div class="body-font-family-control">
                        <label for="body_font_family"><?php echo esc_html__( 'Body Font Family', 'integrate-palace-properties' ); ?></label>
                        <select id="body_font_family" <?php $this->link( 'body_font_family' ); ?>>
                            <?php foreach ( $this->include_font_family() as $body_font_family ) : ?>
                                <option value="<?php echo esc_attr( $body_font_family ); ?>" <?php selected( $body_font, $body_font_family ); ?>><?php echo esc_html( $body_font_family ); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
            <?php
        }
    }

    // Button Settings Control
    class IntegratePalace_Button_Settings_Control extends WP_Customize_Control {
        public $type = 'integrate_palace_buttons';
        public $divider = '';
        public $tab = '';
        public $units = array();
        public $setting_id = '';

        public function to_json() {
            parent::to_json();
            $this->json['divider'] = $this->divider;
            $this->json['tab'] = $this->tab;
        }

        public function __construct( $wp_customize, $id, $args = array() ) {
            parent::__construct( $wp_customize, $id, $args );

            $this->divider    = isset($args['divider']) ? sanitize_text_field($args['divider']) : '';
            $this->tab        = isset($args['tab']) ? sanitize_text_field($args['tab']) : ''; 
            $this->units      = isset($args['units']) ? array_map('sanitize_text_field', $args['units']) : array();
            $this->setting_id = isset($args['setting_id']) ? sanitize_text_field($args['setting_id']) : '';
        }

        public function render_content() {
            if ( empty( $this->settings ) ) {
                return;
            }

            $setting_id = esc_attr($this->setting_id);

            if ( ! empty( $this->label ) ) : ?>

            <div class="ipp-buton-settings-wrapper">
                <div class="ipp-buton-settings-label">
                    <span class="customize-text"><?php echo esc_html( $this->label ); ?></span>
                    <div class="ipp-buton-settings-unit">
                        <?php foreach ($this->units as $unit => $unit_label ) : ?>
                            <label>
                            <input type="radio" name="<?php echo esc_attr( $this->id . '_unit' ); ?>" value="<?php echo esc_attr( $unit ); ?>" data-customize-setting-link="<?php echo esc_attr( $setting_id ); ?>" <?php checked( $this->value(), $unit ); ?> />
                            <?php echo esc_html($unit_label); ?>
                            </label>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="ipp-buton-settings-sides">
                    <ul class="ipp-spacing-wrapper">
                        <?php foreach ($this->settings as $setting => $value) : ?>
                            <li class="ipp-spacing-input-item ipp-number-control">
                                <input type="number" id="<?php echo esc_attr($this->id . '_' . $setting); ?>" class="ipp-btn-side-width-input ipp-spacing-input" <?php $this->link($setting); ?> value="<?php echo esc_attr($this->value($setting)); ?>"/>
                                <label for="<?php echo esc_attr($this->id . '_' . $setting); ?>" class="ipp-spacing-title"><?php echo esc_html(ucfirst($setting)); ?></label>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

            </div>
            <?php
            endif;
        }
    }
    
    // Color Picker Control
    class IntegratePalace_Color_Picker extends WP_Customize_Control {
        public $type = 'ipp-color-picker';
        public $divider = '';
        public $tab = '';
        public $color_label = array();

        public function to_json() {
            parent::to_json();
            $this->json['divider'] = $this->divider;
            $this->json['tab'] = $this->tab;
        }

        public function __construct( $wp_customize, $id, $args = array() ) {
            parent::__construct( $wp_customize, $id, $args );

            $this->divider     = isset($args['divider']) ? sanitize_text_field($args['divider']) : '';
            $this->tab         = isset($args['tab']) ? sanitize_text_field($args['tab']) : '';
            $this->color_label = isset($args['color_label']) ? array_map('sanitize_text_field', $args['color_label']) : array();
        }

        public function render_content() {
            if ( empty( $this->settings ) ) {
                return;
            }

            if ( ! empty( $this->label ) ) {
                echo '<span class="customize-control-title title-bottom-border_dotted">' . esc_html( $this->label ) . '</span>';
            }
            ?>
            <div class="ipp-color-picker-wrapper">
                <div class="color-picker-grid">
                    <?php foreach ($this->color_label as $color_key => $label) : ?>
                        <div class="color-picker-row">
                            <div class="color-label"><?php echo esc_html($label); ?></div>
                            <div class="color-picker-set">
                                <label>
                                    <input type="text" data-alpha-enabled="true" class="ipp-color-picker" <?php $this->link($color_key); ?> value="<?php echo esc_attr($this->value($color_key)); ?>" data-tooltip="Normal" />
                                </label>
                                <label>
                                    <input type="text" data-alpha-enabled="true" class="ipp-color-picker" <?php $this->link("{$color_key}_h"); ?> value="<?php echo esc_attr($this->value("{$color_key}_h")); ?>" data-tooltip="Hover" />
                                </label>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php
        }
    }

    // Section Heading Control
    class IntegratePalace_Section_Heading extends WP_Customize_Control {
        public $type = 'integrate_palace_heading';

        public function render_content() {
            if ( empty( $this->settings ) ) {
                return;
            } ?>
            <div class="ipp-heading-wrapper">
                <label class="customizer-text">
                    <span class="customize-control-title"><?php echo esc_html( $this->label ) ?></span>
                </label>
            </div>
            <?php
        }
    }

    // Section Tabs Control
    class IntegratePalace_Section_Tabs extends WP_Customize_Control {
        public $type = 'integrate_palace_section_tabs';

        public function render_content() {
            if ( empty( $this->settings ) ) {
                return;
            } ?>
            <div class="nav-tab-wrapper ipp-section-tabs">
                <a href="#" class="nav-tab ipp-heading-tabs-button integrate_palace_primary_btn nav-tab-active"><span>Primary</span></a>
                <a href="#" class="nav-tab ipp-heading-tabs-button integrate_palace_secondary_btn"><span>Secondary</span></a>
            </div>
        <?php
        }
    }
}
