<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! class_exists( 'integrate_palace_Customizer_Sanitizes' ) ) {

    class IntegratePalace_Properties_Customizer_Sanitizes {

		// Sanitize Container
		public static function sanitize_layout_type( $layout ) {

			$valid = array(
				'w-full',
				'container',
			);
		
			return in_array( $layout, $valid ) ? $layout : 'container';
		}

		// Sanitize Property Layout
		public static function sanitize_property_layout( $layout ) {

			$valid = array(
				'classic-layout',
				'grid-layout',
				'list-layout',
				'cover-layout',
			);
		
			return in_array( $layout, $valid ) ? $layout : 'grid-layout';
		}

		// Sanitize Sidebar Layout
		public static function sanitize_sidebar_layout( $layout ) {

			$valid = array(
				'right-sidebar',
				'left-sidebar',
				'no-sidebar',
			);
		
			return in_array( $layout, $valid ) ? $layout : 'right-sidebar';
		}

		// Sanitize Units
		public static function sanitize_units( $border_units ) {

			$valid = array(
				'px',
				'em',
				'rem',
				'%',
			);
		
			return in_array( $border_units, $valid ) ? $border_units : 'px';
		}


        // Sanitize Font Weight
		public static function sanitize_font_weight( $input ) {

			$valid = array(
				'inherit',
				'normal',
				'bold',
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			);
			

			if ( in_array( $input, $valid ) ) {
				return $input;
			} else {
				return 'normal';
			}
		}



    }
}