<?php

if (!class_exists('IntegratePalace_Properties_Template_Dynamic_CSS')) {

    class IntegratePalace_Properties_Template_Dynamic_CSS {

        public function template_customization() {
            $options = get_option(IPPR_SETTINGS, []);
            $template_type = get_option('ipp_select_template', 'palace-property');
            $template_colors = $options[$template_type] ?? [];
            $button_colors = $options[$template_type] ?? [];
    
            // Typography
            $body_font = $options['body_font_family'] ?? 'Euclid Circular B';
            $heading_font = $options['heading_font_family'] ?? 'Euclid Circular B';
    
            // Primary Colors
            $pColor = $template_colors['primary_color'] ?? '#1d4ed8';
            $pColorH = $template_colors['primary_color_h'] ?? '#091057';
    
            // Secondary Colors
            $sColor = $template_colors['secondary_color'] ?? '#0433ff';
            $sColorH = $template_colors['secondary_color_h'] ?? '#020fa6';
    
            // Primary Button Colors and Styles
            $pBtnColor = $button_colors['button_primary_color'] ?? '#fff';
            $pBtnColorH = $button_colors['ipp_primary_button_color_h'] ?? '#fff';
            $pBtnBg = $button_colors['button_primary_bg_color'] ?? '#1d4ed8';
            $pBtnBgH = $button_colors['button_primary_bg_color_h'] ?? '#091057';
            $pBtnBorder = $button_colors['button_primary_border_color'] ?? '#1d4ed8';
            $pBtnBorderH = $button_colors['button_primary_border_color_h'] ?? '#091057';
    
            // Primary Button Font Size and Style
            $pBtnFontSizeD = $options['primary_btn_font_size']['desktop'] ?? '16';
            $pBtnFontSizeT = $options['primary_btn_font_size']['tablet'] ?? '16';
            $pBtnFontSizeM = $options['primary_btn_font_size']['mobile'] ?? '16';
    
            $pBtnFont = $options['primary_btn_font_family'] ?? 'Euclid Circular B';
            $pBtnFontWeight = $options['primary_btn_font_weight'] ?? '400';
            $pBtnFontUnit = $options['primary_btn_font_size_unit'] ?? 'px';
    
            // Primary Button Padding
            $pBtnPaddingTD = $settings['primary_btn_paddings']['desktop']['top'] ?? 0.625;
            $pBtnPaddingRD = $settings['primary_btn_paddings']['desktop']['right'] ?? 1.5;
            $pBtnPaddingBD = $settings['primary_btn_paddings']['desktop']['bottom'] ?? 0.625;
            $pBtnPaddingLD = $settings['primary_btn_paddings']['desktop']['left'] ?? 1.5;
            $pBtnPaddingUnit = $settings['primary_btn_paddings']['unit'] ?? 'rem';
            $pBtnPaddings_D = esc_attr($pBtnPaddingTD) . $pBtnPaddingUnit . ' ' . esc_attr($pBtnPaddingRD) . $pBtnPaddingUnit . ' ' . esc_attr($pBtnPaddingBD) . $pBtnPaddingUnit . ' ' . esc_attr($pBtnPaddingLD) . $pBtnPaddingUnit;
    
            // Primary Button Border Radius
            $pBtnRadiusTL_D = $options['primary_btn_border_radius']['desktop']['top'] ?? '0.25';
            $pBtnRadiusTR_D = $options['primary_btn_border_radius']['desktop']['right'] ?? '0.25';
            $pBtnRadiusBR_D = $options['primary_btn_border_radius']['desktop']['bottom'] ?? '0.25';
            $pBtnRadiusBL_D = $options['primary_btn_border_radius']['desktop']['left'] ?? '0.25';
            $pBtnRadiusUnit = $options['primary_btn_border_radius']['unit'] ?? 'rem';
            $pBtnRadius_D = esc_attr($pBtnRadiusTL_D) . $pBtnRadiusUnit . ' ' . esc_attr($pBtnRadiusTR_D) . $pBtnRadiusUnit . ' ' . esc_attr($pBtnRadiusBR_D) . $pBtnRadiusUnit . ' ' . esc_attr($pBtnRadiusBL_D) . $pBtnRadiusUnit;
    
            // Primary Button Border
            $pBtnBorderT = $options['primary_btn_border_width']['desktop']['top'] ?? '2';
            $pBtnBorderR = $options['primary_btn_border_width']['desktop']['right'] ?? '2';
            $pBtnBorderB = $options['primary_btn_border_width']['desktop']['bottom'] ?? '2';
            $pBtnBorderL = $options['primary_btn_border_width']['desktop']['left'] ?? '2';
            $pBtnBorderUnit = $options['primary_btn_border_width']['unit'] ?? 'px';
    

            // Secondary Button Colors and Styles
            $sBtnColor = $button_colors['button_secondary_color'] ?? '#1d4ed8';
            $sBtnColorH = $button_colors['ipp_secondary_button_color_h'] ?? '#fff';
            $sBtnBg = $button_colors['button_secondary_bg_color'] ?? '#fff';
            $sBtnBgH = $button_colors['button_secondary_bg_color_h'] ?? '#1d4ed8';
            $sBtnBorder = $button_colors['button_secondary_border_color'] ?? '#1d4ed8';
            $sBtnBorderH = $button_colors['button_secondary_border_color_h'] ?? '#1d4ed8';

            // Secondary Button Font Size and Style
            $sBtnFontSizeD = $options['secondary_btn_font_size']['desktop'] ?? '16';
            $sBtnFontSizeT = $options['secondary_btn_font_size']['tablet'] ?? '16';
            $sBtnFontSizeM = $options['secondary_btn_font_size']['mobile'] ?? '16';

            $sBtnFont = $options['secondary_btn_font_family'] ?? 'Euclid Circular B';
            $sBtnFontWeight = $options['secondary_btn_font_weight'] ?? '400';
            $sBtnFontUnit = $options['secondary_btn_font_size_unit'] ?? 'px';

            // Secondary Button Padding
            $sBtnPaddingTD = $settings['secondary_btn_paddings']['desktop']['top'] ?? 0.625;
            $sBtnPaddingRD = $settings['secondary_btn_paddings']['desktop']['right'] ?? 1.5;
            $sBtnPaddingBD = $settings['secondary_btn_paddings']['desktop']['bottom'] ?? 0.625;
            $sBtnPaddingLD = $settings['secondary_btn_paddings']['desktop']['left'] ?? 1.5;
            $sBtnPaddingUnit = $settings['secondary_btn_paddings']['unit'] ?? 'rem';
            $sBtnPaddings_D = esc_attr($sBtnPaddingTD) . $sBtnPaddingUnit . ' ' . esc_attr($sBtnPaddingRD) . $sBtnPaddingUnit . ' ' . esc_attr($sBtnPaddingBD) . $sBtnPaddingUnit . ' ' . esc_attr($sBtnPaddingLD) . $sBtnPaddingUnit;

            // Secondary Button Border Radius
            $sBtnRadiusTL_D = $options['secondary_btn_border_radius']['desktop']['top'] ?? '0.25';
            $sBtnRadiusTR_D = $options['secondary_btn_border_radius']['desktop']['right'] ?? '0.25';
            $sBtnRadiusBR_D = $options['secondary_btn_border_radius']['desktop']['bottom'] ?? '0.25';
            $sBtnRadiusBL_D = $options['secondary_btn_border_radius']['desktop']['left'] ?? '0.25';
            $sBtnRadiusUnit = $options['secondary_btn_border_radius']['unit'] ?? 'rem';
            $sBtnRadius_D = esc_attr($sBtnRadiusTL_D) . $sBtnRadiusUnit . ' ' . esc_attr($sBtnRadiusTR_D) . $sBtnRadiusUnit . ' ' . esc_attr($sBtnRadiusBR_D) . $sBtnRadiusUnit . ' ' . esc_attr($sBtnRadiusBL_D) . $sBtnRadiusUnit;

            // Secondary Button Border
            $sBtnBorderT = $options['secondary_btn_border_width']['desktop']['top'] ?? '2';
            $sBtnBorderR = $options['secondary_btn_border_width']['desktop']['right'] ?? '2';
            $sBtnBorderB = $options['secondary_btn_border_width']['desktop']['bottom'] ?? '2';
            $sBtnBorderL = $options['secondary_btn_border_width']['desktop']['left'] ?? '2';
            $sBtnBorderUnit = $options['secondary_btn_border_width']['unit'] ?? 'px';




            echo "<style>
    
                .integerate_palace-content {
                    font-family: " . esc_attr($body_font) . " !important;
                }
    
                .integerate_palace-content h1,
                .integerate_palace-content h2,
                .integerate_palace-content h3,
                .integerate_palace-content h4,
                .integerate_palace-content h5,
                .integerate_palace-content h6 {
                    font-family: " . esc_attr($heading_font) . " !important;
                }
    
                .ipp-primary-color {
                    color: " . esc_attr($pColor) . ";
                }
    
                .ipp-primary-color:hover, .ipp-primary-color:focus {
                    color: " . esc_attr($pColorH) . ";
                }
    
                .ipp-secondary-color {
                    color: " . esc_attr($sColor) . ";
                }
    
                .ipp-secondary-color:hover, .ipp-secondary-color:focus {
                    color: " . esc_attr($sColorH) . ";
                }

                .ipp-primary-button {
                    font-size: " . esc_attr($pBtnFontSizeD) . esc_attr($pBtnFontUnit) . ";
                    font-weight: " . esc_attr($pBtnFontWeight) . ";
                    color: " . esc_attr($pBtnColor) . ";
                    border-color: " . esc_attr($pBtnBorder) . ";
                    background-color: " . esc_attr($pBtnBg) . ";
                    font-family: " . esc_attr($pBtnFont) . ";
                    padding: $pBtnPaddings_D;
                    border-radius: $pBtnRadius_D;
                    border-style: solid;
                    border-top-width: " . esc_attr($pBtnBorderT) . esc_attr($pBtnBorderUnit) . ";
                    border-right-width: " . esc_attr($pBtnBorderR) . esc_attr($pBtnBorderUnit) . ";
                    border-bottom-width: " . esc_attr($pBtnBorderB) . esc_attr($pBtnBorderUnit) . ";
                    border-left-width: " . esc_attr($pBtnBorderL) . esc_attr($pBtnBorderUnit) . ";
                    cursor: pointer;
                }

                .ipp-primary-button:hover, .ipp-primary-button:focus {
                    color: " . esc_attr($pBtnColorH) . ";
                    border-color: " . esc_attr($pBtnBorderH) . ";
                    background-color: " . esc_attr($pBtnBgH) . ";
                }

                .ipp-secondary-button {
                    font-size: " . esc_attr($sBtnFontSizeD) . esc_attr($sBtnFontUnit) . ";
                    font-weight: " . esc_attr($sBtnFontWeight) . ";
                    color: " . esc_attr($sBtnColor) . ";
                    border-color: " . esc_attr($sBtnBorder) . ";
                    background-color: " . esc_attr($sBtnBg) . ";
                    font-family: " . esc_attr($sBtnFont) . ";
                    padding: $sBtnPaddings_D;
                    border-radius: $sBtnRadius_D;
                    border-style: solid;
                    border-top-width: " . esc_attr($sBtnBorderT) . esc_attr($sBtnBorderUnit) . ";
                    border-right-width: " . esc_attr($sBtnBorderR) . esc_attr($sBtnBorderUnit) . ";
                    border-bottom-width: " . esc_attr($sBtnBorderB) . esc_attr($sBtnBorderUnit) . ";
                    border-left-width: " . esc_attr($sBtnBorderL) . esc_attr($sBtnBorderUnit) . ";
                    cursor: pointer;
                }

                .ipp-secondary-button:hover, .ipp-secondary-button:focus {
                    color: " . esc_attr($sBtnColorH) . ";
                    border-color: " . esc_attr($sBtnBorderH) . ";
                    background-color: " . esc_attr($sBtnBgH) . ";
                }



            </style>";
        }

    }
}
