<?php
if ( ! class_exists( 'IntegratePalace_Properties_Customizer_Sanitizes' ) ) {

    class IntegratePalace_Properties_Customizer_Sanitizes {

		// Sanitize Container
		public static function sanitize_layout_type( $layout ) {

			$valid = array(
				'w-full',
				'container',
			);
		
			return in_array( $layout, $valid ) ? $layout : 'container';
		}

		// Sanitize Property Layout
		public static function sanitize_property_layout( $layout ) {

			$valid = array(
				'classic-layout',
				'grid-layout',
				'list-layout',
				'cover-layout',
			);
		
			return in_array( $layout, $valid ) ? $layout : 'grid-layout';
		}

		// Sanitize Sidebar Layout
		public static function sanitize_sidebar_layout( $layout ) {

			$valid = array(
				'right-sidebar',
				'left-sidebar',
				'no-sidebar',
			);
		
			return in_array( $layout, $valid ) ? $layout : 'right-sidebar';
		}

		// Sanitize Alpha color
		public static function sanitize_alpha_color( $color ) {

			if ( '' === $color ) {
				return '';
			}

			// CSS variable value sanitize.
			if ( 0 === strpos( $color, 'var(--' ) ) {
				return preg_replace( '/[^A-Za-z0-9_)(\-,.]/', '', $color );
			}

			if ( false === strpos( $color, 'rgba' ) ) {
				/* Hex sanitize */
				return self::sanitize_hex_color( $color );
			}

			/* rgba sanitize */
			$color = str_replace( ' ', '', $color );
			sscanf( $color, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha );
			return 'rgba(' . $red . ',' . $green . ',' . $blue . ',' . $alpha . ')';
		}

		// Sanitize the padding values
        public static function sanitize_responsive_button($value) {
			$sanitized = [
				'desktop' => array_map('absint', $value['desktop'] ?? []),
				'tablet' => array_map('absint', $value['tablet'] ?? []),
				'mobile' => array_map('absint', $value['mobile'] ?? []),
				'unit' => in_array($value['unit'], ['px', 'em', '%']) ? $value['unit'] : 'px',
			];
			return $sanitized;
		}
		
        // Sanitize Font Weight
		public static function sanitize_font_weight( $input ) {

			$valid = array(
				'inherit',
				'normal',
				'bold',
				'100',
				'200',
				'300',
				'400',
				'500',
				'600',
				'700',
				'800',
				'900',
			);
			

			if ( in_array( $input, $valid ) ) {
				return $input;
			} else {
				return 'normal';
			}
		}


		public static function sanitize_units($value) {
			// Check if the provided value is in the allowed units
			$allowed_units = ['px', 'em', 'rem', '%'];
			return in_array($value, $allowed_units, true) ? $value : 'px';
		}


		public static function sanitize_responsive_font_size( $input ) {
			// Check if $input is an array
			if ( ! is_array( $input ) ) {
				return [];
			}
	
			// Sanitize for desktop
			if ( ! isset( $input['desktop'] ) ) {
				$input['desktop'] = 16; 
			} else {
				$input['desktop'] = is_numeric( $input['desktop'] ) && $input['desktop'] >= 0 ? intval( $input['desktop'] ) : 16;
			}
	
			// Sanitize for tablet
			if ( ! isset( $input['tablet'] ) ) {
				$input['tablet'] = 16; 
			} else {
				$input['tablet'] = is_numeric( $input['tablet'] ) && $input['tablet'] >= 0 ? intval( $input['tablet'] ) : 16;
			}
	
			// Sanitize for mobile
			if ( ! isset( $input['mobile'] ) ) {
				$input['mobile'] = 16; 
			} else {
				$input['mobile'] = is_numeric( $input['mobile'] ) && $input['mobile'] >= 0 ? intval( $input['mobile'] ) : 16;
			}
	
			return $input;
		}
		
		



    }
}