<?php

if ( ! class_exists( 'IntegratePalace_Properties_Customizer_Register_Sections_Panels' ) ) {

    class IntegratePalace_Properties_Customizer_Register_Sections_Panels extends IntegratePalace_Properties_Customizer_Config_Base {

        public function register_configuration( $configurations, $wp_customize ) {

            $_configs = array(
                // Register Panels
                array(
                    'name'     => 'ippr_customize_template', 
                    'type'     => 'panel',
                    'title'    => __( 'Integrate Palace Properties', 'integrate-palace-properties' ),
                ),

                array(
                    'name'     => 'ippr_customize_template_global',
                    'type'     => 'panel',
                    'panel'    => 'ippr_customize_template', 
                    'title'    => __( 'Global', 'integrate-palace-properties' ),
                ),

                // Register Sections

                array(
                    'name'     => IPPR_SETTINGS . '[archive_page_section]',
                    'type'     => 'section',
                    'title'    => __( 'Archive / Property', 'integrate-palace-properties' ),
                    'panel'    => 'ippr_customize_template', 
                    'priority' => 10,
                ),

                array(
                    'name'     => IPPR_SETTINGS . '[single_page_section]',
                    'type'     => 'section',
                    'title'    => __( 'Single Property', 'integrate-palace-properties' ),
                    'panel'    => 'ippr_customize_template', 
                    'priority' => 10,
                ),

                array(
                    'name'     => IPPR_SETTINGS . '[template_colors_section]',
                    'type'     => 'section',
                    'title'    => __( 'Colors', 'integrate-palace-properties' ),
                    'panel'    => 'ippr_customize_template_global', 
                    'priority' => 10,
                ),

                array(
                    'name'     => IPPR_SETTINGS . '[template_buttons_section]',
                    'type'     => 'section',
                    'title'    => __( 'Buttons', 'integrate-palace-properties' ),
                    'panel'    => 'ippr_customize_template_global', 
                    'priority' => 10,
                ),

                array(
                    'name'     => IPPR_SETTINGS . '[template_typography_section]',
                    'type'     => 'section',
                    'title'    => __( 'Typography', 'integrate-palace-properties' ),
                    'panel'    => 'ippr_customize_template_global', 
                    'priority' => 10,
                ),

                // Section Heading 
                array(
                    'name'     => IPPR_SETTINGS . '[section_heading_setting]',
                    'default'  => '',
                    'type'     => 'setting',
                    'sanitize_callback'      => 'sanitize_text_field',
                ),

                // Section Tab 
                array(
                    'name'     => IPPR_SETTINGS . '[section_tab_setting]',
                    'default'  => '',
                    'type'     => 'setting',
                    'sanitize_callback'      => 'sanitize_text_field',
                ),

            );
            


            return array_merge( $configurations, $_configs );


        }
    }
}

new IntegratePalace_Properties_Customizer_Register_Sections_Panels();

