(function ($) {
  wp.customize.bind("ready", function () {
    var previousUrl = wp.customize.previewer.previewUrl.get(); // Store the initial URL

    wp.customize.section(
      "integrate_palace_archive_property",
      function (section) {
        section.expanded.bind(function (isExpanded) {
          if (isExpanded) {
            wp.customize.previewer.previewUrl.set(
              url_params.siteUrl + "/palace-property"
            );
          } else {
            wp.customize.previewer.previewUrl.set(previousUrl);
          }
        });
      }
    );

    // wp.customize.section( 'integrate_palace_single_property', function( section ) {
    //     section.expanded.bind( function( isExpanded ) {
    //         if ( isExpanded ) {
    //             wp.customize.previewer.previewUrl.set();
    //         } else {
    //             wp.customize.previewer.previewUrl.set(previousUrl);
    //         }
    //     });
    // });

    wp.customize.section("integrate_palace_typography", function (section) {
      section.expanded.bind(function (isExpanded) {
        if (isExpanded) {
          wp.customize.previewer.previewUrl.set(
            url_params.siteUrl + "/palace-property"
          );
        } else {
          wp.customize.previewer.previewUrl.set(previousUrl);
        }
      });
    });

    // add classes to control
    wp.customize.control.each(function (control) {
      if (control.params.divider) {
        var dividerClasses = control.params.divider.split(" ");
        var classNames = dividerClasses
          .map(function (div) {
            return "ipp-" + div + "-divider";
          })
          .join(" ");

        $("#customize-control-" + control.id).addClass(classNames);
      }
      if (control.params.tab) {
        $("#customize-control-" + control.id).addClass(
          "ipp-buttons-tab_" + control.params.tab + "_button"
        );
      }
    });

    // Properties Per Page
    wp.customize.control(
      "integrate_palace_properties_per_page",
      function (control) {
        const minusButton = control.container.find(".ipp-minus");
        const plusButton = control.container.find(".ipp-plus");
        const inputField = control.container.find(".ipp-base-control input");

        minusButton.click(function () {
          var value = parseInt(inputField.val());
          if (value > 1) {
            value--;
          }
          inputField.val(value);
          inputField.trigger("change");
        });

        plusButton.click(function () {
          var value = parseInt(inputField.val());
          value++; // Increase the value
          inputField.val(value);
          inputField.trigger("change");
        });
      }
    );

    // Responsive Buttons

    const des_btn_pad = $(
      "#customize-control-integrate_palace_primary_button_padding_desktop"
    );
    const tab_btn_pad = $(
      "#customize-control-integrate_palace_primary_button_padding_tablet"
    );
    const mob_btn_pad = $(
      "#customize-control-integrate_palace_primary_button_padding_mobile"
    );
    des_btn_pad.show();
    tab_btn_pad.hide();
    mob_btn_pad.hide();

    const controls = [des_btn_pad, tab_btn_pad, mob_btn_pad];
    let currentIndex = 0;

    function responsive_btn_pad() {
      controls[currentIndex].hide();
      currentIndex = (currentIndex + 1) % controls.length;
      controls[currentIndex].show();
    }

    $(
      ".control-section-integrate_palace_section .ipp-responsive-device-icons .ipp-device-icons"
    ).on("click", function () {
      responsive_btn_pad();
    });

    // Wpp Fields Settings Modal
    $(".ipp-fs-toggle-icon").on("click", function (e) {
      e.preventDefault();
      $(this).toggleClass("open");
      $(".ipp-field-settings-modal").toggle();
    });

    // Section Tabs
    const integrate_palace_primary_btn = $(".ipp-buttons-tab_primary_button");
    const integrate_palace_secondary_btn = $(
      ".ipp-buttons-tab_secondary_button"
    );

    integrate_palace_secondary_btn.hide();
    $(".ipp-heading-tabs-button").on("click", function (e) {
      e.preventDefault();

      $(".ipp-heading-tabs-button").removeClass("nav-tab-active");
      $(this).addClass("nav-tab-active");

      if ($(this).hasClass("integrate_palace_primary_btn")) {
        integrate_palace_primary_btn.show();
        integrate_palace_secondary_btn.hide();
      } else {
        integrate_palace_primary_btn.hide();
        integrate_palace_secondary_btn.show();
      }
    });

    // Color Picker
    $(".ipp-color-picker").wpColorPicker({
      change: function (event, ui) {
        var color = ui.color.toString();
        var settingKey = $(event.target).data("customize-setting-link");
        if (settingKey) {
          wp.customize(settingKey, function (setting) {
            setting.set(color);
          });
          //wp.customize.previewer.refresh();
        }
      },
      clear: function () {
        //wp.customize.previewer.refresh();
      },
    });

    // Customization
    $(".ipp-color-picker").each(function () {
      var $container = $(this).closest(".wp-picker-container");
      var $pickerText = $(this)
        .closest($container)
        .find(".wp-color-result-text");
      var $inputWrap = $container.find(".wp-picker-input-wrap");
      var $pickerHolder = $container.find(".wp-picker-holder");
      var tooltipText = $(this).data("tooltip");

      $container.attr("data-tooltip", tooltipText);
      $pickerText.remove();
      $inputWrap
        .add($pickerHolder)
        .wrapAll('<div class="ipp-picker-container"></div>');
    });

    // Button Side Width Uniform
    $(".ipp-buton-settings-wrapper").each(function () {
      var wrapper = $(this);
      var inputsUniform = wrapper.find(".ipp-btn-side-width-input");
      var buttonUniform = wrapper.find(".ipp-spacing-input-item-uniform");
      var isUniform = false;
      var isUpdating = false;

      buttonUniform.on("click", function () {
        isUniform = !isUniform;
        $(this).toggleClass("connected", isUniform);
      });

      inputsUniform.on("input change", function () {
        if (isUpdating || !isUniform) return;

        var currentValue = $(this).val();
        isUpdating = true;

        inputsUniform.each(function () {
          if ($(this).val() !== currentValue) {
            $(this).val(currentValue).trigger("input");
          }
        });

        isUpdating = false;
      });

      wrapper
        .find('.ipp-buton-settings-unit input[type="radio"]')
        .each(function () {
          var label = $(this).parent("label");
          if ($(this).is(":checked")) {
            label.addClass("active");
          } else {
            label.removeClass("active");
          }
        });

      wrapper
        .find('.ipp-buton-settings-unit input[type="radio"]')
        .on("change", function () {
          wrapper.find(".ipp-buton-settings-unit label").removeClass("active");
          $(this).parent("label").addClass("active");
        });
    });

    /*

     
        // Function to update the input value based on active device and unit
// Object to store font sizes for each device
var fontSizes = {
    desktop: 16, // Default value for desktop (change as needed)
    tablet: 14,  // Default value for tablet (change as needed)
    mobile: 12   // Default value for mobile (change as needed)
};

// Function to update the input value based on active device and unit
function integrate_palace_body_font_size_settings() {
    // Get the active device (desktop, tablet, mobile)
    var activeDevice = $('.ipp-responsive-slider-btns li.active').find('button').data('device');
    
    // Get the active unit (px or rem) for the active device
    var activeUnit = $('.input-field-wrapper.' + activeDevice + ' .single-unit.active').data('unit');
    
    // Get the font size value for the current active device from the stored values
    var fontSizeValue = fontSizes[activeDevice];
    
    // Set the font size input to the value corresponding to the active device
    $('#body-font-size-input').val(fontSizeValue);
    
    // Debugging output (optional)
    console.log('Active Device: ' + activeDevice);
    console.log('Active Unit: ' + activeUnit);
    console.log('Font Size Value for ' + activeDevice + ': ' + fontSizeValue);
}

// Listen to device change (desktop, tablet, mobile) with cycling behavior
$('.ipp-responsive-slider-btns button').on('click', function() {
    // Get the current active device
    var $activeDeviceItem = $('.ipp-responsive-slider-btns li.active');
    
    // Remove the active class from the current device
    $activeDeviceItem.removeClass('active');
    
    // Move to the next device (cycling back to the first if we're at the end)
    var $nextDeviceItem = $activeDeviceItem.next('li');
    if ($nextDeviceItem.length === 0) {
        // If no next device, go back to the first device
        $nextDeviceItem = $('.ipp-responsive-slider-btns li').first();
    }

    // Add the active class to the next device
    $nextDeviceItem.addClass('active');
    
    // Get the newly active device type (desktop, tablet, mobile)
    var activeDevice = $nextDeviceItem.find('button').data('device');
    
    // Hide all unit wrappers (px, rem for desktop/tablet/mobile)
    $('.ipp-responsive-units').removeClass('active');
    
    // Show the unit wrapper for the newly active device
    $('.input-field-wrapper.' + activeDevice).addClass('active');
    
    // Update the input field and unit based on the newly active device
    integrate_palace_body_font_size_settings();
});

// Trigger when input value changes
$('#body-font-size-input').on('change', function() {
    // Get the active device (desktop, tablet, mobile)
    var activeDevice = $('.ipp-responsive-slider-btns li.active').find('button').data('device');
    
    // Update the stored font size value for the active device
    fontSizes[activeDevice] = $(this).val();
    
    // Debugging output (optional)
    console.log('Updated Font Size for ' + activeDevice + ': ' + fontSizes[activeDevice]);
});

// Listen to unit change (px/rem)
$('.ipp-responsive-units .single-unit').on('click', function() {
    // Remove active class from all units in the current device's wrapper
    $(this).closest('.input-field-wrapper').find('.single-unit').removeClass('active');
    
    // Add the active class to the clicked unit
    $(this).addClass('active');

    // Update the font size input after changing the unit
    integrate_palace_body_font_size_settings();
});


*/
  });
})(jQuery);
