<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties {

    protected $loader;

    protected $plugin_name;

    protected $version;
    protected $integrate_palace_dir;
    protected $integrate_palace_uri;

    public function __construct() {
        $this->plugin_name = 'integrate-palace-properties';
        $this->version = INTEGRATE_PALACE_P_VERSION;
        $this->integrate_palace_dir = INTEGRATE_PALACE_P_PLUGIN_DIR;
        $this->integrate_palace_uri = INTEGRATE_PALACE_P_PLUGIN_URI;

        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
        $this->define_admin_menu();
        $this->register_settings();
        $this->register_webhooks();
        $this->define_palace_properties();
        $this->integrate_palace_local_fields();
        $this->define_integrate_palace_templates();
        $this->define_integrate_palace_customizer();
        $this->define_ippr_template_defaults();
        $this->define_integrate_palace_customizer();
    }

    private function load_dependencies() {
        require_once $this->integrate_palace_dir . 'includes/class-integratepalacep-loader.php';
        require_once $this->integrate_palace_dir . 'includes/class-integratepalacep-webhooks.php';
        require_once $this->integrate_palace_dir . 'admin/class-integratepalacep-admin.php';
        require_once $this->integrate_palace_dir . 'admin/class-integratepalacep-dashboard.php';
        require_once $this->integrate_palace_dir . 'admin/class-integratepalacep-configs.php';
        require_once $this->integrate_palace_dir . 'admin/class-integratepalacep-templates.php';
        require_once $this->integrate_palace_dir . 'includes/class-integratepalacep-settings.php';
        require_once $this->integrate_palace_dir . 'includes/class-integratepalacep-register-properties.php';
        require_once $this->integrate_palace_dir . 'includes/class-integratepalacep-local-fields.php';
        require_once $this->integrate_palace_dir . 'includes/class-integratepalacep-templates.php';
        require_once $this->integrate_palace_dir . 'includes/class-integratepalacep-customizer.php';
        require_once $this->integrate_palace_dir . 'public/class-integratepalacep-svg-icons.php';
        require_once $this->integrate_palace_dir . 'public/class-integratepalacep-public.php';
        require_once $this->integrate_palace_dir . 'includes/customizer/class-integratepalacep-template-defaults.php';
        require_once $this->integrate_palace_dir . 'includes/customizer/class-integratepalacep-template-dynamic-css.php';
        
        $this->loader = new IntegratePalace_Properties_Loader();
    }

    private function define_admin_hooks() {
        $plugin_admin = new IntegratePalace_Properties_Admin( $this->get_plugin_name(), $this->get_version() );
        $this->loader->add_filter( 'plugin_row_meta', $plugin_admin, 'integrate_palace_properties_plugin_row_meta',10,2);
        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
        $this->loader->add_action( 'update_integrate_palace_gallery', $plugin_admin, 'update_integrate_palace_gallery',10,2);
    }


    private function define_public_hooks() {
        // Create instances of the classes
        $plugin_public = new IntegratePalace_Properties_Public( $this->get_plugin_name(), $this->get_version() );
        $template_dynamic_css = new IntegratePalace_Properties_Template_Dynamic_CSS();
    
        // Add actions and filters using the loader
        $this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
        $this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'integrate_palace_enqueue_fonts' );
        $this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
        
        // Custom template filter
        $this->loader->add_filter( 'template_include', $plugin_public, 'use_palace_property_template' );
        
        // Add custom dynamic CSS to the head
        $this->loader->add_action( 'wp_head', $template_dynamic_css, 'template_customization' );
    }
    

    private function define_palace_properties() { // Custom Post type
        $palace_properties = new IntegratePalace_Properties_Register_Properties();
        $this->loader->add_action( 'init', $palace_properties, 'register_palace_properties' );
    }

    private function integrate_palace_local_fields() {
        $ipp_local_fields = new IntegratePalace_Properties_Local_Fields();
        $this->loader->add_action('add_meta_boxes', $ipp_local_fields, 'integrate_palace_register_local_fields');
        $this->loader->add_action('add_meta_boxes', $ipp_local_fields, 'integrate_palace_register_gallery');
        $this->loader->add_action('save_post_palace-properties', $ipp_local_fields, 'integrate_palace_save_local_fields');
        $this->loader->add_action('save_post_palace-properties', $ipp_local_fields, 'save_integrate_palace_gallery');
    }



    private function define_integrate_palace_templates() {
        $integrate_palace_templates = new IntegratePalace_Properties_Templates();
        $this->loader->add_action( 'admin_init', $integrate_palace_templates, 'register_templates' );
    }

    private function define_ippr_template_defaults() {
        $ippr_template_defaults = new IntegratePalace_Properties_Template_Defaults();
        $this->loader->add_action( 'plugins_loaded', $ippr_template_defaults, 'initialize_defaults' );
    }

    private function define_admin_menu() {
        $this->loader->add_action( 'admin_menu', $this, 'add_admin_menu' );
    }
    
    private function register_settings() {
        $this->loader->add_action( 'admin_init', 'IntegratePalace_Properties_Settings', 'init' );
        
    }

    private function define_integrate_palace_customizer() {
        $integrate_palace_customizer = new IntegratePalace_Properties_Customizer();
        $this->loader->add_action('customize_register', $integrate_palace_customizer, 'include_configurations' , 2 );
        $this->loader->add_action('customize_register', $integrate_palace_customizer, 'prepare_customizer_configs');
        $this->loader->add_action('customize_register', $integrate_palace_customizer, 'customize_register_panel' , 2 );
        $this->loader->add_action( 'customize_controls_enqueue_scripts', $integrate_palace_customizer, 'ippr_customizer_scripts' );
        $this->loader->add_action( 'customize_controls_print_styles', $integrate_palace_customizer, 'ippr_customizer_styles' );
        // $this->loader->add_action('customize_register', $integrate_palace_customizer, 'integrate_palace_register_customizer');
        // $this->loader->add_action( 'customize_controls_enqueue_scripts', $integrate_palace_customizer, 'integrate_palace_customizer_scripts' );
        // $this->loader->add_action( 'customize_controls_print_styles', $integrate_palace_customizer, 'integrate_palace_customizer_styles' );
    }

    private function register_webhooks() {
        IntegratePalace_Properties_Webhooks::init();
    }

    public function add_admin_menu() {
        add_menu_page(
            __( 'WP Palace Properties', 'integrate-palace-properties' ),
            __( 'WP Palace Properties', 'integrate-palace-properties' ),
            'manage_options',
            'integrate-palace-properties',
            array( $this, 'display_dashboard_page' ),
            'dashicons-admin-home'
        );

        add_submenu_page(
            'integrate-palace-properties',
            __( 'All Properties', 'integrate-palace-properties' ),
            __( 'All Properties', 'integrate-palace-properties' ),
            'manage_options',
            'edit.php?post_type=palace-properties'
        );

        add_submenu_page(
            'integrate-palace-properties',
            __( 'Configs', 'integrate-palace-properties' ),
            __( 'Configs', 'integrate-palace-properties' ),
            'manage_options',
            'integrate-palace-properties-configs',
            array( $this, 'display_configs_page' )
        );

        add_submenu_page(
            'integrate-palace-properties',
            __( 'Template Settings', 'integrate-palace-properties' ),
            __( 'Template Settings', 'integrate-palace-properties' ),
            'manage_options',
            'customize.php?autofocus[panel]=integrate_palace_property_settings',
            null
        );        

        add_submenu_page(
            'integrate-palace-properties',
            __( 'Templates', 'integrate-palace-properties' ),
            __( 'Templates', 'integrate-palace-properties' ),
            'manage_options',
            'palace-property_templates',
            array( $this, 'display_templates' )
        );

    }

    public function display_dashboard_page() {
        require_once $this->integrate_palace_dir . 'admin/class-integratepalacep-dashboard.php';
        $dashboard = new IntegratePalace_Properties_Dashboard();
        $dashboard->display();
    }

    public function display_configs_page() {
        require_once $this->integrate_palace_dir . 'admin/class-integratepalacep-configs.php';
        $configs = new IntegratePalace_Properties_Configs();
        $configs->display();
    }

    public function display_templates() {
        require_once $this->integrate_palace_dir . 'admin/class-integratepalacep-templates.php';
        $configs = new IntegratePalace_Properties_Templates_Display();
        $configs->display();
    }

    public function run() {
        $this->loader->run();
    }

    public function get_plugin_name() {
        return $this->plugin_name;
    }

    public function get_version() {
        return $this->version;
    }
}
