<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties_Templates {
    
    public static function register_templates() {

        register_setting( 
            'IntegratePalace_Properties_Templates', 
            'integrate_palace_select_template', 
            array( 
                'sanitize_callback' => 'sanitize_text_field'
            ) 
        );

        add_settings_section(
            'integrate_palace_select_template_section',
            __( '<br>Palace Properties Template', 'integrate-palace-properties' ),
            null,
            'IntegratePalace_Properties_Templates'
        );

        add_settings_field(
            'integrate_palace_select_template',
            '',
            array( __CLASS__, 'render_template_fields' ),
            'IntegratePalace_Properties_Templates',
            'integrate_palace_select_template_section'
        );
    }

  
    public static function render_template_fields() {
        $options = get_option( 'integrate_palace_select_template', 'palace-property' );
        ?>
        <div class="ipp-select-template">
            <div class="ipp-template-box">
                <input type="radio" id="palace-property" name="integrate_palace_select_template" value="palace-property" <?php checked( $options, 'palace-property' ); ?> />
                <label for="palace-property">
                <img src="<?php echo esc_url( plugin_dir_url( dirname(__FILE__, 1) ) . 'admin/assets/img/150x300.svg' ); ?>" alt="Palace Property Template" />
                <div class="ipp-select-template-name"><span><?php esc_html_e( 'Palace Property', 'integrate-palace-properties' ); ?></span></div>
                </label>
            </div>
            <div class="ipp-template-box">
                <input type="radio" id="classic" name="integrate_palace_select_template" value="classic" <?php checked( $options, 'classic' ); ?> disabled />
                <label for="classic">
                <img src="<?php echo esc_url( plugin_dir_url( dirname(__FILE__, 1) ) . 'admin/assets/img/coming-soon-thumb.jpg' ); ?>" alt="Classic Template" />
                <div class="ipp-select-template-name"><span><?php esc_html_e( 'Classic', 'integrate-palace-properties' ); ?></span></div>
                </label>
            </div>
            <div class="ipp-template-box">
                <input type="radio" id="modern" name="integrate_palace_select_template" value="modern" <?php checked( $options, 'modern' ); ?> disabled />
                <label for="modern">
                <img src="<?php echo esc_url( plugin_dir_url( dirname(__FILE__, 1) ) . 'admin/assets/img/coming-soon-thumb.jpg' ); ?>" alt="Modern Template" />
                <div class="ipp-select-template-name"><span><?php esc_html_e( 'Modern', 'integrate-palace-properties' ); ?></span></div>
                </label>
            </div>
        </div>
        <?php
    }
}
