<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties_Settings {

    public static function init() {
        self::register_settings();
        add_action('update_option_integrate_palace_properties_username', [__CLASS__, 'settings_updated'], 10, 3);
        add_action('update_option_integrate_palace_properties_password', [__CLASS__, 'settings_updated'], 10, 3);
        add_action('update_option_integrate_palace_properties_subscription_key', [__CLASS__, 'settings_updated'], 10, 3);
        add_action('update_option_integrate_palace_properties_slug', [__CLASS__, 'settings_updated'], 10, 3);
    }

    public static function register_settings() {
        register_setting('integrate_palace_properties_configs', 'integrate_palace_properties_username', ['sanitize_callback' => 'sanitize_text_field']);
        register_setting('integrate_palace_properties_configs', 'integrate_palace_properties_password', ['sanitize_callback' => 'sanitize_text_field']);
        register_setting('integrate_palace_properties_configs', 'integrate_palace_properties_subscription_key', ['sanitize_callback' => 'sanitize_text_field']);
        register_setting('integrate_palace_properties_configs', 'integrate_palace_properties_slug', ['sanitize_callback' => 'sanitize_text_field']);

        add_settings_section(
            'integrate_palace_properties_settings_section',
            __('WP Palace Properties Settings', 'integrate-palace-properties'),
            null,
            'integrate_palace_properties_configs'
        );

        add_settings_field(
            'integrate_palace_properties_username',
            __('Palace API Username', 'integrate-palace-properties'),
            [__CLASS__, 'render_username_field'],
            'integrate_palace_properties_configs',
            'integrate_palace_properties_settings_section'
        );

        add_settings_field(
            'integrate_palace_properties_password',
            __('Palace API Password', 'integrate-palace-properties'),
            [__CLASS__, 'render_password_field'],
            'integrate_palace_properties_configs',
            'integrate_palace_properties_settings_section'
        );

        add_settings_field(
            'integrate_palace_properties_subscription_key',
            __('Subscription Key', 'integrate-palace-properties'),
            [__CLASS__, 'render_subscription_key_field'],
            'integrate_palace_properties_configs',
            'integrate_palace_properties_settings_section'
        );

        add_settings_field(
            'integrate_palace_properties_slug',
            __('Property Slug', 'integrate-palace-properties'),
            [__CLASS__, 'render_palace_property_slug'],
            'integrate_palace_properties_configs',
            'integrate_palace_properties_settings_section'
        );

        add_settings_field(
            'integrate_palace_properties_webhook_status',
            __('STATUS', 'integrate-palace-properties'),
            [__CLASS__, 'render_webhook_status_field'],
            'integrate_palace_properties_configs',
            'integrate_palace_properties_settings_section'
        );


        
    }

    public static function render_username_field() {
        $value = get_option('integrate_palace_properties_username', '');
        echo '<input type="text" name="integrate_palace_properties_username" value="' . esc_attr($value) . '" class="ipp-full-width" />';
    }

    public static function render_password_field() {
        $value = get_option('integrate_palace_properties_password', '');
        echo '<input type="password" name="integrate_palace_properties_password" value="' . esc_attr($value) . '" class="ipp-full-width" />';
    }

    public static function render_subscription_key_field() {
        $value = get_option('integrate_palace_properties_subscription_key', '');
        echo '<input type="password" name="integrate_palace_properties_subscription_key" value="' . esc_attr($value) . '" class="ipp-full-width" />';
    }

    public static function render_palace_property_slug() {
        $value = get_option('integrate_palace_properties_slug', '');
        echo '<input type="text" name="integrate_palace_properties_slug" value="' . esc_attr($value) . '" class="ipp-full-width" />';
    }

    public static function render_webhook_status_field() {
        $value = get_option('integrate_palace_properties_webhook_status', '');
        echo '<label>' . wp_kses_post($value) . '</label>';
        $statusofsub = get_option('integrate_palace_properties_webhook_status', '');
        if (strpos($statusofsub, "Free") !== false) {
            echo "<br>";
            echo "<a target='_blank' href='" . esc_url("https://wp-palace.kiwibrain.co.nz/register") . "' class='button' style='background: #ffd700; color: #000; border-color: #ccac00;'>Get Free 6 Months Trial</a>";
        }
        
    }

    public static function settings_updated($old_value, $value, $option) {
        self::update_subscription();
        if ($option === 'integrate_palace_properties_slug') {
            unregister_post_type('palace-properties');
            $palace_properties = new IntegratePalace_Properties_Register_Properties();
            $palace_properties->register_palace_properties();
            flush_rewrite_rules();

        }
    }

    private static function update_subscription() {
        $username = get_option('integrate_palace_properties_username', '');
        $password = get_option('integrate_palace_properties_password', '');
        $subscription_key = get_option('integrate_palace_properties_subscription_key', '');
        $webhook_url = esc_url(rest_url('integrate-palace-properties/v1/webhook'));

        $response = wp_remote_post('https://wp-palace.kiwibrain.co.nz/api/update-user', [
            'method'    => 'POST',
            'body'      => wp_json_encode([
                'palace_api_key'    => base64_encode(sanitize_text_field($username) . ":" . sanitize_text_field($password)),
                'wp_palace_blog_id' => get_option("integrate_palace-palace-unique-id"),
                'webhook_url'       => $webhook_url,
                'subscription_key'  => sanitize_text_field($subscription_key)
            ]),
            'headers'   => [
                'Content-Type' => 'application/json',
            ],
        ]);

        if (is_wp_error($response)) {
            error_log("Failed to call API: " . $response->get_error_message());
        } else {
            $body = wp_remote_retrieve_body($response);
            $data = json_decode($body, true);

            if (isset($data['subscription']['webhook_url'])) {
                $subscription_name = sanitize_text_field($data['subscription']['name'] ?? '');
                $properties_allowed = isset($data['subscription']['properties_allowed']) ? sanitize_text_field($data['subscription']['properties_allowed']) : '';
                $properties_allowed = ($properties_allowed == '-1') ? "unlimited" : $properties_allowed;

                update_option('integrate_palace_properties_webhook_url', esc_url_raw($data['subscription']['webhook_url']));
                update_option('integrate_palace_properties_webhook_status', "<span class='wh_connected'><i>Connected ($subscription_name) Max Properties: " . esc_html($properties_allowed) . "</i><span>");
                error_log("API call successful and webhook URL updated");
            } else {
                update_option('integrate_palace_properties_webhook_status', "<span class='wh_error'><i>Invalid Subscription Key</i><span>");
                error_log("API call successful but webhook URL not found in response");
            }
        }
    }
}
?>
