<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties_Register_Properties {

    public function register_palace_properties() {
        if ( post_type_exists( "palace-properties") ) {
            return;
        }

        $labels = array(
            'name'               => _x( 'Palace Properties', 'post type general name', 'integrate-palace-properties' ),
            'singular_name'      => _x( 'Palace Property', 'post type singular name', 'integrate-palace-properties' ),
            'menu_name'          => _x( 'Palace Properties', 'admin menu', 'integrate-palace-properties' ),
            'name_admin_bar'     => _x( 'Palace Property', 'add new on admin bar', 'integrate-palace-properties' ),
            'add_new'            => _x( 'Add New', 'palace property', 'integrate-palace-properties' ),
            'add_new_item'       => __( 'Add New Palace Property', 'integrate-palace-properties' ),
            'new_item'           => __( 'New Palace Property', 'integrate-palace-properties' ),
            'edit_item'          => __( 'Edit Palace Property', 'integrate-palace-properties' ),
            'view_item'          => __( 'View Palace Property', 'integrate-palace-properties' ),
            'all_items'          => __( 'All Palace Properties', 'integrate-palace-properties' ),
            'search_items'       => __( 'Search Palace Properties', 'integrate-palace-properties' ),
            'parent_item_colon'  => __( 'Parent Palace Properties:', 'integrate-palace-properties' ),
            'not_found'          => __( 'No palace properties found.', 'integrate-palace-properties' ),
            'not_found_in_trash' => __( 'No palace properties found in Trash.', 'integrate-palace-properties' )
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'query_var'          => true,

            'rewrite'   => array(
        'slug'       => get_option('integrate_palace_properties_slug','palace-property'),
        'with_front' => false,
        'pages'      => true, // this also belongs in "rewrite" and not "labels"
    ),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'supports'           => array( 'title', 'editor', 'author', 'thumbnail' ),
            'publicly_queryable' => true,
            'show_in_nav_menus'  => false,
            'show_in_menu'       => false,
        );

        register_post_type( "palace-properties", $args );
        
        
    }

}