<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties_Local_Fields {

    // Register Local Fields
    public function integrate_palace_register_local_fields() {
        add_meta_box(
            'integrate_palace_local_fields',
            esc_html__('Property Details', 'integrate-palace-properties'),
            [$this, 'integrate_palace_local_fields_callback'],
            'palace-property',
            'normal',
            'high'
        );
    }

    // Register Gallery
    public function integrate_palace_register_gallery() {
        add_meta_box(
            'integrate_palace_gallery',
            esc_html__('Palace Property Gallery', 'integrate-palace-properties'),
            [$this, 'integrate_palace_gallery_callback'],
            'palace-property',
            'normal',
            'high'
        );
    }

    // Local Fields Callback
    public function integrate_palace_local_fields_callback($post) {
        wp_nonce_field('integrate_palace_save_local_fields', 'integrate_palace_local_fields_nonce');

        // Define fields with metadata (label and type)
        $fields = [
            'property_status' => ['label' => 'Property Status', 'type' => 'text'],
            'information_address' => ['label' => 'Information Address', 'type' => 'textarea'],
            'information_date' => ['label' => 'Information Date', 'type' => 'date'],
            'information_rent' => ['label' => 'Information Rent', 'type' => 'number'],
            'property_rental_period' => ['label' => 'Property Rental Period', 'type' => 'text'],
            'information_suburb' => ['label' => 'Information Suburb', 'type' => 'text'],
            'accommodation_amenities' => ['label' => 'Accommodation Amenities', 'type' => 'textarea'],
            'accommodation_bath_room' => ['label' => 'Accommodation Bath Room', 'type' => 'number'],
            'accommodation_bed_room' => ['label' => 'Accommodation Bed Room', 'type' => 'number'],
            'accommodation_automobile' => ['label' => 'Accommodation Automobile', 'type' => 'text'],
            'other_parking' => ['label' => 'Other Parking', 'type' => 'text'],
            'other_pets' => ['label' => 'Other Pets', 'type' => 'text'],
            'property_smokers_allowed' => ['label' => 'Smokers Allowed', 'type' => 'text'],
            'property_year_built' => ['label' => 'Year Built', 'type' => 'number'],
            'property_garage_parking' => ['label' => 'Garage Parking', 'type' => 'text'],
            'property_off_street_parking' => ['label' => 'Off-Street Parking', 'type' => 'text'],
            'property_suburb_code' => ['label' => 'Suburb Code', 'type' => 'text'],
            'property_suburb_district_or_postcode' => ['label' => 'District/Postcode', 'type' => 'text'],
            'property_suburb_name' => ['label' => 'Suburb Name', 'type' => 'text'],
            'property_suburb_region_or_state' => ['label' => 'Region/State', 'type' => 'text'],
            'property_suburb_type' => ['label' => 'Suburb Type', 'type' => 'text']
        ];

        $meta = [];
        foreach (array_keys($fields) as $field) {
            $meta[$field] = esc_attr(get_post_meta($post->ID, $field, true));
        }

        ?>
        <div id="integrate_palace_data_fields">
            <div class="integrate_palace_field_label">
                <label for="PropertyStatus"><?php esc_html_e('Property Details', 'integrate-palace-properties'); ?></label>
            </div>
            <div class="integrate_palace_field_group">
                <div class="integrate_palace_field_box integrate_palace_field_col_3_2">
                    <div class="integrate_palace_field_input_group">
                        <div class="integrate_palace_field_label">
                            <label for="PropertyStatus"><?php esc_html_e('Property Status', 'integrate-palace-properties'); ?></label>
                        </div>
                        <div class="integrate_palace_field_input">
                            <input type="text" id="PropertyStatus" name="PropertyStatus" value="<?php echo esc_attr($meta['property_status']); ?>" />
                        </div>
                    </div>
                    <div class="integrate_palace_field_input_group">
                        <div class="integrate_palace_field_label">
                            <label for="PropertyAddress"><?php esc_html_e('Address', 'integrate-palace-properties'); ?></label>
                        </div>
                        <div class="integrate_palace_field_input">
                            <input type="text" id="PropertyAddress" name="PropertyAddress" value="<?php echo esc_attr($meta['information_address']); ?>" />
                        </div>
                    </div>
                    <div class="integrate_palace_field_input_group">
                        <div class="integrate_palace_field_label">
                            <label for="PropertyDateAvailable"><?php esc_html_e('Date Available', 'integrate-palace-properties'); ?></label>
                        </div>
                        <div class="integrate_palace_field_input">
                            <input type="date" id="PropertyDateAvailable" name="PropertyDateAvailable" value="<?php echo esc_attr($meta['information_date']); ?>" />
                        </div>
                    </div>
                </div>
                <!-- Additional Fields -->
                <div class="integrate_palace_field_box integrate_palace_field_col_3">
                    <div class="integrate_palace_field_input_group">
                        <div class="integrate_palace_field_label">
                            <label for="PropertyRentAmount"><?php esc_html_e('Rent Amount', 'integrate-palace-properties'); ?></label>
                        </div>
                        <div class="integrate_palace_field_input">
                            <input type="text" id="PropertyRentAmount" name="PropertyRentAmount" value="<?php echo esc_attr($meta['information_rent']); ?>" />
                        </div>
                    </div>
                    <!-- Other fields as needed -->
                </div>
            </div>
        </div>
        <?php
    }

    // Save Local Fields
    public function integrate_palace_save_local_fields($post_id) {
        // Check nonce and permissions
        if ( ! isset( $_POST['integrate_palace_local_fields_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['integrate_palace_local_fields_nonce'] ) ), 'integrate_palace_save_local_fields' ) ) {
            return;
        }
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
        if (!current_user_can('edit_post', $post_id)) return;
        if (
            !isset($_POST['ipp_local_fields_nonce']) || 
            !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['ipp_local_fields_nonce'])), 'integrate_palace_save_local_fields')
        ) {
            return;
        }

        // Define fields with their types for sanitization
        $fields = [
            'property_status' => 'sanitize_text_field',
            'information_address' => 'sanitize_textarea_field',
            'information_date' => 'sanitize_text_field',
            'information_rent' => 'floatval',
            'property_rental_period' => 'sanitize_text_field',
            'information_suburb' => 'sanitize_text_field',
            'accommodation_amenities' => 'sanitize_textarea_field',
            'accommodation_bath_room' => 'intval',
            'accommodation_bed_room' => 'intval',
            'accommodation_automobile' => 'sanitize_text_field',
            'other_parking' => 'sanitize_text_field',
            'other_pets' => 'sanitize_text_field',
            'property_smokers_allowed' => 'sanitize_text_field',
            'property_year_built' => 'intval',
            'property_garage_parking' => 'sanitize_text_field',
            'property_off_street_parking' => 'sanitize_text_field',
            'property_suburb_code' => 'sanitize_text_field',
            'property_suburb_district_or_postcode' => 'sanitize_text_field',
            'property_suburb_name' => 'sanitize_text_field',
            'property_suburb_region_or_state' => 'sanitize_text_field',
            'property_suburb_type' => 'sanitize_text_field'
        ];

        foreach ($fields as $field_key => $sanitize_callback) {
            if (isset($_POST[$field_key])) {
                $value = call_user_func($sanitize_callback, wp_unslash($_POST[$field_key]));
                update_post_meta($post_id, $field_key, $value);
            } else {
                delete_post_meta($post_id, $field_key);
            }
        }
        
    }



    // Gallery Callback
    public function integrate_palace_gallery_callback($post) {
        wp_nonce_field(basename(__FILE__), 'integrate_palace_gallery_nonce');
        $gallery_ids = get_post_meta($post->ID, 'integrate_palace_gallery', true) ?: [];
        ?>
        <div id="integrate_palace_gallery">
            <ul class="gallery">
                <?php foreach ($gallery_ids as $id): ?>
                    <li data-attachment-id="<?php echo esc_attr($id); ?>">
                        <?php echo wp_get_attachment_image($id, 'thumbnail'); ?>
                        <input type="hidden" name="integrate_palace_gallery[]" value="<?php echo esc_attr($id); ?>">
                        <button type="button" class="remove_image button">X</button>
                    </li>
                <?php endforeach; ?>
            </ul>
            <input type="button" id="add_integrate_palace_gallery_image" class="button" value="<?php esc_attr_e('Add Gallery Image', 'integrate-palace-properties'); ?>">
        </div>
        <?php
    }

    // Save Gallery
    public function save_integrate_palace_gallery( $post_id ) {
        // Verify nonce
        if ( ! isset( $_POST['integrate_palace_gallery_nonce'] ) || 
             ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['integrate_palace_gallery_nonce'] ) ), basename( __FILE__ ) ) ) {
            return;
        }
    
        // Check for autosave
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }
    
        // Check user capabilities
        if ( ! current_user_can( 'edit_post', $post_id ) ) {
            return;
        }
    
        // Save gallery image IDs
        $gallery_ids = isset( $_POST['integrate_palace_gallery'] ) && is_array( $_POST['integrate_palace_gallery'] ) 
            ? array_map( 'intval', wp_unslash( $_POST['integrate_palace_gallery'] ) ) 
            : [];
    
        update_post_meta( $post_id, 'integrate_palace_gallery', $gallery_ids );
    }

}
