<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties_Loader {
    protected $actions;
    protected $filters;

    public function __construct() {
        $this->actions = array();
        $this->filters = array();
    }

    public function add_action( $hook, $component, $callback, $priorty=10, $no_args=1 ) {
        $this->actions[] = array(
            'hook'      => $hook,
            'component' => $component,
            'callback'  => $callback,
            'priorty'  => $priorty,
            'no_args'  => $no_args,
        );
    }

    public function add_filter( $hook, $component, $callback, $priorty=10, $no_args=1  ) {
        $this->filters[] = array(
            'hook'      => $hook,
            'component' => $component,
            'callback'  => $callback,
            'priorty'  => $priorty,
            'no_args'  => $no_args,
        );
    }

    public function run() {
        foreach ( $this->actions as $hook ) {
            add_action( $hook['hook'], array( $hook['component'], $hook['callback'] ),$hook['priorty'], $hook['no_args'] );
        }
        foreach ( $this->filters as $hook ) {
            add_filter( $hook['hook'], array( $hook['component'], $hook['callback'] ), $hook['priorty'], $hook['no_args'] );
        }
    }
}
