<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties_Customizer {

    private static $instance = null;
    private $version;

    public function __construct() {
        $this->version = INTEGRATE_PALACE_P_VERSION;
    }

    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function include_configurations() {

        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/configurations/class-integratepalacep-customizer-config-base.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/class-integratepalacep-customizer-register_sections_panels.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/configurations/class-integratepalacep-archive.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/configurations/class-integratepalacep-single.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/configurations/class-integratepalacep-colors-config.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/configurations/class-integratepalacep-buttons-config.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/configurations/class-integratepalacep-typography-config.php';


    }


    public function prepare_customizer_configs() {

        global $wp_customize;

        $configurations = $this->get_ippr_customizer_configurations();
        $defaults = $this->get_ippr_customizer_configuration_defaults();

        foreach ( $configurations as $key => $configuration ) {

            $config = wp_parse_args( $configuration, $defaults );

            if ( isset( $config['type'] ) ) {
                switch ( $config['type'] ) {
                    case 'panel':
                        $this->add_customize_panel( $wp_customize, $config );
                        break;
                    case 'section':
                        $this->add_customize_section( $wp_customize, $config );
                        break;
                    case 'setting':
                        $this->add_customize_setting( $wp_customize, $config );
                        break;
                    case 'control':
                        $this->add_customize_control( $wp_customize, $config );
                        break;
                }
            }
        }
    }


    public function customize_register_panel( $wp_customize ) {
        $wp_customize->register_panel_type( 'IntegratePalace_Properties_Property_Panel' );
        $wp_customize->register_section_type( 'IntegratePalace_Properties_Property_Customize_Section' );

        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/extend-customizer/class-integratepalacep-customize-panels.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/extend-customizer/class-integratepalacep-customize-sections.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/class-integratepalacep-customizer-sanitizes.php';
        require INTEGRATE_PALACE_P_PLUGIN_DIR . 'includes/customizer/extend-custom-controls/class-integratepalacep-extend-custom-controls.php';

    }


    function add_customize_panel( $wp_customize, $config ) {
        unset( $config['type'] );
        $wp_customize->add_panel( new IntegratePalace_Properties_Property_Panel( $wp_customize, $config['name'], $config ) );
    }
    
    function add_customize_section( $wp_customize, $config ) {
        unset( $config['type'] );
        $wp_customize->add_section( new IntegratePalace_Properties_Property_Customize_Section( $wp_customize, $config['name'], $config ) );
    }
    
    function add_customize_setting( $wp_customize, $config ) {
        unset( $config['type'] );
        $config['type'] = 'option';

        $wp_customize->add_setting( $config['name'], $config );
    }
    
    function add_customize_control( $wp_customize, $config ) {
        $control = $config['control'] ?? 'WP_Customize_Control';
        if ( class_exists( $control ) ) {
            $wp_customize->add_control( new $control( $wp_customize, $config['name'], $config ) );
        }
    }


    function ippr_get_customizer_settings( $template ) {
        // Fetch stored defaults from the database.
        $defaults = get_option( IPPR_SETTINGS . '[ippr_customizer_defaults]', array() );
    
        // Fetch current settings from the Customizer or database.
        $settings = get_option( 'ipp_settings', array() );
    
        // Ensure the requested template exists.
        if ( isset( $defaults[ $template ] ) ) {
            // Merge defaults with saved settings (saved settings override defaults).
            return wp_parse_args( isset( $settings[ $template ] ) ? $settings[ $template ] : array(), $defaults[ $template ] );
        }
    
        // Return empty array if template not found.
        return array();
    }
    

    // Filter and return Customizer Configurations.
 
    private function get_ippr_customizer_configurations() {

        global  $wp_customize;

        $configuration = apply_filters( 'ippr_customizer_configurations', array(), $wp_customize );

        return $configuration;
    }


    // Return default values for the Customize Configurations.
    private function get_ippr_customizer_configuration_defaults() {
        return apply_filters(
            'ippr_customizer_configuration_defaults',
            array(
                'priority'             => null,
                'title'                => null,
                'label'                => null,
                'name'                 => null,
                'type'                 => null,
                'description'          => null,
                'capability'           => null,
                'datastore_type'       => 'option', // theme_mod or option. Default option.
                'settings'             => null,
                'active_callback'      => null,
                'sanitize_callback'    => null,
                'sanitize_js_callback' => null,
                'theme_supports'       => null,
                'transport'            => null,
                'default'              => null,
                'selector'             => null,
            )
        );
    }

    public function ippr_font_families() {
        return array(
            'Initial', 
            'Euclid Circular B',
            'Roboto', 
            'Helvetica', 
            'Georgia', 
            'Times New Roman' 
        );
    }

    public function ippr_font_weight() {
        return array(
            '400', 
            '500',
            '600', 
            '700', 
            '800', 
            '900' 
        );
    }

    public function ippr_font_size_unit() {
        return array(
            'px', 
            'em',
            'rem', 
            '%', 
        );
    }


    // Enqueue our scripts and styles
    function ippr_customizer_scripts() {

        $js_prefix  = SCRIPT_DEBUG ? '.js' : '.min.js';
        $css_prefix = SCRIPT_DEBUG ? '.css' : '.min.css';
        $dir        = SCRIPT_DEBUG ? 'unminified' : 'minified';

        wp_enqueue_script('ippr-extend-customizer', INTEGRATE_PALACE_P_PLUGIN_URI . 'includes/customizer/assets/js/' . $dir . '/integratepalacep-extend-customizer' . $js_prefix, array( 'jquery', 'customize-preview', 'wp-color-picker' , 'customize-controls' ), false, false );
        wp_enqueue_script('color-picker-alpha', INTEGRATE_PALACE_P_PLUGIN_URI . 'includes/customizer/assets/js/' . $dir . '/wp-color-picker-alpha' . $js_prefix, array( 'jquery', 'customize-preview', 'wp-color-picker' , 'customize-controls' ), false, false );
        wp_enqueue_script('ippr-customizer-scripts', INTEGRATE_PALACE_P_PLUGIN_URI . 'includes/customizer/assets/js/' . $dir . '/integratepalacep-customizer' . $js_prefix, array( 'jquery', 'customize-preview', 'wp-color-picker' , 'customize-controls' ), $this->version, false );
        
        wp_localize_script('ippr-customizer-scripts', 'url_params', array(
            'siteUrl' => get_site_url(),
            'IPPR_SETTINGS' => IPPR_SETTINGS,
        ));
    }

    function ippr_customizer_styles() {
        wp_enqueue_style('ippr-customizer-style', INTEGRATE_PALACE_P_PLUGIN_URI . 'includes/customizer/assets/css/integratepalacep-customizer.css', array(), $this->version, 'all' );
    }
      
}


