<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties_Activator {
    public static function activate() {
        try {
            if (!get_option('integrate_palace-palace-unique-id')) {
                $unique_key = wp_generate_uuid4();
                update_option('integrate_palace-palace-unique-id', $unique_key);
            }
            if (!get_option('integrate_palace_properties_slug')) {
                update_option('integrate_palace_properties_slug', "palace-property");
                flush_rewrite_rules();
            }
        } catch (Exception $e) {
            if (defined('WP_DEBUG') && WP_DEBUG) {
                error_log('Plugin activation error: ' . $e->getMessage());
            }
            wp_die('There was an error activating the plugin. Please check the error log if WP_DEBUG is enabled.');
        }
    }
}
