<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class IntegratePalace_Properties_Admin {
    private $plugin_name;
    private $version;

    public function __construct( $plugin_name, $version ) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    public function enqueue_styles() {
         wp_enqueue_style( 'integrate_palace-color-picker' );
         wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'assets/css/ipp-admin.css', array(), $this->version, 'all' );
    }

    public function enqueue_scripts() {
        wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'assets/js/ipp-admin.js', array( 'jquery' , 'integrate_palace-color-picker' , 'media-views' ), $this->version, false );
    }

    public function integrate_palace_update_gallery($post_id, $property_code) {
        if (!$post_id || !$property_code) {
            error_log('Missing post_id or property_code.');
            return;
        }
    
        $username = get_option('integrate_palace_properties_username');
        $password = get_option('integrate_palace_properties_password');
    
        if (!$username || !$password) {
            error_log('Missing API credentials.');
            return;
        }
    
        $api_url = "https://api.getpalace.com/Service.svc/RestService/v2AvailablePropertyImages/JSON/$property_code";
        $headers = array(
            'Authorization' => 'Basic ' . base64_encode("$username:$password")
        );
    
        $response = wp_remote_get($api_url, array('headers' => $headers,'timeout' => 60));
        if (is_wp_error($response)) {
            error_log('Error fetching API: ' . $response->get_error_message());
            if (!wp_next_scheduled('integrate_palace_update_gallery', array($post_id, $property_code))) {
                wp_schedule_single_event(time() + 600, 'integrate_palace_update_gallery', array($post_id, $property_code));
            }
            return;
        }
    
        $body = wp_remote_retrieve_body($response);
        $images = json_decode($body, true);
        if (empty($images)) {
            error_log('No images found in API response. : '. $api_url);
            return;
        }
    
        $gallery = get_field('gallery', $post_id) ?: [];
        if (!is_array($gallery)) {
            error_log('Gallery field is not an array.');
            return;
        }
        
        $existing_images = array_column($gallery, 'ID', 'url');
        $new_gallery = [];
    
        if(!function_exists('pp_get_image_extension')){
            function pp_get_image_extension($base64_string) {
                $img_info = getimagesizefromstring(base64_decode($base64_string));
                return $img_info ? image_type_to_extension($img_info[2], false) : 'jpg';
            }
        }
        
    
        foreach ($images as $image) {
            $image_code = sanitize_file_name($image['PropertyImageCode']);
            $file_extension = pp_get_image_extension($image['PropertyImageBase64']);
            $filename = "$image_code.$file_extension";
            $image_data = base64_decode($image['PropertyImageBase64']);
    
            if (isset($existing_images[$filename])) {
                $new_gallery[] = $existing_images[$filename];
                unset($existing_images[$filename]);
            } else {
                $upload = wp_upload_bits($filename, null, $image_data);
                if (!$upload['error']) {
                    $attachment_id = wp_insert_attachment([
                        'post_mime_type' => wp_check_filetype($filename)['type'],
                        'post_title' => $image_code,
                        'post_status' => 'inherit'
                    ], $upload['file']);
                    if (!is_wp_error($attachment_id)) {
                        wp_update_attachment_metadata($attachment_id, wp_generate_attachment_metadata($attachment_id, $upload['file']));
                        $new_gallery[] = $attachment_id;
                    } else {
                        error_log("Error inserting attachment: " . $attachment_id->get_error_message());
                    }
                } else {
                    error_log("Upload error for $filename: " . $upload['error']);
                }
            }
        }
        if(count($new_gallery)){
            set_post_thumbnail($post_id, $new_gallery[0]);
        }
    
        update_field('gallery', array_map(fn($id) => ['ID' => $id, 'url' => wp_get_attachment_url($id)], $new_gallery), $post_id);
    
        array_walk($existing_images, fn($id) => wp_delete_attachment($id, true));
    }

    public function integrate_palace_properties_plugin_row_meta($links, $file){
        if (strpos($file, 'integrate-palace-properties') !== false) {
            $new_links = array(
                '<a target="__blank" href="https://wp-palace.kiwibrain.co.nz/register"><b>Go Pro</b></a>',
                '<a href="mailto:itsisaf@gmail.com">Support</a>',
                '<a target="__blank" href="https://wp-palace.kiwibrain.co.nz">View details</a>'
            );
            $links = array_merge($links, $new_links);
        }
        return $links;
    }
}
