(function() {
// src/index.jsx
const { registerPlugin } = wp.plugins;
const { PluginSidebar, PluginSidebarMoreMenuItem } = wp.editPost;
const { PanelBody, TextControl, TextareaControl, ToggleControl, ExternalLink, Notice, Button, TabPanel } = wp.components;
const { useSelect, useDispatch } = wp.data;
const { useState, useEffect } = wp.element;
const { __ } = wp.i18n;
var CharacterCounter = ({ current, max, optimal }) => {
  const percentage = current / max * 100;
  let status = "good";
  if (current === 0) {
    status = "empty";
  } else if (current > max) {
    status = "too-long";
  } else if (current < optimal) {
    status = "short";
  }
  return /* @__PURE__ */ wp.element.createElement("div", { className: `instarank-char-counter status-${status}` }, /* @__PURE__ */ wp.element.createElement("span", { className: "count" }, current, " / ", max), /* @__PURE__ */ wp.element.createElement("div", { className: "bar" }, /* @__PURE__ */ wp.element.createElement("div", { className: "fill", style: { width: `${Math.min(percentage, 100)}%` } })), status === "too-long" && /* @__PURE__ */ wp.element.createElement("span", { className: "warning" }, __("Too long - will be truncated", "instarank")), status === "short" && /* @__PURE__ */ wp.element.createElement("span", { className: "hint" }, __(`Optimal: ${optimal} characters`, "instarank")));
};
var SerpPreview = ({ title, description, url }) => {
  const displayTitle = title || __("Post Title", "instarank");
  const displayUrl = url || "https://example.com/post-url";
  const displayDescription = description || __("Meta description will appear here...", "instarank");
  return /* @__PURE__ */ wp.element.createElement("div", { className: "instarank-serp-preview" }, /* @__PURE__ */ wp.element.createElement("div", { className: "serp-container" }, /* @__PURE__ */ wp.element.createElement("div", { className: "serp-url" }, displayUrl), /* @__PURE__ */ wp.element.createElement("div", { className: "serp-title" }, displayTitle), /* @__PURE__ */ wp.element.createElement("div", { className: "serp-description" }, displayDescription)));
};
var FocusKeywordAnalysis = ({ keyword, title, description, content, url }) => {
  if (!keyword) {
    return null;
  }
  const checks = {
    inTitle: title.toLowerCase().includes(keyword.toLowerCase()),
    inDescription: description.toLowerCase().includes(keyword.toLowerCase()),
    inUrl: url.toLowerCase().includes(keyword.toLowerCase()),
    inContent: content.toLowerCase().includes(keyword.toLowerCase())
  };
  const score = Object.values(checks).filter(Boolean).length;
  const percentage = score / 4 * 100;
  return /* @__PURE__ */ wp.element.createElement("div", { className: "instarank-keyword-analysis" }, /* @__PURE__ */ wp.element.createElement("div", { className: `score-badge score-${Math.round(percentage / 25)}` }, score, "/4"), /* @__PURE__ */ wp.element.createElement("ul", { className: "checks-list" }, /* @__PURE__ */ wp.element.createElement("li", { className: checks.inTitle ? "check-pass" : "check-fail" }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-yes-alt" }), __("Keyword in title", "instarank")), /* @__PURE__ */ wp.element.createElement("li", { className: checks.inDescription ? "check-pass" : "check-fail" }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-yes-alt" }), __("Keyword in description", "instarank")), /* @__PURE__ */ wp.element.createElement("li", { className: checks.inUrl ? "check-pass" : "check-fail" }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-yes-alt" }), __("Keyword in URL", "instarank")), /* @__PURE__ */ wp.element.createElement("li", { className: checks.inContent ? "check-pass" : "check-fail" }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-yes-alt" }), __("Keyword in content", "instarank"))));
};
var PseoFieldsPanel = ({ pseoData, onFieldChange }) => {
  const [expanded, setExpanded] = useState(false);
  const [searchTerm, setSearchTerm] = useState("");
  const [editedFields, setEditedFields] = useState({});
  const [hasChanges, setHasChanges] = useState(false);
  const [imageLoadErrors, setImageLoadErrors] = useState({});
  if (!pseoData?.isPseoPage || !pseoData?.fields || Object.keys(pseoData.fields).length === 0) {
    return null;
  }
  const fields = pseoData.fields;
  const fieldCount = Object.keys(fields).length;
  const currentFields = { ...fields, ...editedFields };
  const filteredFields = Object.entries(currentFields).filter(([key, value]) => {
    if (key.startsWith("_")) return false;
    if (!searchTerm) return true;
    const searchLower = searchTerm.toLowerCase();
    return key.toLowerCase().includes(searchLower) || value && String(value).toLowerCase().includes(searchLower);
  });
  const isImageFieldName = (fieldKey) => {
    const imagePatterns = ["image", "img", "photo", "picture", "thumbnail", "avatar", "logo", "icon", "banner", "hero"];
    const fieldLower = fieldKey.toLowerCase();
    return imagePatterns.some((pattern) => fieldLower.includes(pattern));
  };
  const isImageUrl = (url) => {
    if (!url || typeof url !== "string") return false;
    const imageExtensions = ["jpg", "jpeg", "png", "gif", "webp", "svg", "bmp", "ico"];
    const urlLower = url.toLowerCase();
    if (imageExtensions.some((ext) => urlLower.endsWith("." + ext))) return true;
    const imageCdnPatterns = ["unsplash.com", "pexels.com", "pixabay.com", "cloudinary.com", "imgix.net", "wp-content/uploads"];
    return imageCdnPatterns.some((pattern) => urlLower.includes(pattern));
  };
  const categorizeField = (key, value) => {
    if (!value) return "text";
    const strValue = String(value);
    if (isImageFieldName(key) || isImageUrl(strValue)) return "image";
    if (strValue.startsWith("http://") || strValue.startsWith("https://")) return "url";
    if (/<[^>]+>/.test(strValue)) return "html";
    return "text";
  };
  const formatFieldName = (name) => {
    return name.replace(/[-_]/g, " ").replace(/([a-z])([A-Z])/g, "$1 $2").split(" ").map((word) => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(" ");
  };
  const handleFieldChange = (key, newValue) => {
    const updatedFields = { ...editedFields, [key]: newValue };
    setEditedFields(updatedFields);
    setHasChanges(true);
    if (onFieldChange) {
      onFieldChange(key, newValue);
    }
  };
  const imageFields = filteredFields.filter(([key, value]) => categorizeField(key, value) === "image");
  const textFields = filteredFields.filter(([key, value]) => categorizeField(key, value) === "text");
  const urlFields = filteredFields.filter(([key, value]) => categorizeField(key, value) === "url");
  const htmlFields = filteredFields.filter(([key, value]) => categorizeField(key, value) === "html");
  const openMediaLibrary = (fieldKey) => {
    if (typeof wp !== "undefined" && wp.media) {
      const mediaFrame = wp.media({
        title: __("Select or Upload Image", "instarank"),
        button: { text: __("Use this image", "instarank") },
        multiple: false,
        library: { type: "image" }
      });
      mediaFrame.on("select", () => {
        const attachment = mediaFrame.state().get("selection").first().toJSON();
        handleFieldChange(fieldKey, attachment.url);
        setImageLoadErrors((prev) => ({ ...prev, [fieldKey]: false }));
      });
      mediaFrame.open();
    }
  };
  const handleImageError = (key) => {
    setImageLoadErrors((prev) => ({ ...prev, [key]: true }));
  };
  const renderFieldInput = (key, value, type) => {
    const isLong = String(value || "").length > 80;
    if (type === "image") {
      const hasImage = value && value.startsWith("http");
      const hasError = imageLoadErrors[key];
      return /* @__PURE__ */ wp.element.createElement("div", null, /* @__PURE__ */ wp.element.createElement("div", { style: { marginBottom: "8px" } }, hasImage && !hasError ? /* @__PURE__ */ wp.element.createElement("div", { style: { position: "relative", display: "inline-block" } }, /* @__PURE__ */ wp.element.createElement(
        "img",
        {
          src: value,
          alt: formatFieldName(key),
          style: {
            maxWidth: "100%",
            maxHeight: "120px",
            borderRadius: "4px",
            border: "1px solid #e2e4e7",
            display: "block"
          },
          onError: () => handleImageError(key)
        }
      )) : hasError ? /* @__PURE__ */ wp.element.createElement("div", { style: {
        width: "100%",
        height: "80px",
        background: "#fef2f2",
        border: "1px solid #fecaca",
        borderRadius: "4px",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        color: "#dc2626",
        fontSize: "11px"
      } }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-warning", style: { marginRight: "4px", fontSize: "14px" } }), __("Image failed to load", "instarank")) : /* @__PURE__ */ wp.element.createElement("div", { style: {
        width: "100%",
        height: "80px",
        background: "#f9fafb",
        border: "2px dashed #d1d5db",
        borderRadius: "4px",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        color: "#9ca3af",
        fontSize: "11px"
      } }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-format-image", style: { fontSize: "20px", marginRight: "6px" } }), __("No image set", "instarank"))), /* @__PURE__ */ wp.element.createElement("div", { style: { display: "flex", gap: "6px", alignItems: "stretch" } }, /* @__PURE__ */ wp.element.createElement(
        "input",
        {
          type: "url",
          value: value || "",
          onChange: (e) => {
            handleFieldChange(key, e.target.value);
            setImageLoadErrors((prev) => ({ ...prev, [key]: false }));
          },
          placeholder: __("Enter image URL...", "instarank"),
          style: {
            flex: 1,
            padding: "6px 8px",
            border: "1px solid #d1d5db",
            borderRadius: "4px",
            fontSize: "11px"
          }
        }
      ), /* @__PURE__ */ wp.element.createElement(
        Button,
        {
          isSecondary: true,
          onClick: () => openMediaLibrary(key),
          style: { padding: "0 8px", height: "30px" }
        },
        /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-upload", style: { fontSize: "14px" } })
      ), hasImage && /* @__PURE__ */ wp.element.createElement(
        Button,
        {
          isDestructive: true,
          onClick: () => handleFieldChange(key, ""),
          style: { padding: "0 8px", height: "30px" }
        },
        /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-no-alt", style: { fontSize: "14px" } })
      )), hasImage && !hasError && /* @__PURE__ */ wp.element.createElement("div", { style: { marginTop: "4px" } }, /* @__PURE__ */ wp.element.createElement(
        "a",
        {
          href: value,
          target: "_blank",
          rel: "noopener noreferrer",
          style: { fontSize: "10px", color: "#6b7280", textDecoration: "none" }
        },
        /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-external", style: { fontSize: "10px", verticalAlign: "middle" } }),
        " ",
        __("View full size", "instarank")
      )));
    }
    if (type === "url") {
      return /* @__PURE__ */ wp.element.createElement("div", { style: { display: "flex", alignItems: "center", gap: "8px" } }, /* @__PURE__ */ wp.element.createElement(
        "input",
        {
          type: "url",
          value: value || "",
          onChange: (e) => handleFieldChange(key, e.target.value),
          style: {
            flex: 1,
            padding: "6px 10px",
            border: "1px solid #d1d5db",
            borderRadius: "4px",
            fontSize: "12px"
          }
        }
      ), value && /* @__PURE__ */ wp.element.createElement(
        "a",
        {
          href: value,
          target: "_blank",
          rel: "noopener noreferrer",
          style: { color: "#2271b1" }
        },
        /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-external", style: { fontSize: "14px" } })
      ));
    }
    if (type === "html" || isLong) {
      return /* @__PURE__ */ wp.element.createElement(
        "textarea",
        {
          value: value || "",
          onChange: (e) => handleFieldChange(key, e.target.value),
          rows: type === "html" ? 4 : 2,
          style: {
            width: "100%",
            padding: "6px 10px",
            border: "1px solid #d1d5db",
            borderRadius: "4px",
            fontSize: type === "html" ? "11px" : "12px",
            fontFamily: type === "html" ? "monospace" : "inherit",
            resize: "vertical"
          }
        }
      );
    }
    return /* @__PURE__ */ wp.element.createElement(
      "input",
      {
        type: "text",
        value: value || "",
        onChange: (e) => handleFieldChange(key, e.target.value),
        style: {
          width: "100%",
          padding: "6px 10px",
          border: "1px solid #d1d5db",
          borderRadius: "4px",
          fontSize: "12px"
        }
      }
    );
  };
  const renderFieldSection = (sectionFields, title, type) => {
    if (sectionFields.length === 0) return null;
    return /* @__PURE__ */ wp.element.createElement("div", { style: { marginBottom: "16px" } }, /* @__PURE__ */ wp.element.createElement("h4", { style: {
      margin: "0 0 8px 0",
      fontSize: "11px",
      textTransform: "uppercase",
      color: "#6b7280",
      borderBottom: "1px solid #e5e7eb",
      paddingBottom: "4px",
      display: "flex",
      alignItems: "center",
      gap: "4px"
    } }, type === "image" && /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-format-image", style: { fontSize: "12px", color: "#f97316" } }), title), sectionFields.map(([key, value]) => /* @__PURE__ */ wp.element.createElement("div", { key, style: {
      marginBottom: "10px",
      background: "white",
      padding: "8px 10px",
      borderRadius: "4px",
      border: "1px solid #e2e4e7"
    } }, /* @__PURE__ */ wp.element.createElement("label", { style: {
      display: "block",
      fontWeight: "600",
      color: "#2271b1",
      fontSize: "11px",
      marginBottom: "4px"
    } }, formatFieldName(key), type === "html" && /* @__PURE__ */ wp.element.createElement("span", { style: { fontWeight: "normal", color: "#9ca3af", marginLeft: "6px" } }, "(HTML)")), renderFieldInput(key, value, type))));
  };
  return /* @__PURE__ */ wp.element.createElement(
    PanelBody,
    {
      title: /* @__PURE__ */ wp.element.createElement("span", { style: { display: "flex", alignItems: "center", gap: "8px" } }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-database", style: { color: "#f97316", fontSize: "16px" } }), __("Dataset Fields", "instarank"), /* @__PURE__ */ wp.element.createElement("span", { style: {
        background: "#f97316",
        color: "white",
        borderRadius: "10px",
        padding: "2px 8px",
        fontSize: "11px",
        fontWeight: "600"
      } }, fieldCount), hasChanges && /* @__PURE__ */ wp.element.createElement("span", { style: {
        background: "#059669",
        color: "white",
        borderRadius: "10px",
        padding: "2px 6px",
        fontSize: "10px",
        fontWeight: "600"
      } }, __("Modified", "instarank"))),
      initialOpen: true
    },
    /* @__PURE__ */ wp.element.createElement("div", { style: {
      marginBottom: "12px",
      padding: "10px",
      background: "linear-gradient(135deg, #fef7ed 0%, #fff7ed 100%)",
      borderRadius: "6px",
      fontSize: "12px",
      border: "1px solid #fed7aa"
    } }, /* @__PURE__ */ wp.element.createElement("div", { style: { display: "flex", alignItems: "center", gap: "6px", marginBottom: "4px" } }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-edit", style: { color: "#f97316", fontSize: "14px" } }), /* @__PURE__ */ wp.element.createElement("strong", { style: { color: "#92400e" } }, __("Editable Fields", "instarank"))), /* @__PURE__ */ wp.element.createElement("p", { style: { margin: "0", color: "#78350f", fontSize: "11px" } }, __("Edit field values below. Changes will update the page content when you save the post.", "instarank")), pseoData.generatedAt && /* @__PURE__ */ wp.element.createElement("div", { style: { marginTop: "6px", color: "#92400e", fontSize: "10px" } }, __("Generated:", "instarank"), " ", pseoData.generatedAt)),
    fieldCount > 5 && /* @__PURE__ */ wp.element.createElement(
      TextControl,
      {
        placeholder: __("Search fields...", "instarank"),
        value: searchTerm,
        onChange: setSearchTerm,
        style: { marginBottom: "12px" }
      }
    ),
    /* @__PURE__ */ wp.element.createElement("div", { style: {
      maxHeight: expanded ? "none" : "400px",
      overflow: expanded ? "visible" : "auto"
    } }, renderFieldSection(imageFields, __("Image Fields", "instarank"), "image"), renderFieldSection(textFields, __("Text Fields", "instarank"), "text"), renderFieldSection(urlFields, __("URL Fields", "instarank"), "url"), renderFieldSection(htmlFields, __("HTML Content", "instarank"), "html")),
    fieldCount > 8 && /* @__PURE__ */ wp.element.createElement(
      Button,
      {
        isLink: true,
        onClick: () => setExpanded(!expanded),
        style: { marginTop: "8px", fontSize: "12px" }
      },
      expanded ? __("Show less", "instarank") : __("Show all fields", "instarank")
    ),
    searchTerm && filteredFields.length === 0 && /* @__PURE__ */ wp.element.createElement("p", { style: { textAlign: "center", color: "#757575", padding: "20px", margin: 0 } }, __("No fields match your search", "instarank")),
    /* @__PURE__ */ wp.element.createElement("div", { style: {
      marginTop: "12px",
      paddingTop: "10px",
      borderTop: "1px solid #e5e7eb",
      display: "flex",
      justifyContent: "space-between",
      alignItems: "center",
      fontSize: "11px"
    } }, /* @__PURE__ */ wp.element.createElement("span", { style: { color: "#6b7280" } }, fieldCount, " ", __("fields from dataset", "instarank")), /* @__PURE__ */ wp.element.createElement("span", { style: { color: "#059669", fontWeight: "500" } }, /* @__PURE__ */ wp.element.createElement("span", { className: "dashicons dashicons-saved", style: { fontSize: "12px", verticalAlign: "middle", marginRight: "4px" } }), __("Auto-saved with post", "instarank")))
  );
};
var InstaRankPanel = () => {
  const { postId, postType, nonce, ajaxUrl, connected, projectId, metaData, pseoData, pendingChanges, limits } = window.instarankGutenberg;
  const [pseoFieldChanges, setPseoFieldChanges] = useState({});
  const [wasSaving, setWasSaving] = useState(false);
  const { postTitle, postContent, postSlug, isSaving, isAutosaving } = useSelect((select) => ({
    postTitle: select("core/editor").getEditedPostAttribute("title"),
    postContent: select("core/editor").getEditedPostContent(),
    postSlug: select("core/editor").getEditedPostAttribute("slug"),
    isSaving: select("core/editor").isSavingPost(),
    isAutosaving: select("core/editor").isAutosavingPost()
  }));
  const { editPost } = useDispatch("core/editor");
  const handlePseoFieldChange = (key, value) => {
    setPseoFieldChanges((prev) => ({ ...prev, [key]: value }));
  };
  useEffect(() => {
    if (wasSaving && !isSaving && !isAutosaving && Object.keys(pseoFieldChanges).length > 0) {
      const formData = new FormData();
      formData.append("action", "instarank_save_pseo_fields");
      formData.append("nonce", nonce);
      formData.append("post_id", postId);
      formData.append("fields", JSON.stringify(pseoFieldChanges));
      fetch(ajaxUrl, {
        method: "POST",
        body: formData
      }).then((response) => response.json()).then((data) => {
        if (data.success) {
          console.log("InstaRank: pSEO fields saved successfully");
          setPseoFieldChanges({});
        } else {
          console.error("InstaRank: Failed to save pSEO fields", data);
        }
      }).catch((error) => {
        console.error("InstaRank: Error saving pSEO fields", error);
      });
    }
    setWasSaving(isSaving && !isAutosaving);
  }, [isSaving, isAutosaving]);
  const [metaTitle, setMetaTitle] = useState(metaData.metaTitle || "");
  const [metaDescription, setMetaDescription] = useState(metaData.metaDescription || "");
  const [focusKeyword, setFocusKeyword] = useState(metaData.focusKeyword || "");
  const [canonical, setCanonical] = useState(metaData.canonical || "");
  const [robotsNoindex, setRobotsNoindex] = useState(metaData.robotsNoindex === "1");
  const [ogTitle, setOgTitle] = useState(metaData.ogTitle || "");
  const [ogDescription, setOgDescription] = useState(metaData.ogDescription || "");
  const [ogImage, setOgImage] = useState(metaData.ogImage || "");
  const [twitterTitle, setTwitterTitle] = useState(metaData.twitterTitle || "");
  const [twitterDescription, setTwitterDescription] = useState(metaData.twitterDescription || "");
  const [twitterImage, setTwitterImage] = useState(metaData.twitterImage || "");
  const saveMeta = (key, value) => {
    editPost({ meta: { [key]: value } });
  };
  const displayTitle = metaTitle || postTitle;
  const displayDescription = metaDescription || __("No description set", "instarank");
  const siteUrl = window.location.origin;
  const displayUrl = `${siteUrl}/${postSlug || "post-url"}`;
  return /* @__PURE__ */ wp.element.createElement(React.Fragment, null, !connected && /* @__PURE__ */ wp.element.createElement(Notice, { status: "warning", isDismissible: false }, /* @__PURE__ */ wp.element.createElement("p", null, __("Not connected to InstaRank.", "instarank")), /* @__PURE__ */ wp.element.createElement(
    Button,
    {
      isSecondary: true,
      href: "/wp-admin/admin.php?page=instarank",
      target: "_blank"
    },
    __("Connect Now", "instarank")
  )), pendingChanges > 0 && /* @__PURE__ */ wp.element.createElement(Notice, { status: "info", isDismissible: false }, /* @__PURE__ */ wp.element.createElement("p", null, pendingChanges === 1 ? __("1 pending change from InstaRank", "instarank") : __(`${pendingChanges} pending changes from InstaRank`, "instarank")), /* @__PURE__ */ wp.element.createElement(
    Button,
    {
      isPrimary: true,
      href: "/wp-admin/admin.php?page=instarank-changes",
      target: "_blank"
    },
    __("Review Changes", "instarank")
  )), /* @__PURE__ */ wp.element.createElement(PseoFieldsPanel, { pseoData, onFieldChange: handlePseoFieldChange }), /* @__PURE__ */ wp.element.createElement(PanelBody, { title: __("Google Preview", "instarank"), initialOpen: true }, /* @__PURE__ */ wp.element.createElement(
    SerpPreview,
    {
      title: displayTitle,
      description: displayDescription,
      url: displayUrl
    }
  )), /* @__PURE__ */ wp.element.createElement(
    TabPanel,
    {
      className: "instarank-tabs",
      activeClass: "is-active",
      tabs: [
        {
          name: "general",
          title: __("General", "instarank")
        },
        {
          name: "social",
          title: __("Social", "instarank")
        },
        {
          name: "advanced",
          title: __("Advanced", "instarank")
        }
      ]
    },
    (tab) => /* @__PURE__ */ wp.element.createElement(React.Fragment, null, tab.name === "general" && /* @__PURE__ */ wp.element.createElement(React.Fragment, null, /* @__PURE__ */ wp.element.createElement(PanelBody, { title: __("SEO Title", "instarank"), initialOpen: true }, /* @__PURE__ */ wp.element.createElement(
      TextControl,
      {
        label: __("Meta Title", "instarank"),
        value: metaTitle,
        onChange: (value) => {
          setMetaTitle(value);
          saveMeta("instarank_meta_title", value);
        },
        placeholder: postTitle || __("Enter SEO title...", "instarank"),
        help: __("If empty, post title will be used", "instarank")
      }
    ), /* @__PURE__ */ wp.element.createElement(
      CharacterCounter,
      {
        current: (metaTitle || postTitle).length,
        max: limits.titleMax,
        optimal: limits.titleOptimal
      }
    )), /* @__PURE__ */ wp.element.createElement(PanelBody, { title: __("Meta Description", "instarank"), initialOpen: true }, /* @__PURE__ */ wp.element.createElement(
      TextareaControl,
      {
        label: __("Meta Description", "instarank"),
        value: metaDescription,
        onChange: (value) => {
          setMetaDescription(value);
          saveMeta("instarank_meta_description", value);
        },
        placeholder: __("Enter meta description...", "instarank"),
        rows: 3
      }
    ), /* @__PURE__ */ wp.element.createElement(
      CharacterCounter,
      {
        current: metaDescription.length,
        max: limits.descriptionMax,
        optimal: limits.descriptionOptimal
      }
    )), /* @__PURE__ */ wp.element.createElement(PanelBody, { title: __("Focus Keyword", "instarank"), initialOpen: false }, /* @__PURE__ */ wp.element.createElement(
      TextControl,
      {
        label: __("Focus Keyword", "instarank"),
        value: focusKeyword,
        onChange: (value) => {
          setFocusKeyword(value);
          saveMeta("instarank_focus_keyword", value);
        },
        placeholder: __("Enter target keyword...", "instarank"),
        help: __("The main keyword you want this content to rank for", "instarank")
      }
    ), /* @__PURE__ */ wp.element.createElement(
      FocusKeywordAnalysis,
      {
        keyword: focusKeyword,
        title: displayTitle,
        description: metaDescription,
        content: postContent,
        url: postSlug
      }
    ))), tab.name === "social" && /* @__PURE__ */ wp.element.createElement(React.Fragment, null, /* @__PURE__ */ wp.element.createElement(PanelBody, { title: __("Facebook / Open Graph", "instarank"), initialOpen: true }, /* @__PURE__ */ wp.element.createElement(
      TextControl,
      {
        label: __("OG Title", "instarank"),
        value: ogTitle,
        onChange: (value) => {
          setOgTitle(value);
          saveMeta("instarank_og_title", value);
        },
        placeholder: metaTitle || postTitle
      }
    ), /* @__PURE__ */ wp.element.createElement(
      TextareaControl,
      {
        label: __("OG Description", "instarank"),
        value: ogDescription,
        onChange: (value) => {
          setOgDescription(value);
          saveMeta("instarank_og_description", value);
        },
        placeholder: metaDescription,
        rows: 2
      }
    ), /* @__PURE__ */ wp.element.createElement(
      TextControl,
      {
        label: __("OG Image URL", "instarank"),
        value: ogImage,
        onChange: (value) => {
          setOgImage(value);
          saveMeta("instarank_og_image", value);
        },
        placeholder: __("https://example.com/image.jpg", "instarank")
      }
    )), /* @__PURE__ */ wp.element.createElement(PanelBody, { title: __("Twitter Card", "instarank"), initialOpen: false }, /* @__PURE__ */ wp.element.createElement(
      TextControl,
      {
        label: __("Twitter Title", "instarank"),
        value: twitterTitle,
        onChange: (value) => {
          setTwitterTitle(value);
          saveMeta("instarank_twitter_title", value);
        },
        placeholder: ogTitle || metaTitle || postTitle
      }
    ), /* @__PURE__ */ wp.element.createElement(
      TextareaControl,
      {
        label: __("Twitter Description", "instarank"),
        value: twitterDescription,
        onChange: (value) => {
          setTwitterDescription(value);
          saveMeta("instarank_twitter_description", value);
        },
        placeholder: ogDescription || metaDescription,
        rows: 2
      }
    ), /* @__PURE__ */ wp.element.createElement(
      TextControl,
      {
        label: __("Twitter Image URL", "instarank"),
        value: twitterImage,
        onChange: (value) => {
          setTwitterImage(value);
          saveMeta("instarank_twitter_image", value);
        },
        placeholder: ogImage
      }
    ))), tab.name === "advanced" && /* @__PURE__ */ wp.element.createElement(React.Fragment, null, /* @__PURE__ */ wp.element.createElement(PanelBody, { title: __("Canonical URL", "instarank"), initialOpen: true }, /* @__PURE__ */ wp.element.createElement(
      TextControl,
      {
        label: __("Canonical URL", "instarank"),
        value: canonical,
        onChange: (value) => {
          setCanonical(value);
          saveMeta("instarank_canonical", value);
        },
        placeholder: displayUrl,
        help: __("Leave empty to use default URL", "instarank")
      }
    )), /* @__PURE__ */ wp.element.createElement(PanelBody, { title: __("Robots Meta", "instarank"), initialOpen: false }, /* @__PURE__ */ wp.element.createElement(
      ToggleControl,
      {
        label: __("No Index", "instarank"),
        checked: robotsNoindex,
        onChange: (value) => {
          setRobotsNoindex(value);
          saveMeta("instarank_robots_noindex", value ? "1" : "0");
        },
        help: __("Prevent search engines from indexing this page", "instarank")
      }
    ))))
  ), /* @__PURE__ */ wp.element.createElement("div", { className: "instarank-panel-footer" }, /* @__PURE__ */ wp.element.createElement(ExternalLink, { href: "/wp-admin/admin.php?page=instarank-settings" }, __("Plugin Settings", "instarank")), connected && /* @__PURE__ */ wp.element.createElement(ExternalLink, { href: `${window.instarankGutenberg.apiUrl}/projects/${projectId}` }, __("Open InstaRank Dashboard", "instarank"))));
};
registerPlugin("instarank-seo", {
  render: () => /* @__PURE__ */ wp.element.createElement(React.Fragment, null, /* @__PURE__ */ wp.element.createElement(PluginSidebarMoreMenuItem, { target: "instarank-seo-sidebar" }, __("InstaRank SEO", "instarank")), /* @__PURE__ */ wp.element.createElement(
    PluginSidebar,
    {
      name: "instarank-seo-sidebar",
      title: __("InstaRank SEO", "instarank"),
      icon: "chart-line"
    },
    /* @__PURE__ */ wp.element.createElement(InstaRankPanel, null)
  ))
});

})();