<?php
/**
 * Admin Settings Page - Minimalist Tabbed No-Scroll Design
 * Total Height: 688px (fits 768p screens)
 */

defined('ABSPATH') || exit;

// Handle form submission
if (isset($_POST['instarank_save_settings'])) {
    check_admin_referer('instarank_settings');

    // Project slug for SaaS integration
    $instarank_project_slug = isset($_POST['project_slug']) ? sanitize_title(wp_unslash($_POST['project_slug'])) : '';
    update_option('instarank_project_slug', $instarank_project_slug);

    // Auto-approve changes
    $instarank_auto_approve = isset($_POST['auto_approve']) ? true : false;
    update_option('instarank_auto_approve', $instarank_auto_approve);

    // Allowed change types
    $instarank_allowed_types = isset($_POST['allowed_change_types']) && is_array($_POST['allowed_change_types'])
        ? array_map('sanitize_text_field', wp_unslash($_POST['allowed_change_types']))
        : [];
    update_option('instarank_allowed_change_types', $instarank_allowed_types);

    // Webhook settings
    $instarank_webhook_enabled = isset($_POST['webhook_enabled']) ? true : false;
    update_option('instarank_webhook_enabled', $instarank_webhook_enabled);

    $instarank_webhook_url = isset($_POST['webhook_url']) ? sanitize_url(wp_unslash($_POST['webhook_url'])) : '';
    update_option('instarank_webhook_url', $instarank_webhook_url);

    // Rollback retention
    $instarank_rollback_days = intval($_POST['rollback_days'] ?? 90);
    update_option('instarank_rollback_days', $instarank_rollback_days);

    // Note: Robots.txt, Sitemap, and LLMs.txt settings are now managed from the SaaS dashboard

    // Breadcrumbs settings
    $instarank_breadcrumb_separator = isset($_POST['breadcrumb_separator']) ? sanitize_text_field(wp_unslash($_POST['breadcrumb_separator'])) : '›';
    update_option('instarank_breadcrumb_separator', $instarank_breadcrumb_separator);

    $instarank_breadcrumb_home_text = isset($_POST['breadcrumb_home_text']) ? sanitize_text_field(wp_unslash($_POST['breadcrumb_home_text'])) : 'Home';
    update_option('instarank_breadcrumb_home_text', $instarank_breadcrumb_home_text);

    $instarank_breadcrumb_show_home = isset($_POST['breadcrumb_show_home']) ? true : false;
    update_option('instarank_breadcrumb_show_home', $instarank_breadcrumb_show_home);

    $instarank_breadcrumb_show_current = isset($_POST['breadcrumb_show_current']) ? true : false;
    update_option('instarank_breadcrumb_show_current', $instarank_breadcrumb_show_current);

    $instarank_breadcrumb_schema_enabled = isset($_POST['breadcrumb_schema_enabled']) ? true : false;
    update_option('instarank_breadcrumb_schema_enabled', $instarank_breadcrumb_schema_enabled);

    // Schema settings
    $instarank_schema_search_action = isset($_POST['schema_search_action']) ? true : false;
    update_option('instarank_schema_search_action', $instarank_schema_search_action);

    $instarank_schema_auto_generate = isset($_POST['schema_auto_generate']) ? true : false;
    update_option('instarank_schema_auto_generate', $instarank_schema_auto_generate);

    // Send webhook notification
    $instarank_webhook = new InstaRank_Webhook_Sender();
    $instarank_webhook->send_settings_updated([
        'auto_approve' => $instarank_auto_approve,
        'allowed_change_types' => $instarank_allowed_types
    ]);

    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Settings saved successfully.', 'instarank') . '</p></div>';
}

// Get current settings
$instarank_api_key = get_option('instarank_api_key', '');
$instarank_project_slug = get_option('instarank_project_slug', '');
$instarank_auto_approve = get_option('instarank_auto_approve', false);
$instarank_allowed_types = get_option('instarank_allowed_change_types', ['meta_title', 'meta_description', 'image_alt']);
$instarank_webhook_enabled = get_option('instarank_webhook_enabled', true);
$instarank_webhook_url = get_option('instarank_webhook_url', '');
$instarank_rollback_days = get_option('instarank_rollback_days', 90);
// Note: Sitemap, Robots.txt, and LLMs.txt settings are now managed from the SaaS dashboard
$instarank_breadcrumb_separator = get_option('instarank_breadcrumb_separator', '›');
$instarank_breadcrumb_home_text = get_option('instarank_breadcrumb_home_text', 'Home');
$instarank_breadcrumb_show_home = get_option('instarank_breadcrumb_show_home', true);
$instarank_breadcrumb_show_current = get_option('instarank_breadcrumb_show_current', true);
$instarank_breadcrumb_schema_enabled = get_option('instarank_breadcrumb_schema_enabled', true);
$instarank_schema_search_action = get_option('instarank_schema_search_action', true);
$instarank_schema_auto_generate = get_option('instarank_schema_auto_generate', true);

// Connection settings
$instarank_connected = get_option('instarank_connected', false);
$instarank_project_id = get_option('instarank_project_id', '');
$instarank_integration_id = get_option('instarank_integration_id', '');
$instarank_connected_at = get_option('instarank_connected_at', '');

$instarank_detector = new InstaRank_SEO_Detector();
$instarank_seo_plugin = $instarank_detector->get_active_seo_plugin();

?>

<div class="wrap instarank-settings-page">
    <h1><?php esc_html_e('InstaRank Settings', 'instarank'); ?></h1>

    <form method="post" action="">
        <?php wp_nonce_field('instarank_settings'); ?>

        <!-- Tab Navigation (48px) -->
        <nav class="ir-tabs">
            <button type="button" class="ir-tab ir-tab--active" data-tab="general">
                <?php esc_html_e('General', 'instarank'); ?>
            </button>
            <button type="button" class="ir-tab" data-tab="seo">
                <?php esc_html_e('SEO', 'instarank'); ?>
            </button>
            <button type="button" class="ir-tab" data-tab="advanced">
                <?php esc_html_e('Advanced', 'instarank'); ?>
            </button>
            <button type="button" class="ir-tab" data-tab="danger">
                <?php esc_html_e('Danger Zone', 'instarank'); ?>
            </button>
        </nav>

        <!-- Tab Content (520px fixed height) -->
        <div class="ir-tab-content">

            <!-- General Tab -->
            <div class="ir-tab-panel active" data-panel="general">
                <div class="ir-form-grid">
                    <!-- Connection Status -->
                    <?php if ($instarank_connected): ?>
                    <div class="ir-form-section" style="grid-column: 1 / -1; background: #d4edda; padding: 12px; border-radius: 6px; border: 1px solid #c3e6cb;">
                        <strong style="color: #155724;">✓ <?php esc_html_e('Connected to InstaRank', 'instarank'); ?></strong>
                        <?php if ($instarank_project_id): ?>
                            <span style="margin-left: 10px; color: #155724;">Project: <?php echo esc_html($instarank_project_id); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php else: ?>
                    <div class="ir-form-section" style="grid-column: 1 / -1; background: #f8d7da; padding: 12px; border-radius: 6px; border: 1px solid #f5c6cb;">
                        <strong style="color: #721c24;">⚠ <?php esc_html_e('Not Connected', 'instarank'); ?></strong>
                        <span style="margin-left: 10px; color: #721c24;"><?php esc_html_e('Use the API key below to connect from your InstaRank dashboard', 'instarank'); ?></span>
                    </div>
                    <?php endif; ?>

                    <!-- API Key Section -->
                    <div class="ir-form-section" style="grid-column: 1 / -1; background: #f8fafc; padding: 16px; border-radius: 6px; border: 1px solid #e2e8f0;">
                        <label class="ir-label" style="font-weight: 600; color: #1e293b; margin-bottom: 8px; display: block;">
                            <?php esc_html_e('API Key for Cloud Integration', 'instarank'); ?>
                        </label>
                        <div style="display: flex; align-items: center; gap: 12px;">
                            <input type="text"
                                   id="instarank-api-key-display"
                                   value="<?php echo esc_attr($instarank_api_key); ?>"
                                   readonly
                                   class="ir-input"
                                   style="flex: 1; font-family: monospace; font-size: 13px; background: #ffffff;">
                            <button type="button"
                                    class="ir-btn ir-btn--secondary ir-btn--sm"
                                    onclick="navigator.clipboard.writeText('<?php echo esc_js($instarank_api_key); ?>').then(() => { this.textContent = 'Copied!'; setTimeout(() => { this.textContent = 'Copy'; }, 2000); })">
                                <?php esc_html_e('Copy', 'instarank'); ?>
                            </button>
                        </div>
                        <p class="ir-help" style="margin-top: 8px;">
                            <?php esc_html_e('Use this API key to connect your WordPress site to InstaRank cloud services.', 'instarank'); ?>
                        </p>
                    </div>

                    <!-- Project Slug Section -->
                    <div class="ir-form-section" style="grid-column: 1 / -1; background: #f8fafc; padding: 16px; border-radius: 6px; border: 1px solid #e2e8f0;">
                        <label class="ir-label" style="font-weight: 600; color: #1e293b; margin-bottom: 8px; display: block;">
                            <?php esc_html_e('InstaRank Project Slug', 'instarank'); ?>
                        </label>
                        <input type="text"
                               name="project_slug"
                               value="<?php echo esc_attr($instarank_project_slug); ?>"
                               placeholder="<?php esc_attr_e('e.g., localhost or my-website', 'instarank'); ?>"
                               class="ir-input"
                               style="width: 100%; max-width: 400px; font-family: monospace; font-size: 13px;">
                        <p class="ir-help" style="margin-top: 8px;">
                            <?php esc_html_e('Enter your project slug from the InstaRank dashboard URL (e.g., for /projects/my-site/, enter "my-site").', 'instarank'); ?>
                            <br>
                            <strong><?php esc_html_e('This is required for the "Generate Pages" button to work correctly.', 'instarank'); ?></strong>
                        </p>
                    </div>

                    <div class="ir-form-section">
                        <label class="ir-label">
                            <input type="checkbox" name="auto_approve" value="1" <?php checked($instarank_auto_approve, true); ?>>
                            <?php esc_html_e('Auto-approve changes', 'instarank'); ?>
                        </label>
                        <p class="ir-help">
                            <?php esc_html_e('Automatically apply SEO changes from InstaRank without manual approval.', 'instarank'); ?>
                        </p>
                    </div>

                    <div class="ir-form-section">
                        <label class="ir-label">
                            <input type="checkbox" name="webhook_enabled" value="1" <?php checked($instarank_webhook_enabled, true); ?>>
                            <?php esc_html_e('Enable webhooks', 'instarank'); ?>
                        </label>
                        <p class="ir-help">
                            <?php esc_html_e('Send notifications to InstaRank when changes occur.', 'instarank'); ?>
                        </p>
                    </div>

                    <div class="ir-form-section">
                        <label class="ir-label" for="rollback_days">
                            <?php esc_html_e('Rollback Retention', 'instarank'); ?>
                        </label>
                        <input type="number"
                               id="rollback_days"
                               name="rollback_days"
                               value="<?php echo esc_attr($instarank_rollback_days); ?>"
                               min="1"
                               max="365"
                               class="ir-input-sm">
                        <p class="ir-help">
                            <?php esc_html_e('How long to keep change history for rollback purposes (days).', 'instarank'); ?>
                        </p>
                    </div>

                    <div class="ir-form-section">
                        <label class="ir-label" for="webhook_url">
                            <?php esc_html_e('Custom Webhook URL', 'instarank'); ?>
                        </label>
                        <input type="url"
                               id="webhook_url"
                               name="webhook_url"
                               value="<?php echo esc_url($instarank_webhook_url); ?>"
                               class="ir-input-sm"
                               placeholder="<?php echo esc_attr(INSTARANK_API_URL . '/webhooks/wordpress'); ?>">
                        <p class="ir-help">
                            <?php esc_html_e('Leave empty to use the default InstaRank webhook URL.', 'instarank'); ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- SEO Tab -->
            <div class="ir-tab-panel" data-panel="seo">
                <div class="ir-form-grid">
                    <div class="ir-form-section">
                        <label class="ir-label">
                            <?php esc_html_e('Allowed Change Types', 'instarank'); ?>
                        </label>
                        <fieldset style="border: 1px solid var(--ir-gray-200); padding: 12px; border-radius: 6px;">
                            <legend style="font-size: 12px; font-weight: 600; color: var(--ir-gray-700);">
                                <?php esc_html_e('Meta Fields', 'instarank'); ?>
                            </legend>
                            <label style="display: block; margin-bottom: 8px;">
                                <input type="checkbox"
                                       name="allowed_change_types[]"
                                       value="meta_title"
                                       <?php checked(in_array('meta_title', $instarank_allowed_types)); ?>>
                                <?php esc_html_e('Meta Title', 'instarank'); ?>
                            </label>
                            <label style="display: block; margin-bottom: 8px;">
                                <input type="checkbox"
                                       name="allowed_change_types[]"
                                       value="meta_description"
                                       <?php checked(in_array('meta_description', $instarank_allowed_types)); ?>>
                                <?php esc_html_e('Meta Description', 'instarank'); ?>
                            </label>
                            <label style="display: block;">
                                <input type="checkbox"
                                       name="allowed_change_types[]"
                                       value="focus_keyword"
                                       <?php checked(in_array('focus_keyword', $instarank_allowed_types)); ?>>
                                <?php esc_html_e('Focus Keyword', 'instarank'); ?>
                            </label>
                        </fieldset>
                        <p class="ir-help">
                            <?php esc_html_e('Select which types of changes InstaRank is allowed to make.', 'instarank'); ?>
                        </p>
                    </div>

                    <div class="ir-form-section">
                        <label class="ir-label">
                            <?php esc_html_e('Schema Settings', 'instarank'); ?>
                        </label>
                        <label style="display: block; margin-bottom: 8px;">
                            <input type="checkbox"
                                   name="schema_auto_generate"
                                   value="1"
                                   <?php checked($instarank_schema_auto_generate, true); ?>>
                            <?php esc_html_e('Auto-generate schema markup', 'instarank'); ?>
                        </label>
                        <label style="display: block; margin-bottom: 8px;">
                            <input type="checkbox"
                                   name="schema_search_action"
                                   value="1"
                                   <?php checked($instarank_schema_search_action, true); ?>>
                            <?php esc_html_e('Enable SearchAction schema', 'instarank'); ?>
                        </label>
                        <label style="display: block; margin-bottom: 8px;">
                            <input type="checkbox"
                                   name="breadcrumb_schema_enabled"
                                   value="1"
                                   <?php checked($instarank_breadcrumb_schema_enabled, true); ?>>
                            <?php esc_html_e('Enable BreadcrumbList schema', 'instarank'); ?>
                        </label>
                        <p class="ir-help">
                            <?php esc_html_e('Automatically generate structured data for better SEO.', 'instarank'); ?>
                        </p>
                    </div>

                    <div class="ir-form-section">
                        <label class="ir-label">
                            <?php esc_html_e('Breadcrumb Settings', 'instarank'); ?>
                        </label>
                        <label style="display: block; margin-bottom: 8px;">
                            <input type="checkbox"
                                   name="breadcrumb_show_home"
                                   value="1"
                                   <?php checked($instarank_breadcrumb_show_home, true); ?>>
                            <?php esc_html_e('Show home link', 'instarank'); ?>
                        </label>
                        <label style="display: block; margin-bottom: 8px;">
                            <input type="checkbox"
                                   name="breadcrumb_show_current"
                                   value="1"
                                   <?php checked($instarank_breadcrumb_show_current, true); ?>>
                            <?php esc_html_e('Show current page', 'instarank'); ?>
                        </label>
                        <div style="margin-top: 12px;">
                            <label class="ir-label" for="breadcrumb_separator">
                                <?php esc_html_e('Separator', 'instarank'); ?>
                            </label>
                            <input type="text"
                                   id="breadcrumb_separator"
                                   name="breadcrumb_separator"
                                   value="<?php echo esc_attr($instarank_breadcrumb_separator); ?>"
                                   class="ir-input-sm"
                                   style="width: 100px;">
                        </div>
                    </div>

                    <div class="ir-form-section">
                        <label class="ir-label">
                            <?php esc_html_e('Sitemap & Robots.txt', 'instarank'); ?>
                        </label>
                        <p class="ir-help" style="background: #f0f9ff; padding: 12px; border-radius: 6px; border: 1px solid #bae6fd;">
                            <?php esc_html_e('Sitemap, Robots.txt, and LLMs.txt settings are now managed from the InstaRank dashboard.', 'instarank'); ?>
                            <br><br>
                            <a href="<?php echo esc_url(home_url('/sitemap.xml')); ?>" target="_blank" class="ir-link">
                                <?php esc_html_e('View Sitemap', 'instarank'); ?> →
                            </a>
                            &nbsp;|&nbsp;
                            <a href="<?php echo esc_url(home_url('/robots.txt')); ?>" target="_blank" class="ir-link">
                                <?php esc_html_e('View Robots.txt', 'instarank'); ?> →
                            </a>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Advanced Tab -->
            <div class="ir-tab-panel" data-panel="advanced">
                <div class="ir-form-grid">
                    <div class="ir-form-section">
                        <label class="ir-label">
                            <?php esc_html_e('API Configuration', 'instarank'); ?>
                        </label>
                        <p style="margin-bottom: 8px;">
                            <strong><?php esc_html_e('API URL:', 'instarank'); ?></strong><br>
                            <code style="font-size: 12px;"><?php echo esc_html(INSTARANK_API_URL); ?></code>
                        </p>
                        <p style="margin-bottom: 8px;">
                            <strong><?php esc_html_e('Site URL:', 'instarank'); ?></strong><br>
                            <code style="font-size: 12px;"><?php echo esc_html(get_site_url()); ?></code>
                        </p>
                        <p>
                            <strong><?php esc_html_e('Plugin Version:', 'instarank'); ?></strong><br>
                            <code style="font-size: 12px;"><?php echo esc_html(INSTARANK_VERSION); ?></code>
                        </p>
                    </div>

                    <div class="ir-form-section">
                        <label class="ir-label">
                            <?php esc_html_e('Debug Information', 'instarank'); ?>
                        </label>
                        <p style="margin-bottom: 8px;">
                            <strong><?php esc_html_e('WordPress Version:', 'instarank'); ?></strong><br>
                            <code style="font-size: 12px;"><?php echo esc_html(get_bloginfo('version')); ?></code>
                        </p>
                        <p style="margin-bottom: 8px;">
                            <strong><?php esc_html_e('PHP Version:', 'instarank'); ?></strong><br>
                            <code style="font-size: 12px;"><?php echo esc_html(PHP_VERSION); ?></code>
                        </p>
                        <p>
                            <strong><?php esc_html_e('Active SEO Plugin:', 'instarank'); ?></strong><br>
                            <code style="font-size: 12px;"><?php echo esc_html($instarank_seo_plugin !== 'none' ? ucfirst($instarank_seo_plugin) : 'None'); ?></code>
                        </p>
                    </div>

                </div>
            </div>

            <!-- Danger Zone Tab -->
            <div class="ir-tab-panel" data-panel="danger">
                <div style="background: #fef2f2; border: 2px solid var(--ir-error); border-radius: 8px; padding: 20px;">
                    <h3 style="margin-top: 0; color: var(--ir-error);">
                        ⚠️ <?php esc_html_e('Danger Zone', 'instarank'); ?>
                    </h3>

                    <div style="margin-bottom: 24px; padding-bottom: 24px; border-bottom: 1px solid var(--ir-gray-200);">
                        <strong><?php esc_html_e('Reset Failed Authentication Attempts', 'instarank'); ?></strong>
                        <p class="ir-help">
                            <?php esc_html_e('Clear the failed authentication counter if you\'ve been locked out.', 'instarank'); ?>
                        </p>
                        <button type="button" class="ir-btn" id="instarank-reset-auth-attempts">
                            <?php esc_html_e('Reset Counter', 'instarank'); ?>
                        </button>
                    </div>

                    <?php if ($instarank_connected): ?>
                    <div style="margin-bottom: 24px; padding-bottom: 24px; border-bottom: 1px solid var(--ir-gray-200);">
                        <strong><?php esc_html_e('Disconnect from InstaRank', 'instarank'); ?></strong>
                        <p class="ir-help">
                            <?php esc_html_e('This will disconnect your WordPress site from InstaRank. You can reconnect anytime.', 'instarank'); ?>
                            <?php if ($instarank_project_id): ?>
                                <br><small>Project ID: <?php echo esc_html($instarank_project_id); ?></small>
                            <?php endif; ?>
                        </p>
                        <button type="button" class="ir-btn ir-btn--danger" id="instarank-disconnect">
                            <?php esc_html_e('Disconnect', 'instarank'); ?>
                        </button>
                    </div>
                    <?php else: ?>
                    <div style="margin-bottom: 24px; padding-bottom: 24px; border-bottom: 1px solid var(--ir-gray-200);">
                        <strong><?php esc_html_e('Not Connected', 'instarank'); ?></strong>
                        <p class="ir-help">
                            <?php esc_html_e('Your site is not currently connected to InstaRank. Connect from the General tab.', 'instarank'); ?>
                        </p>
                    </div>
                    <?php endif; ?>

                    <div>
                        <strong><?php esc_html_e('Clear All Change History', 'instarank'); ?></strong>
                        <p class="ir-help">
                            <?php esc_html_e('⚠️ Warning: This will permanently delete all change records. This cannot be undone.', 'instarank'); ?>
                        </p>
                        <button type="button" class="ir-btn ir-btn--danger" id="instarank-clear-history">
                            <?php esc_html_e('Clear History', 'instarank'); ?>
                        </button>
                    </div>
                </div>
            </div>

        </div>

        <!-- Sticky Footer (60px) -->
        <div class="ir-settings-footer">
            <button type="submit" name="instarank_save_settings" class="ir-btn ir-btn--primary">
                <?php esc_html_e('Save Settings', 'instarank'); ?>
            </button>
            <button type="button" class="ir-btn" onclick="location.reload();">
                <?php esc_html_e('Cancel', 'instarank'); ?>
            </button>
        </div>
    </form>
</div>
