<?php
/**
 * Admin Dashboard Page - Minimalist No-Scroll Design
 * Total Height: 740px (fits 768p screens)
 */

defined('ABSPATH') || exit;

$instarank_auth_manager = new InstaRank_Auth_Manager();
$instarank_api_handler = new InstaRank_API_Handler();
$instarank_change_manager = new InstaRank_Change_Manager();
$instarank_detector = new InstaRank_SEO_Detector();

$instarank_api_key = $instarank_auth_manager->get_current_api_key();
$instarank_connected = get_option('instarank_connected', false);
$instarank_project_id = get_option('instarank_project_id', '');
$instarank_last_sync = get_option('instarank_last_sync', null);

// Get stats
$instarank_pending_changes = $instarank_change_manager->get_changes('pending', 5);
$instarank_seo_plugin = $instarank_detector->get_active_seo_plugin();

// Count statistics
$instarank_pending_count = count($instarank_change_manager->get_changes('pending', 1000));
$instarank_applied_count = count($instarank_change_manager->get_changes('applied', 1000));
$instarank_total_published = 0;
$instarank_post_types = get_post_types(['public' => true], 'names');
foreach ($instarank_post_types as $post_type) {
    if ($post_type !== 'attachment') {
        $instarank_count = wp_count_posts($post_type);
        $instarank_total_published += ($instarank_count->publish ?? 0);
    }
}

// Programmatic SEO Statistics - These will be loaded dynamically via JavaScript
$instarank_pseo_has_dataset = false;
$instarank_pseo_dataset_name = '';
$instarank_pseo_column_count = 0;
$instarank_pseo_configured_templates = 0;
$instarank_pseo_total_mapped_fields = 0;
$instarank_pseo_is_ready = false;

?>

<div class="wrap instarank-dashboard">
    <h1><?php esc_html_e('InstaRank Dashboard', 'instarank'); ?></h1>

    <!-- Top Row: 2-Column Grid (280px height) -->
    <div class="ir-dashboard-grid">

        <!-- Left Column: Connection Status -->
        <div class="ir-card ir-card--compact">
            <div class="ir-card__header">
                <h2><?php esc_html_e('Connection', 'instarank'); ?></h2>
                <?php if ($instarank_connected): ?>
                    <span class="ir-badge ir-badge--success">
                        <span class="ir-badge__dot"></span>
                        <?php esc_html_e('Connected', 'instarank'); ?>
                    </span>
                <?php else: ?>
                    <span class="ir-badge ir-badge--warning">
                        <span class="ir-badge__dot"></span>
                        <?php esc_html_e('Not Connected', 'instarank'); ?>
                    </span>
                <?php endif; ?>
            </div>
            <div class="ir-card__body">
                <?php if ($instarank_connected): ?>
                    <div class="ir-connection-info">
                        <?php if ($instarank_project_id): ?>
                            <p>
                                <strong><?php esc_html_e('Project ID:', 'instarank'); ?></strong>
                                <code style="font-size: 12px;"><?php echo esc_html(substr($instarank_project_id, 0, 12) . '...'); ?></code>
                            </p>
                        <?php endif; ?>

                        <?php if ($instarank_last_sync): ?>
                            <p>
                                <strong><?php esc_html_e('Last Sync:', 'instarank'); ?></strong>
                                <?php echo esc_html(human_time_diff(strtotime($instarank_last_sync), current_time('timestamp'))); ?> ago
                            </p>
                        <?php endif; ?>

                        <?php if ($instarank_seo_plugin !== 'none'): ?>
                            <p>
                                <strong><?php esc_html_e('SEO Plugin:', 'instarank'); ?></strong>
                                <?php echo esc_html(ucfirst($instarank_seo_plugin)); ?>
                            </p>
                        <?php endif; ?>
                    </div>

                    <div class="ir-btn-group">
                        <button class="ir-btn ir-btn--sm" id="instarank-test-connection">
                            <?php esc_html_e('Test', 'instarank'); ?>
                        </button>
                        <button class="ir-btn ir-btn--sm ir-btn--primary" id="instarank-sync-now">
                            <?php esc_html_e('Sync Now', 'instarank'); ?>
                        </button>
                    </div>

                <?php else: ?>
                    <p><?php esc_html_e('Connect your WordPress site to InstaRank to start optimizing your SEO.', 'instarank'); ?></p>

                    <div class="ir-btn-group">
                        <button class="ir-btn ir-btn--primary" id="instarank-connect-popup">
                            <?php esc_html_e('Connect with InstaRank', 'instarank'); ?>
                        </button>
                        <button class="ir-btn ir-btn--sm" id="instarank-check-connection">
                            <?php esc_html_e('Check Status', 'instarank'); ?>
                        </button>
                    </div>

                    <p class="ir-help" style="margin-top: 12px;">
                        <?php esc_html_e('Need help?', 'instarank'); ?>
                        <a href="<?php echo esc_url(admin_url('admin.php?page=instarank-settings')); ?>" class="ir-link">
                            <?php esc_html_e('View API Key', 'instarank'); ?>
                        </a>
                    </p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Right Column: Statistics -->
        <div class="ir-card ir-card--compact">
            <div class="ir-card__header">
                <h2><?php esc_html_e('SEO Statistics', 'instarank'); ?></h2>
            </div>
            <div class="ir-card__body">
                <div class="ir-stats-inline">
                    <div class="ir-stat-compact">
                        <div class="ir-stat__value"><?php echo esc_html($instarank_pending_count); ?></div>
                        <div class="ir-stat__label"><?php esc_html_e('Pending', 'instarank'); ?></div>
                    </div>
                    <div class="ir-stat-compact">
                        <div class="ir-stat__value"><?php echo esc_html($instarank_applied_count); ?></div>
                        <div class="ir-stat__label"><?php esc_html_e('Applied', 'instarank'); ?></div>
                    </div>
                    <div class="ir-stat-compact">
                        <div class="ir-stat__value"><?php echo esc_html($instarank_total_published); ?></div>
                        <div class="ir-stat__label"><?php esc_html_e('Total Posts', 'instarank'); ?></div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Programmatic SEO Section -->
    <div class="ir-card ir-pseo-card" style="margin-top: 16px;">
        <div class="ir-card__header">
            <h2>
                <span class="dashicons dashicons-analytics" style="color: #F97316; vertical-align: middle; margin-right: 6px;"></span>
                <?php esc_html_e('Programmatic SEO', 'instarank'); ?>
            </h2>
            <span class="ir-badge" style="background: #f5f5f5; color: #666;" id="pseo-status-badge">
                <?php esc_html_e('Loading...', 'instarank'); ?>
            </span>
        </div>
        <div class="ir-card__body">
            <div class="ir-pseo-grid">
                <!-- Stats Column -->
                <div class="ir-pseo-stats">
                    <div class="ir-stats-inline">
                        <div class="ir-stat-compact">
                            <div class="ir-stat__value" style="color: #F97316;" id="pseo-templates-count">
                                <span class="spinner" style="visibility: visible; float: none; margin: 0;"></span>
                            </div>
                            <div class="ir-stat__label"><?php esc_html_e('Templates', 'instarank'); ?></div>
                        </div>
                        <div class="ir-stat-compact">
                            <div class="ir-stat__value" style="color: #10B981;" id="pseo-fields-count">
                                <span class="spinner" style="visibility: visible; float: none; margin: 0;"></span>
                            </div>
                            <div class="ir-stat__label"><?php esc_html_e('Mapped Fields', 'instarank'); ?></div>
                        </div>
                        <div class="ir-stat-compact">
                            <div class="ir-stat__value" style="color: #5C4033;" id="pseo-columns-count">
                                <span class="spinner" style="visibility: visible; float: none; margin: 0;"></span>
                            </div>
                            <div class="ir-stat__label"><?php esc_html_e('Dataset Columns', 'instarank'); ?></div>
                        </div>
                    </div>
                </div>

                <!-- Info Column -->
                <div class="ir-pseo-info" id="pseo-info">
                    <p style="margin: 0 0 8px 0; color: #888;">
                        <span class="spinner" style="visibility: visible; float: none; margin: 0;"></span>
                        <?php esc_html_e('Loading...', 'instarank'); ?>
                    </p>
                </div>

                <!-- Action Column -->
                <div class="ir-pseo-actions">
                    <?php
                    $instarank_app_url = defined('INSTARANK_API_URL') ? INSTARANK_API_URL : 'https://app.instarank.com';
                    $instarank_project_slug = get_option('instarank_project_slug', '');

                    if ($instarank_pseo_is_ready) :
                        $instarank_generate_url = $instarank_project_slug
                            ? $instarank_app_url . '/projects/' . $instarank_project_slug . '/programmatic-seo/generate'
                            : $instarank_app_url . '/projects';
                    ?>
                        <a href="<?php echo esc_url($instarank_generate_url); ?>" class="ir-btn ir-btn--primary" style="background: #10B981; border-color: #10B981;" target="_blank">
                            <span class="dashicons dashicons-controls-play" style="font-size: 16px; vertical-align: middle; margin-right: 4px;"></span>
                            <?php esc_html_e('Generate Pages', 'instarank'); ?>
                        </a>
                    <?php
                    elseif (! $instarank_pseo_has_dataset) :
                        $instarank_datasets_url = $instarank_project_slug
                            ? $instarank_app_url . '/projects/' . $instarank_project_slug . '/programmatic-seo/datasets'
                            : $instarank_app_url . '/projects';
                    ?>
                        <a href="<?php echo esc_url($instarank_datasets_url); ?>" class="ir-btn ir-btn--primary" style="background: #F97316; border-color: #F97316;" target="_blank">
                            <?php esc_html_e('Link Dataset', 'instarank'); ?>
                        </a>
                    <?php
                    else :
                        $instarank_templates_url = $instarank_project_slug
                            ? $instarank_app_url . '/projects/' . $instarank_project_slug . '/programmatic-seo/post-types'
                            : $instarank_app_url . '/projects';
                    ?>
                        <a href="<?php echo esc_url($instarank_templates_url); ?>" class="ir-btn ir-btn--primary" style="background: #F97316; border-color: #F97316;" target="_blank">
                            <?php esc_html_e('Configure Template', 'instarank'); ?>
                        </a>
                    <?php
                    endif;
                    $instarank_view_all_url = $instarank_project_slug
                        ? $instarank_app_url . '/projects/' . $instarank_project_slug . '/programmatic-seo'
                        : $instarank_app_url . '/projects';
                    ?>
                    <a href="<?php echo esc_url($instarank_view_all_url); ?>" class="ir-btn ir-btn--sm" style="margin-left: 8px;" target="_blank">
                        <?php esc_html_e('View All', 'instarank'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Changes Table (340px fixed height) -->
    <?php if (!empty($instarank_pending_changes)): ?>
        <div class="ir-card ir-table-container">
            <div class="ir-card__header">
                <h2><?php esc_html_e('Recent Changes', 'instarank'); ?></h2>
                <a href="<?php echo esc_url(admin_url('admin.php?page=instarank-changes')); ?>" class="ir-link">
                    <?php esc_html_e('View All', 'instarank'); ?> →
                </a>
            </div>
            <div class="ir-table-scrollable">
                <table class="ir-table-compact">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Post', 'instarank'); ?></th>
                            <th><?php esc_html_e('Type', 'instarank'); ?></th>
                            <th><?php esc_html_e('Status', 'instarank'); ?></th>
                            <th><?php esc_html_e('Date', 'instarank'); ?></th>
                            <th><?php esc_html_e('Actions', 'instarank'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($instarank_pending_changes as $instarank_change): ?>
                            <?php
                            $instarank_meta = [];
                            if (!empty($instarank_change['metadata'])) {
                                $instarank_decoded = json_decode($instarank_change['metadata'], true);
                                if (is_array($instarank_decoded)) {
                                    $instarank_meta = $decoded;
                                }
                            }

                            $post_id = isset($instarank_change['post_id']) ? intval($instarank_change['post_id']) : 0;
                            $instarank_post_title = isset($instarank_meta['post_title']) ? $instarank_meta['post_title'] : '';

                            if (!$instarank_post_title && $post_id) {
                                $instarank_post_obj = get_post($post_id);
                                if ($instarank_post_obj) {
                                    $instarank_post_title = $instarank_post_obj->post_title;
                                }
                            }

                            if (!$instarank_post_title && $post_id === 0) {
                                $instarank_post_title = __('Homepage', 'instarank');
                            }

                            $instarank_change_type_label = isset($instarank_change['change_type']) ? str_replace('_', ' ', ucwords($instarank_change['change_type'])) : '';
                            $instarank_created_at = isset($instarank_change['created_at']) ? $instarank_change['created_at'] : '';
                            ?>
                            <tr>
                                <td>
                                    <strong><?php echo esc_html(wp_trim_words($instarank_post_title, 5)); ?></strong>
                                </td>
                                <td>
                                    <span class="ir-badge-sm">
                                        <?php echo esc_html($instarank_change_type_label); ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="instarank-status-badge instarank-status-<?php echo esc_attr($instarank_change['status']); ?>">
                                        <?php echo esc_html(ucfirst($instarank_change['status'])); ?>
                                    </span>
                                </td>
                                <td>
                                    <?php
                                    if (!empty($created_at)) {
                                        $instarank_ts = strtotime($created_at);
                                        if ($instarank_ts) {
                                            echo esc_html(human_time_diff($ts, current_time('timestamp'))) . ' ' . esc_html__('ago', 'instarank');
                                        }
                                    }
                                    ?>
                                </td>
                                <td>
                                    <button type="button"
                                            class="ir-btn-icon instarank-approve-change"
                                            data-change-id="<?php echo esc_attr($instarank_change['id']); ?>"
                                            title="<?php esc_attr_e('Approve', 'instarank'); ?>">
                                        A
                                    </button>
                                    <button type="button"
                                            class="ir-btn-icon instarank-reject-change"
                                            data-change-id="<?php echo esc_attr($instarank_change['id']); ?>"
                                            title="<?php esc_attr_e('Reject', 'instarank'); ?>">
                                        R
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <!-- Quick Actions Bar (60px) -->
    <div class="ir-actions-bar">
        <a href="<?php echo esc_url(admin_url('admin.php?page=instarank-changes')); ?>" class="ir-btn">
            <?php esc_html_e('View All Changes', 'instarank'); ?>
        </a>
        <a href="<?php echo esc_url(admin_url('admin.php?page=instarank-settings')); ?>" class="ir-btn">
            <?php esc_html_e('Settings', 'instarank'); ?>
        </a>
        <a href="https://instarank.com/docs" target="_blank" class="ir-link">
            <?php esc_html_e('Documentation', 'instarank'); ?> →
        </a>
        <a href="https://instarank.com/support" target="_blank" class="ir-link">
            <?php esc_html_e('Support', 'instarank'); ?> →
        </a>
    </div>
</div>
