<?php
/**
 * Admin Changes Page - Minimalist Fixed-Height No-Scroll Design
 * Total Height: 680px (fits 768p screens)
 */

defined('ABSPATH') || exit;

$instarank_change_manager = new InstaRank_Change_Manager();

// Handle bulk actions
if (isset($_POST['instarank_bulk_action']) && isset($_POST['change_ids'])) {
    check_admin_referer('instarank_bulk_changes');

    $action = sanitize_text_field(wp_unslash($_POST['instarank_bulk_action']));
    $instarank_change_ids = array_map('intval', wp_unslash($_POST['change_ids']));

    foreach ($instarank_change_ids as $instarank_change_id) {
        if ($action === 'approve') {
            $instarank_change_manager->approve_change($change_id);
        } elseif ($action === 'reject') {
            $instarank_change_manager->reject_change($change_id);
        }
    }

    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Changes updated successfully.', 'instarank') . '</p></div>';
}

// Get filter
$instarank_status_filter = isset($_GET['status']) ? sanitize_text_field(wp_unslash($_GET['status'])) : 'pending';

// Get changes with pagination
$instarank_page = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
$instarank_per_page = 50;
$instarank_offset = ($instarank_page - 1) * $instarank_per_page;

// Get total count
global $wpdb;
$instarank_table = $wpdb->prefix . 'instarank_changes';
$instarank_where = $instarank_status_filter === 'all' ? '1=1' : $wpdb->prepare('status = %s', $instarank_status_filter);
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
$instarank_total_changes = $wpdb->get_var("SELECT COUNT(*) FROM {$instarank_table} WHERE {$instarank_where}");

// Get changes for current page
$instarank_changes = $instarank_change_manager->get_changes($instarank_status_filter, $instarank_per_page, $instarank_offset);

// Calculate pagination
$instarank_total_pages = ceil($instarank_total_changes / $instarank_per_page);

// Get counts for tabs
$instarank_pending_count = count($instarank_change_manager->get_changes('pending', 1000));
$instarank_applied_count = count($instarank_change_manager->get_changes('applied', 1000));
$instarank_rejected_count = count($instarank_change_manager->get_changes('rejected', 1000));
$instarank_rolled_back_count = count($instarank_change_manager->get_changes('rolled_back', 1000));

?>

<div class="wrap instarank-changes-page">
    <h1><?php esc_html_e('SEO Changes', 'instarank'); ?></h1>

    <!-- Tab Navigation (48px) -->
    <nav class="ir-tabs">
        <button type="button"
                class="ir-tab <?php echo $instarank_status_filter === 'pending' ? 'ir-tab--active' : ''; ?>"
                onclick="location.href='<?php echo esc_url(admin_url('admin.php?page=instarank-changes&status=pending')); ?>'">
            <?php esc_html_e('Pending', 'instarank'); ?>
            <?php if ($instarank_pending_count > 0): ?>
                <span class="ir-badge ir-badge--primary" style="margin-left: 6px;"><?php echo esc_html($instarank_pending_count); ?></span>
            <?php endif; ?>
        </button>
        <button type="button"
                class="ir-tab <?php echo $instarank_status_filter === 'applied' ? 'ir-tab--active' : ''; ?>"
                onclick="location.href='<?php echo esc_url(admin_url('admin.php?page=instarank-changes&status=applied')); ?>'">
            <?php esc_html_e('Applied', 'instarank'); ?>
            <?php if ($instarank_applied_count > 0): ?>
                <span class="ir-badge ir-badge--success" style="margin-left: 6px;"><?php echo esc_html($instarank_applied_count); ?></span>
            <?php endif; ?>
        </button>
        <button type="button"
                class="ir-tab <?php echo $instarank_status_filter === 'rejected' ? 'ir-tab--active' : ''; ?>"
                onclick="location.href='<?php echo esc_url(admin_url('admin.php?page=instarank-changes&status=rejected')); ?>'">
            <?php esc_html_e('Rejected', 'instarank'); ?>
        </button>
        <button type="button"
                class="ir-tab <?php echo $instarank_status_filter === 'rolled_back' ? 'ir-tab--active' : ''; ?>"
                onclick="location.href='<?php echo esc_url(admin_url('admin.php?page=instarank-changes&status=rolled_back')); ?>'">
            <?php esc_html_e('Rolled Back', 'instarank'); ?>
        </button>
        <button type="button"
                class="ir-tab <?php echo $instarank_status_filter === 'all' ? 'ir-tab--active' : ''; ?>"
                onclick="location.href='<?php echo esc_url(admin_url('admin.php?page=instarank-changes&status=all')); ?>'">
            <?php esc_html_e('All', 'instarank'); ?>
        </button>
    </nav>

    <?php if (empty($instarank_changes)): ?>
        <!-- Empty State -->
        <div class="ir-card" style="padding: 60px 20px; text-align: center; height: 480px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
            <div style="font-size: 48px; color: var(--ir-gray-300); margin-bottom: 16px;">
                <span class="dashicons dashicons-yes-alt"></span>
            </div>
            <h2 style="margin: 0 0 12px 0; color: var(--ir-gray-700); font-size: 20px;">
                <?php esc_html_e('No Changes Found', 'instarank'); ?>
            </h2>
            <p style="color: var(--ir-gray-600); max-width: 400px; margin: 0;">
                <?php
                if ($instarank_status_filter === 'pending') {
                    esc_html_e('You have no pending changes. Changes will appear here when InstaRank sends SEO optimizations.', 'instarank');
                } else {
                    esc_html_e('No changes found with this status.', 'instarank');
                }
                ?>
            </p>
        </div>
    <?php else: ?>

        <!-- Bulk Actions Bar (44px) -->
        <?php if ($instarank_status_filter === 'pending'): ?>
            <form method="post" id="instarank-changes-form">
                <?php wp_nonce_field('instarank_bulk_changes'); ?>

                <div class="ir-bulk-actions">
                    <select name="instarank_bulk_action" id="bulk-action-selector" class="ir-select-sm">
                        <option value=""><?php esc_html_e('Bulk Actions', 'instarank'); ?></option>
                        <option value="approve"><?php esc_html_e('Approve', 'instarank'); ?></option>
                        <option value="reject"><?php esc_html_e('Reject', 'instarank'); ?></option>
                    </select>
                    <button type="submit" class="ir-btn ir-btn--sm">
                        <?php esc_html_e('Apply', 'instarank'); ?>
                    </button>
                    <span class="ir-selected-count">
                        <?php esc_html_e('Selected: 0', 'instarank'); ?>
                    </span>
                </div>
        <?php endif; ?>

        <!-- Fixed Height Table (480px) -->
        <div class="ir-table-wrapper">
            <table class="ir-table-fixed">
                <thead>
                    <tr>
                        <?php if ($instarank_status_filter === 'pending'): ?>
                            <th style="width: 40px;">
                                <input type="checkbox" id="instarank-select-all">
                            </th>
                        <?php endif; ?>
                        <th style="width: 25%;"><?php esc_html_e('Post', 'instarank'); ?></th>
                        <th style="width: 15%;"><?php esc_html_e('Type', 'instarank'); ?></th>
                        <th style="width: 30%;"><?php esc_html_e('Preview', 'instarank'); ?></th>
                        <th style="width: 15%;"><?php esc_html_e('Date', 'instarank'); ?></th>
                        <th style="width: 15%;"><?php esc_html_e('Actions', 'instarank'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($instarank_changes as $instarank_change): ?>
                        <?php
                        // Safely decode metadata
                        $instarank_meta = [];
                        if (!empty($instarank_change['metadata'])) {
                            $instarank_decoded = json_decode($instarank_change['metadata'], true);
                            if (is_array($instarank_decoded)) {
                                $instarank_meta = $instarank_decoded;
                            }
                        }

                        $instarank_post_id = isset($instarank_change['post_id']) ? intval($instarank_change['post_id']) : 0;
                        $instarank_post_title = isset($instarank_meta['post_title']) ? $instarank_meta['post_title'] : '';
                        $instarank_post_url = isset($instarank_meta['post_url']) ? $instarank_meta['post_url'] : '';

                        if (!$instarank_post_title && $instarank_post_id) {
                            $instarank_post_obj = get_post($instarank_post_id);
                            if ($instarank_post_obj) {
                                $instarank_post_title = $instarank_post_obj->post_title;
                                $instarank_post_url = get_permalink($instarank_post_id);
                            }
                        }

                        if (!$instarank_post_title && $instarank_post_id === 0) {
                            $instarank_post_title = __('Homepage', 'instarank');
                            $instarank_post_url = home_url('/');
                        }

                        $instarank_change_type_label = isset($instarank_change['change_type']) ? str_replace('_', ' ', ucwords($instarank_change['change_type'])) : '';
                        $instarank_new_value = isset($instarank_change['new_value']) ? $instarank_change['new_value'] : '';
                        $instarank_status = isset($instarank_change['status']) ? $instarank_change['status'] : 'pending';
                        $instarank_created_at = isset($instarank_change['created_at']) ? $instarank_change['created_at'] : '';
                        $instarank_applied_at = isset($instarank_change['applied_at']) ? $instarank_change['applied_at'] : '';
                        $instarank_date_field = ($instarank_status === 'applied') ? $instarank_applied_at : $instarank_created_at;
                        ?>
                        <tr>
                            <?php if ($instarank_status_filter === 'pending'): ?>
                                <td>
                                    <input type="checkbox"
                                           name="change_ids[]"
                                           value="<?php echo esc_attr($instarank_change['id']); ?>"
                                           class="instarank-change-checkbox">
                                </td>
                            <?php endif; ?>

                            <td>
                                <strong><?php echo esc_html(wp_trim_words($instarank_post_title, 4)); ?></strong>
                                <?php if (!empty($instarank_post_url)): ?>
                                    <br>
                                    <a href="<?php echo esc_url($instarank_post_url); ?>"
                                       target="_blank"
                                       class="ir-link"
                                       style="font-size: 11px;">
                                        <?php esc_html_e('View', 'instarank'); ?> →
                                    </a>
                                <?php endif; ?>
                            </td>

                            <td>
                                <span class="ir-badge-sm">
                                    <?php echo esc_html($instarank_change_type_label); ?>
                                </span>
                            </td>

                            <td>
                                <div class="ir-text-truncate">
                                    <?php echo esc_html(wp_trim_words($instarank_new_value, 10)); ?>
                                </div>
                            </td>

                            <td>
                                <?php
                                if (!empty($instarank_date_field)) {
                                    $instarank_ts = strtotime($instarank_date_field);
                                    if ($instarank_ts) {
                                        echo esc_html(human_time_diff($instarank_ts, current_time('timestamp'))) . ' ' . esc_html__('ago', 'instarank');
                                    }
                                }
                                ?>
                            </td>

                            <td>
                                <?php if ($instarank_status === 'pending'): ?>
                                    <button type="button"
                                            class="ir-btn-icon instarank-approve-change"
                                            data-change-id="<?php echo esc_attr($instarank_change['id']); ?>"
                                            title="<?php esc_attr_e('Approve', 'instarank'); ?>">
                                        A
                                    </button>
                                    <button type="button"
                                            class="ir-btn-icon instarank-reject-change"
                                            data-change-id="<?php echo esc_attr($instarank_change['id']); ?>"
                                            title="<?php esc_attr_e('Reject', 'instarank'); ?>">
                                        R
                                    </button>

                                <?php elseif ($instarank_status === 'applied'): ?>
                                    <button type="button"
                                            class="ir-btn-icon instarank-rollback-change"
                                            data-change-id="<?php echo esc_attr($instarank_change['id']); ?>"
                                            title="<?php esc_attr_e('Rollback', 'instarank'); ?>">
                                        ↶
                                    </button>
                                <?php endif; ?>

                                <button type="button"
                                        class="ir-btn-icon instarank-view-details"
                                        data-change-id="<?php echo esc_attr($instarank_change['id']); ?>"
                                        title="<?php esc_attr_e('Details', 'instarank'); ?>">
                                    ⓘ
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <?php if ($instarank_status_filter === 'pending'): ?>
            </form>
        <?php endif; ?>

        <!-- Pagination (48px) -->
        <div class="ir-pagination">
            <span>
                <?php
                // translators: %1$d is the first item number, %2$d is the last item number, %3$d is the total number of changes
                echo esc_html(sprintf(__('Showing %1$d-%2$d of %3$d changes', 'instarank'), absint((($instarank_page - 1) * $instarank_per_page) + 1), absint(min($instarank_page * $instarank_per_page, $instarank_total_changes)), absint($instarank_total_changes)));
                ?>
            </span>
            <div class="ir-pagination-controls">
                <?php if ($instarank_page > 1): ?>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=instarank-changes&status=' . $instarank_status_filter . '&paged=' . ($instarank_page - 1))); ?>"
                       class="ir-btn ir-btn--sm">
                        ← <?php esc_html_e('Previous', 'instarank'); ?>
                    </a>
                <?php endif; ?>

                <?php if ($instarank_page < $instarank_total_pages): ?>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=instarank-changes&status=' . $instarank_status_filter . '&paged=' . ($instarank_page + 1))); ?>"
                       class="ir-btn ir-btn--sm">
                        <?php esc_html_e('Next', 'instarank'); ?> →
                    </a>
                <?php endif; ?>
            </div>
        </div>

    <?php endif; ?>
</div>

<!-- Change Details Modal -->
<div id="instarank-change-modal" class="instarank-modal" style="display: none;">
    <div class="instarank-modal-content">
        <span class="instarank-modal-close">&times;</span>
        <div id="instarank-modal-body"></div>
    </div>
</div>
