# InstaRank WordPress Plugin

Official WordPress plugin for InstaRank - AI-powered SEO platform.

## Description

The InstaRank WordPress plugin connects your WordPress site to the InstaRank SaaS platform, enabling automated SEO improvements, programmatic page generation, and comprehensive site crawling.

## Features

### SEO Management
- AI-powered SEO recommendations
- Automated SEO improvements with approval workflow
- Track and rollback changes
- Support for popular SEO plugins (Yoast, Rank Math, All in One SEO, AIOSEO)

### Programmatic SEO

**Note:** Starting in version 2.0, all Programmatic SEO features are managed through the InstaRank SaaS platform at [https://app.instarank.com](https://app.instarank.com).

The plugin handles backend operations while the SaaS platform provides the user interface for:
- Post type management
- Dataset upload and management (CSV, Excel, Google Sheets, Airtable, Notion, RSS, YouTube, WooCommerce)
- Template creation and page builder imports (Kadence, Elementor, Gutenberg, Bricks, Divi, Oxygen)
- Field mapping with auto-mapping AI
- Page generation with spintax variations
- Sync mode configuration
- Batch operations
- Advanced spintax tools with AI assistance

All pages generated in the SaaS are automatically synced to your WordPress site via the plugin API.

### Site Crawling
- Full site crawling and analysis
- Page-level SEO insights
- Performance metrics
- Technical SEO issues detection

### Integrations
- OAuth connection with InstaRank platform
- Real-time sync with SaaS dashboard
- Webhook notifications
- REST API for seamless communication

## Installation

### From WordPress Admin

1. Download the plugin ZIP file
2. Go to WordPress Admin → Plugins → Add New
3. Click "Upload Plugin"
4. Choose the ZIP file and click "Install Now"
5. Click "Activate Plugin"

### Manual Installation

1. Upload the `instarank` folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to InstaRank → Dashboard to complete setup

## Setup

### 1. Connect to InstaRank

1. Go to InstaRank → Dashboard in WordPress admin
2. Click "Connect to InstaRank"
3. Log in to your InstaRank account (or create one)
4. Authorize the connection
5. Your WordPress site is now connected!

### 2. Generate Programmatic Pages

1. Log in to [https://app.instarank.com](https://app.instarank.com)
2. Navigate to your project
3. Go to Programmatic SEO section
4. Use the Generation Wizard:
   - Select post type
   - Upload or link dataset
   - Create or import template
   - Configure options (spintax, sync mode, image import)
   - Generate pages
5. Pages will automatically sync to your WordPress site

### 3. Manage SEO Changes

1. InstaRank analyzes your site and generates SEO recommendations
2. Review pending changes in WordPress Admin → InstaRank → Pending Changes
3. Approve or reject changes individually or in bulk
4. Approved changes are applied automatically
5. Rollback any change with one click if needed

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- MySQL 5.6 or higher / MariaDB 10.0 or higher
- HTTPS (recommended for secure API communication)

## Supported Page Builders

- Kadence Blocks
- Elementor
- Gutenberg (Block Editor)
- Bricks Builder
- Divi Builder
- Oxygen Builder
- Beaver Builder

## Supported SEO Plugins

- Yoast SEO
- Rank Math
- All in One SEO (AIOSEO)
- SEOPress
- The SEO Framework
- Kadence Blocks SEO

## API Documentation

The plugin exposes REST API endpoints for communication with the InstaRank platform:

### Authentication
All API requests require the `X-WordPress-API-Key` header with your API key.

### Key Endpoints

- `POST /wp-json/instarank/v1/programmatic/pages` - Sync pages from SaaS
- `POST /wp-json/instarank/v1/programmatic/check-existing` - Check if page exists
- `GET /wp-json/instarank/v1/templates/{id}/fields` - Detect custom fields in template
- `POST /wp-json/instarank/v1/programmatic/post-types` - Register custom post types
- `POST /wp-json/instarank/v1/spintax/validate` - Validate spintax syntax
- `POST /wp-json/instarank/v1/spintax/preview` - Generate spintax variations

See full API documentation at [https://docs.instarank.com/api](https://docs.instarank.com/api)

## Frequently Asked Questions

### Where is the Programmatic SEO menu?

Starting in version 2.0, Programmatic SEO is managed at [https://app.instarank.com](https://app.instarank.com). This provides better features, easier management, and a more powerful interface. Your WordPress plugin continues to handle page syncing automatically.

### How do I generate programmatic pages?

1. Log in to [https://app.instarank.com](https://app.instarank.com)
2. Navigate to Programmatic SEO
3. Use the Generation Wizard to create pages
4. Pages sync automatically to WordPress

### Is my API key secure?

Yes. The API key is:
- Generated using cryptographically secure random functions
- Stored encrypted in the database
- Transmitted only over HTTPS
- Rate-limited to prevent abuse
- Can be regenerated at any time

### Can I use this with any theme?

Yes! The plugin works with any WordPress theme. For programmatic page generation, it integrates with popular page builders for the best experience.

### What happens if I deactivate the plugin?

- Generated pages remain in WordPress (they're regular WordPress posts/pages)
- SEO meta data remains intact
- Connection to InstaRank is paused
- You can reactivate anytime to restore the connection

### How do I get support?

- Documentation: [https://docs.instarank.com](https://docs.instarank.com)
- Support: [support@instarank.com](mailto:support@instarank.com)
- GitHub Issues: [https://github.com/instarank/wordpress-plugin/issues](https://github.com/instarank/wordpress-plugin/issues)

## Changelog

### 2.0.0 - [Release Date]

**BREAKING CHANGES**
- Removed Programmatic SEO UI from WordPress plugin
- All programmatic SEO features now managed via InstaRank SaaS platform
- WordPress plugin handles page syncing and spintax processing
- Backend API endpoints remain functional
- All functionality preserved in SaaS with better UX

**Migration Guide**
- Log in to https://app.instarank.com for programmatic SEO features
- Generation Wizard provides all previous functionality plus:
  - Better template management with page builder imports
  - Advanced spintax tools with AI assistance
  - More flexible sync modes
  - Batch operations
  - Enhanced dataset management

**Technical Changes**
- Removed menu: InstaRank > Programmatic SEO
- Removed 7 admin tab files
- Removed admin page handlers
- Kept all API endpoints for SaaS integration
- Kept spintax engine for local processing

### 1.5.x - Previous Versions

See [CHANGELOG.md](CHANGELOG.md) for complete version history.

## Credits

Developed by the InstaRank team.

## License

This plugin is proprietary software. All rights reserved.

For licensing inquiries, contact: [sales@instarank.com](mailto:sales@instarank.com)

## Links

- Website: [https://instarank.com](https://instarank.com)
- Platform: [https://app.instarank.com](https://app.instarank.com)
- Documentation: [https://docs.instarank.com](https://docs.instarank.com)
- Support: [support@instarank.com](mailto:support@instarank.com)
