<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/public/partials/templates
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-quote-5 inspqu-quote-template art-center" role="region" aria-live="polite">
	<div class="quote-slider">
		<?php foreach ( $quotes as $inspqu_quote ) : ?>
			<div class="quote-slide">
				<div class="quote-card">
					<div class="center-box">
						<span class="quote-top">“</span>
						<p class="quote-text">
							<?php echo esc_html( $inspqu_quote['quote_text'] ); ?>
						</p>
						<span class="quote-bottom">”</span>
						<h4 class="quote-author">
							<?php echo esc_html( $inspqu_quote['quote_author'] ); ?>
						</h4>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>