<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/public/partials/templates
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-quote-2 inspqu-quote-template glow-gradient" role="region" aria-live="polite">
	<div class="quote-slider">
		<?php foreach ( $quotes as $inspqu_quote ) : ?>
			<div class="quote-slide">
				<div class="quote-card">
					<div class="glow"></div>
					<p class="quote-text">
						<?php echo esc_html( $inspqu_quote['quote_text'] ); ?>
					</p>
					<h4 class="quote-author">
						<?php echo esc_html( $inspqu_quote['quote_author'] ); ?>
					</h4>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>