<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/public/partials/templates
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-quote-1 inspqu-quote-template dark-minimal" role="region" aria-live="polite">
	<div class="quote-slider">
		<?php foreach ( $quotes as $inspqu_quote ) : ?>
			<div class="quote-slide">
				<div class="quote-box">
					<div class="quote-mark">“</div>
					<p class="quote-text">
						<?php echo esc_html( $inspqu_quote['quote_text'] ); ?>
					</p>
					<div class="line"></div>
					<h4 class="quote-author">
						— <?php echo esc_html( $inspqu_quote['quote_author'] ); ?>
					</h4>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>