<?php 
namespace owthub\inspqu\public;
use owthub\inspqu\INSPQU_App_Helper;
use owthub\inspqu\INSPQU_Query_Helper;
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/public/partials/templates
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
if ( ! defined( 'ABSPATH' ) ) exit;

class INSPQU_Public {

	private $InspirePulseQuotes;

	private $version;

	public function __construct( $InspirePulseQuotes, $version ) {

		$this->InspirePulseQuotes = $InspirePulseQuotes;
		$this->version = $version;

	}

	public function inspqu_render_quote_template( $atts ) {

		// Parse shortcode attributes with defaults
		$atts = shortcode_atts([
			'design'  => 'default',
			'timer'   => '',
			'category' => '',
			'author'  => '',
			'limit'   => 0,
			'orderby' => 'random',
			'order'   => 'ASC',
			'id'      => 0,
			'exclude' => '',
			'status'  => 'active',
		], $atts, 'inspqu');

		$design_key = strtolower( trim( $atts['design'] ) );

		// Validate design
		if ( $design_key !== 'default' && ! in_array( $design_key, INSPQU_App_Helper::inspqu_get_allowed_quote_templates_keys() ) ) {
			return '<p><i>-- No Design Found! --</i></p>';
		}

		// Prepare query arguments
		$query_args = [
			'category' => ! empty( $atts['category'] ) ? $atts['category'] : '',
			'author'   => ! empty( $atts['author'] ) ? $atts['author'] : '',
			'limit'    => ! empty( $atts['limit'] ) ? absint( $atts['limit'] ) : 0,
			'orderby'  => ! empty( $atts['orderby'] ) ? strtolower( trim( $atts['orderby'] ) ) : 'random',
			'order'    => ! empty( $atts['order'] ) ? strtoupper( trim( $atts['order'] ) ) : 'ASC',
			'id'       => ! empty( $atts['id'] ) ? absint( $atts['id'] ) : 0,
			'exclude'  => ! empty( $atts['exclude'] ) ? $atts['exclude'] : '',
			'status'   => ! empty( $atts['status'] ) ? strtolower( trim( $atts['status'] ) ) : 'active',
		];

		// Convert status string to integer
		if ( $query_args['status'] === 'active' ) {
			$query_args['status'] = 1;
		} elseif ( $query_args['status'] === 'draft' ) {
			$query_args['status'] = 0;
		} elseif ( $query_args['status'] === 'all' ) {
			$query_args['status'] = 'all';
		} else {
			$query_args['status'] = 1; // Default to active
		}

		// Get quotes with filters
		$quotes = INSPQU_Query_Helper::inspqu_get_quotes_with_filters( $query_args );
		
		if ( ! $quotes || empty( $quotes ) ) {
			return '<p><i>-- No Quotes Found! --</i></p>';
		}

		$quote_template = INSPQU_App_Helper::inspqu_get_allowed_quote_templates( $design_key );
		$template_path  = INSPQU_App_Helper::get_inspqu_path() . "public/partials/templates/{$quote_template}-template.php";

		if ( ! file_exists( $template_path ) ) {
			return '<p>Quote template not found!</p>';
		}

		// === Enqueue template CSS ===
		$css_file = INSPQU_App_Helper::get_inspqu_url() . "public/assets/css/{$quote_template}.css";
		wp_enqueue_style(
			"inspqu-{$quote_template}-css",
			$css_file,
			array(),
			INSPQU_App_Helper::get_inspqu_version()
		);

		// === Enqueue template JS ===
		$js_file = INSPQU_App_Helper::get_inspqu_url() . "public/assets/js/{$quote_template}.js";
		wp_register_script(
			"inspqu-{$quote_template}-js",
			$js_file,
			array(),
			INSPQU_App_Helper::get_inspqu_version(),
			true
		);

		// Handle timer - check shortcode attribute first, then global setting
		$timer_ms = INSPQU_App_Helper::inspqu_get_default_timer_value();
		
		if ( ! empty( $atts['timer'] ) ) {
			// Timer from shortcode (in seconds)
			$timer_seconds = absint( $atts['timer'] );
			if ( $timer_seconds > 0 ) {
				$timer_ms = $timer_seconds * 1000;
			}
		} else {
			// Use global setting
			$global_timer = intval( get_option('inspqu_timer_miliseconds') );
			if ( $global_timer > 0 ) {
				$timer_ms = $global_timer;
			}
		}

		$quote_template_object = str_replace("-", "_", $quote_template);
		wp_localize_script(
			"inspqu-{$quote_template}-js",
			"inspqu_object_{$quote_template_object}",
			array(
				'timer_ms' => $timer_ms,
			)
		);

		wp_enqueue_script( "inspqu-{$quote_template}-js" );

		// === Render the template ===
		ob_start();
		include $template_path;
		$output = ob_get_clean();

		return $output;
	}
}
