<?php
/**
 * Plugin Name:       InspirePulse Quotes
 * Plugin URI:        https://onlinewebtutorblog.com/inspirepulse-quotes/
 * Description:       Display stunning motivational quotes anywhere on your WordPress site using a simple shortcode. Includes auto-refresh, quote categories, author info, and an elegant built-in quote manager with powerful admin tools.
 * Version:           1.7
 * Author:            Online Web Tutor
 * Author URI:        https://onlinewebtutorblog.com/
 * License:           GPL-2.0+
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       inspirepulse-quotes
 * Domain Path:       /languages
 *
 * @package InspirePulse_Quotes
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

require_once plugin_dir_path(__FILE__) . 'includes/inspqu-constants.php';

function inspqu_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-inspqu-activator.php';
	$inspqu_activator = new \owthub\inspqu\INSPQU_Activator();
	$inspqu_activator->inspqu_activate();
}

function inspqu_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-inspqu-deactivator.php';
	$inspqu_deactivator = new \owthub\inspqu\INSPQU_Deactivator();
	$inspqu_deactivator->inspqu_deactivator();
}

register_activation_hook( __FILE__, 'inspqu_activate' );
register_deactivation_hook( __FILE__, 'inspqu_deactivate' );

require plugin_dir_path( __FILE__ ) . 'includes/class-inspqu.php';

function inspqu_start_plugin() {
	$plugin = new \owthub\inspqu\INSPQU_Main();
    $plugin->inspqu_runner();
}
inspqu_start_plugin();
