<?php
namespace owthub\inspqu;

use owthub\inspqu\INSPQU_Loader;
use owthub\inspqu\INSPQU_i18n;
use owthub\inspqu\INSPQU_Ajax;
use owthub\inspqu\admin\INSPQU_Admin;
use owthub\inspqu\public\INSPQU_Public;

if ( ! defined( 'ABSPATH' ) ) exit;

class INSPQU_Main {

    protected $loader;
    protected $InspirePulseQuotes;
    protected $version;

    public function __construct() {

        $this->version = defined( 'INSPQU_VERSION' ) ? INSPQU_VERSION : '1.0';
        $this->InspirePulseQuotes = INSPQU_TEXT_DOMAIN;

        $this->inspqu_load_dependencies();
        $this->inspqu_set_locale();
        $this->inspqu_admin_hooks();
        $this->inspqu_public_hooks();
        $this->inspqu_ajax_hooks();
    }

    private function inspqu_load_dependencies() {

        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-activator.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-query.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-helper.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-layout.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-ajax.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-loader.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-i18n.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-widget.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-inspqu-gutenberg-block.php';

        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-inspqu-admin.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-inspqu-public.php';

        $this->loader = new INSPQU_Loader();
    }

    private function inspqu_set_locale() {
        $plugin_i18n = new INSPQU_i18n();
        $this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'inspqu_load_plugin_textdomain' );
    }

    private function inspqu_admin_hooks() {
        $plugin_admin = new INSPQU_Admin( $this->inspqu_get_InspirePulseQuotes(), $this->inspqu_get_version() );

        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'inspqu_enqueue_styles', 20 );
        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'inspqu_enqueue_scripts' );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'inspqu_register_admin_menu' );
        $this->loader->add_filter( 'plugin_action_links_' . INSPQU_BASE_NAME, $plugin_admin, 'inspqu_plugin_action_links' );
    }

    private function inspqu_public_hooks() {
        $plugin_public = new INSPQU_Public( $this->inspqu_get_InspirePulseQuotes(), $this->inspqu_get_version() );
        add_shortcode( 'inspqu', [ $plugin_public, 'inspqu_render_quote_template' ] );

        // Register Gutenberg Block
        $this->loader->add_action( 'init', $this, 'inspqu_register_gutenberg_block' );
    }

    private function inspqu_ajax_hooks() {
        $inspquAjax = new INSPQU_Ajax();

        $this->loader->add_action( 'wp_ajax_inspqu_ajax', $inspquAjax, 'inspqu_handler' );
        $this->loader->add_action( 'wp_ajax_nopriv_inspqu_ajax', $inspquAjax, 'inspqu_handler' );
    }

    /**
     * Register WordPress Widget
     */
    public function inspqu_register_widget() {
        register_widget( 'owthub\inspqu\INSPQU_Widget' );
    }

    /**
     * Register Gutenberg Block
     */
    public function inspqu_register_gutenberg_block() {
        INSPQU_Gutenberg_Block::register();
    }

    public function inspqu_runner() {
        // Register Widget
        $this->loader->add_action( 'widgets_init', $this, 'inspqu_register_widget' );
        
        $this->loader->run();
    }

    public function inspqu_get_InspirePulseQuotes() {
        return $this->InspirePulseQuotes;
    }

    public function inspqu_get_loader() {
        return $this->loader;
    }

    public function inspqu_get_version() {
        return $this->version;
    }
}