<?php
namespace owthub\inspqu;
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/includes
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class INSPQU_Layout {

    public static function inspqu_get_dashboard_header() {
        ?>
        <header class="inspqu-hero">
            <div class="inspqu-hero-inner">
                <h1 class="inspqu-title">
                    <?php esc_html_e( 'Welcome to InspirePulse Quotes', 'inspirepulse-quotes' ); ?>
                </h1>
                <p class="inspqu-sub">
                    <?php
                    esc_html_e(
                        'InspirePulse Quotes helps you organize inspirational quotes into categories, showcase them using beautiful templates, auto-rotate them like a smart slider, and embed them anywhere with dynamic shortcodes.',
                        'inspirepulse-quotes'
                    );
                    ?>
                </p>
            </div>
        </header>
        <?php
    }

    public static function inspqu_get_about_header() {
        ?>
        <header class="inspqu-hero">
            <div class="inspqu-hero-inner">
                <h1 class="inspqu-title">
                    <?php esc_html_e( 'InspirePulse Quotes', 'inspirepulse-quotes' ); ?>
                </h1>
                <p class="inspqu-sub">
                    <?php
                    esc_html_e(
                        'A modern WordPress quotes manager built to inspire — featuring stylish layouts, smart sliders, shortcode embedding, and more exciting features coming soon.',
                        'inspirepulse-quotes'
                    );
                    ?>
                </p>
            </div>
        </header>
        <?php
    }

    public static function inspqu_get_header() {
        ?>
        <h1 class="inspqu-page-title">
            <?php esc_html_e( 'InspirePulse Quotes', 'inspirepulse-quotes' ); ?>
            <sup class="inspqu-version">
                <?php
                printf(
                    /* translators: %s: plugin version */
                    esc_html__( 'v%s', 'inspirepulse-quotes' ),
                    esc_html( defined( 'INSPQU_VERSION' ) ? INSPQU_VERSION : '1.0' )
                );
                ?>
            </sup>
        </h1>
        <?php
    }

    public static function inspqu_get_footer() {
        ?>
        <div id="inspqu-loader" style="display:none;">
            <div class="inspqu-loader-spinner"></div>
        </div>

        <footer class="inspqu-footer">
            <div class="footer-left">
                <strong><?php esc_html_e( 'InspirePulse Quotes', 'inspirepulse-quotes' ); ?></strong>
                &nbsp;•&nbsp;
                <?php
                printf(
                    /* translators: %s: plugin version */
                    esc_html__( 'v%s', 'inspirepulse-quotes' ),
                    esc_html( defined( 'INSPQU_VERSION' ) ? INSPQU_VERSION : '1.0' )
                );
                ?>
            </div>

            <div class="footer-right">
                <?php esc_html_e( 'Crafted with ♥ by', 'inspirepulse-quotes' ); ?>
                <a
                    href="<?php echo esc_url( base64_decode( INSPQU_AUTHOR_URI ) ); ?>"
                    target="_blank"
                    rel="noopener noreferrer"
                >
                    <?php echo esc_html( base64_decode( INSPQU_AUTHOR ) ); ?>
                </a>
            </div>
        </footer>
        <?php
    }
}