<?php
namespace owthub\inspqu;
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/includes
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
if ( ! defined( 'ABSPATH' ) ) exit;

class INSPQU_Deactivator {

	public static function inspqu_deactivator() {

		global $wpdb;

		$tables = INSPQU_App_Helper::inspqu_db_tables();

		foreach ( $tables as $table ) {

			if ( strpos( $table, $wpdb->prefix ) !== 0 ) {
				continue;
			}

			$table_name = esc_sql( $table );

			$wpdb->query( "DROP TABLE IF EXISTS `{$table_name}`" );
		}

		$options = INSPQU_App_Helper::inspqu_options();

		foreach ( $options as $option ) {
			
			delete_option( $option );
		}
	}
}