<?php
namespace owthub\inspqu;
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/includes
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
if ( ! defined( 'ABSPATH' ) ) exit;

class INSPQU_Activator {

	public function inspqu_activate() {

		$this->inspqu_generate_tables();
		$this->inspqu_generate_data();
	}

	public function inspqu_generate_tables() {

		global $wpdb;
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';

		$charset_collate = $wpdb->get_charset_collate();

		$quotes_table = $this->inspqu_quotes_table();

		$quotes_exists = $wpdb->get_var(
			$wpdb->prepare(
				'SHOW TABLES LIKE %s',
				$quotes_table
			)
		);

		if ( $quotes_exists !== $quotes_table ) {

			$sql_quotes = "CREATE TABLE {$quotes_table} (
				id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				quote_text TEXT NOT NULL,
				quote_author VARCHAR(255) DEFAULT NULL,
				status TINYINT(1) DEFAULT 1,
				created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
				updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				PRIMARY KEY (id)
			) {$charset_collate};";

			dbDelta( $sql_quotes );
		}

		$categories_table = $this->inspqu_categories_table();

		$categories_exists = $wpdb->get_var(
			$wpdb->prepare(
				'SHOW TABLES LIKE %s',
				$categories_table
			)
		);

		if ( $categories_exists !== $categories_table ) {

			$sql_categories = "CREATE TABLE {$categories_table} (
				id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				name VARCHAR(255) NOT NULL,
				slug VARCHAR(255) NOT NULL,
				status TINYINT(1) DEFAULT 1,
				created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
				updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				PRIMARY KEY (id)
			) {$charset_collate};";

			dbDelta( $sql_categories );
		}

		$bkp_table = $this->inspqu_backups_table();

		$bkp_exists = $wpdb->get_var(
			$wpdb->prepare(
				'SHOW TABLES LIKE %s',
				$bkp_table
			)
		);

		if ( $bkp_exists !== $bkp_table ) {

			$sql_bkp = "CREATE TABLE {$bkp_table} (
				id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				filename VARCHAR(150) DEFAULT NULL,
				filesize VARCHAR(50) DEFAULT NULL,
				flag VARCHAR(20) DEFAULT NULL,
				is_running VARCHAR(20) DEFAULT NULL,
				filepath VARCHAR(150) DEFAULT NULL,
				type VARCHAR(30) DEFAULT NULL,
				modules LONGTEXT DEFAULT NULL,
				created_by BIGINT(20) DEFAULT NULL,
				created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (id)
			) {$charset_collate};";

			dbDelta( $sql_bkp );
		}

		$rel_table = $this->inspqu_quotes_categories_relation_table();

		$rel_exists = $wpdb->get_var(
			$wpdb->prepare(
				'SHOW TABLES LIKE %s',
				$rel_table
			)
		);

		if ( $rel_exists !== $rel_table ) {

			$sql_rel = "CREATE TABLE {$rel_table} (
				id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				quote_id BIGINT(20) UNSIGNED NOT NULL,
				category_id BIGINT(20) UNSIGNED NOT NULL,
				PRIMARY KEY (id),
				KEY quote_id (quote_id),
				KEY category_id (category_id)
			) {$charset_collate};";

			dbDelta( $sql_rel );
		}
	}

	public function inspqu_generate_data() {
		// Default seed data (optional)
	}

	public function inspqu_quotes_table() {
		global $wpdb;
		return $wpdb->prefix . 'inspqu_quotes';
	}

	public function inspqu_categories_table() {
		global $wpdb;
		return $wpdb->prefix . 'inspqu_categories';
	}

	public function inspqu_quotes_categories_relation_table() {
		global $wpdb;
		return $wpdb->prefix . 'inspqu_quotes_categories_relation';
	}

	public function inspqu_backups_table() {
		global $wpdb;
		return $wpdb->prefix . 'inspqu_backups';
	}
}