<?php 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/admin/partials
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
use owthub\inspqu\INSPQU_App_Helper;
use owthub\inspqu\INSPQU_Layout;

if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="inspqu-dashboard">
    <main class="inspqu-cards-wrap">
        <div class="inspqu-header-card">
            <div class="inspqu-header">
                <h2><?php esc_html_e('Shortcodes List', 'inspirepulse-quotes'); ?></h2>
                <div class="inspqu-header-btns">
                    <a href="javascript:void(0);" id="inspqu-open-shortcode-guide" class="inspqu-add-btn" title="<?php esc_attr_e('View Complete Shortcode Guide', 'inspirepulse-quotes'); ?>">
                        <span class="inspqu-add-icon">ℹ️</span> <?php esc_html_e('Shortcode Guide', 'inspirepulse-quotes'); ?>
                    </a>
                    <a href="<?php echo esc_url( admin_url('admin.php?page=inspqu-settings' ) ); ?>" class="inspqu-add-btn inspqu-back-btn">
                        <span class="inspqu-add-icon">⬅️</span> <?php esc_html_e('Back to Settings', 'inspirepulse-quotes'); ?>
                    </a>
                </div>
            </div>
        </div>

        <div class="inspqu-data-card">
            <div class="inspqu-table-wrap">
                <table id="inspqu-table" class="inspqu-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Layout Preview', 'inspirepulse-quotes'); ?></th>
                            <th><?php esc_html_e('Shortcode', 'inspirepulse-quotes'); ?></th>
                            <th><?php esc_html_e('Actions', 'inspirepulse-quotes'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($inspqu_layouts)) : ?>
                            <?php foreach ($inspqu_layouts as $inspqu_quote_ly) : ?>
                            <tr>
                                <td class="inspqu-layout-preview">
                                    <?php 
                                        $inspqu_url  = INSPQU_App_Helper::get_inspqu_url();
                                        $inspqu_img_path = $inspqu_url . $inspqu_quote_ly['template'];
                                    ?>
                                    <div class="inspqu-preview-img-wrap">
                                        <img src="<?php echo esc_url($inspqu_img_path); ?>" class="inspqu-preview-img" />
                                    </div>
                                </td>

                                <td class="inspqu-shortcode-text">
                                    <code><?php echo esc_html($inspqu_quote_ly['shortcode']); ?></code>
                                </td>

                                <td class="inspqu-actions">
                                    <a href="javascript:void(0);" 
                                       class="inspqu-action-btn copy inspqu-copy-shortcode" 
                                       data-shortcode="<?php echo esc_attr($inspqu_quote_ly['shortcode']); ?>" 
                                       title="<?php echo esc_attr__('Copy to Clipboard', 'inspirepulse-quotes'); ?>">
                                       📋 <?php esc_html_e('Copy Shortcode', 'inspirepulse-quotes'); ?>
                                    </a>

                                    <a href="javascript:void(0);" 
                                        class="inspqu-action-btn preview inspqu-preview-template" 
                                        data-img="<?php echo esc_url($inspqu_img_path); ?>"
                                        title="<?php echo esc_attr__('Preview Template', 'inspirepulse-quotes'); ?>">
                                    👁️ <?php esc_html_e('Preview', 'inspirepulse-quotes'); ?>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                        <?php else : ?>
                        <tr>
                            <td colspan="3" class="inspqu-empty-msg">
                                <?php esc_html_e('No Shortcode Found.', 'inspirepulse-quotes'); ?>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div id="inspqu-template-modal" class="inspqu-preview-modal">
            <div class="inspqu-modal-box">
                <div class="inspqu-modal-header">
                    <h3><?php esc_html_e('Template Preview', 'inspirepulse-quotes'); ?></h3>
                    <span class="inspqu-modal-close">&times;</span>
                </div>
                <div class="inspqu-modal-body">
                    <img id="inspqu-modal-img" src="" class="inspqu-modal-img"/>
                </div>
            </div>
        </div>

        <!-- Shortcode Guide Modal -->
        <div id="inspqu-shortcode-guide-modal" class="inspqu-modal">
            <div class="inspqu-modal-content" style="max-width: 1000px;">
                <div class="inspqu-modal-header">
                    <h2><?php esc_html_e('Complete Shortcode Guide', 'inspirepulse-quotes'); ?></h2>
                    <span class="inspqu-modal-close">&times;</span>
                </div>
                <div class="inspqu-modal-body" style="max-height: 50vh; overflow-y: auto;">
                    <div class="inspqu-shortcode-guide">
                        <h3><?php esc_html_e('1. Main Shortcode: [inspqu]', 'inspirepulse-quotes'); ?></h3>
                        <p><?php esc_html_e('Display rotating inspirational quotes with customizable options.', 'inspirepulse-quotes'); ?></p>
                        
                        <h4><?php esc_html_e('Available Attributes:', 'inspirepulse-quotes'); ?></h4>
                        <table class="inspqu-guide-table">
                            <thead>
                                <tr>
                                    <th><?php esc_html_e('Attribute', 'inspirepulse-quotes'); ?></th>
                                    <th><?php esc_html_e('Description', 'inspirepulse-quotes'); ?></th>
                                    <th><?php esc_html_e('Default', 'inspirepulse-quotes'); ?></th>
                                    <th><?php esc_html_e('Example', 'inspirepulse-quotes'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><code>design</code></td>
                                    <td><?php esc_html_e('Choose layout style: Elegant Dark, Gradient Glow Box, Paper Vintage Look, Floating Glass Overlay, Big Center Text + Corner', 'inspirepulse-quotes'); ?></td>
                                    <td>Elegant Dark</td>
                                    <td><code>design="Gradient Glow Box"</code></td>
                                </tr>
                                <tr>
                                    <td><code>timer</code></td>
                                    <td><?php esc_html_e('Auto-rotation interval in seconds', 'inspirepulse-quotes'); ?></td>
                                    <td><?php esc_html_e('Global setting', 'inspirepulse-quotes'); ?></td>
                                    <td><code>timer="10"</code></td>
                                </tr>
                                <tr>
                                    <td><code>category</code></td>
                                    <td><?php esc_html_e('Filter by category name or ID (comma-separated for multiple)', 'inspirepulse-quotes'); ?></td>
                                    <td><?php esc_html_e('All categories', 'inspirepulse-quotes'); ?></td>
                                    <td><code>category="Motivation"</code> or <code>category="1,2"</code></td>
                                </tr>
                                <tr>
                                    <td><code>author</code></td>
                                    <td><?php esc_html_e('Filter by author name (comma-separated for multiple)', 'inspirepulse-quotes'); ?></td>
                                    <td><?php esc_html_e('All authors', 'inspirepulse-quotes'); ?></td>
                                    <td><code>author="Einstein"</code> or <code>author="Einstein,Steve Jobs"</code></td>
                                </tr>
                                <tr>
                                    <td><code>limit</code></td>
                                    <td><?php esc_html_e('Maximum number of quotes to display', 'inspirepulse-quotes'); ?></td>
                                    <td><?php esc_html_e('All available', 'inspirepulse-quotes'); ?></td>
                                    <td><code>limit="5"</code></td>
                                </tr>
                                <tr>
                                    <td><code>orderby</code></td>
                                    <td><?php esc_html_e('Sort order: random, date, author, id', 'inspirepulse-quotes'); ?></td>
                                    <td>random</td>
                                    <td><code>orderby="date"</code></td>
                                </tr>
                                <tr>
                                    <td><code>order</code></td>
                                    <td><?php esc_html_e('Sort direction: ASC or DESC (only when orderby is not random)', 'inspirepulse-quotes'); ?></td>
                                    <td>ASC</td>
                                    <td><code>order="DESC"</code></td>
                                </tr>
                                <tr>
                                    <td><code>id</code></td>
                                    <td><?php esc_html_e('Display a specific quote by ID', 'inspirepulse-quotes'); ?></td>
                                    <td><?php esc_html_e('All quotes', 'inspirepulse-quotes'); ?></td>
                                    <td><code>id="42"</code></td>
                                </tr>
                                <tr>
                                    <td><code>exclude</code></td>
                                    <td><?php esc_html_e('Exclude specific quote IDs (comma-separated)', 'inspirepulse-quotes'); ?></td>
                                    <td><?php esc_html_e('None', 'inspirepulse-quotes'); ?></td>
                                    <td><code>exclude="1,2,3"</code></td>
                                </tr>
                                <tr>
                                    <td><code>status</code></td>
                                    <td><?php esc_html_e('Filter by status: active, draft, or all', 'inspirepulse-quotes'); ?></td>
                                    <td>active</td>
                                    <td><code>status="all"</code></td>
                                </tr>
                            </tbody>
                        </table>

                        <h4><?php esc_html_e('Usage Examples:', 'inspirepulse-quotes'); ?></h4>
                        <div class="inspqu-examples">
                            <p><code>[inspqu]</code> - <?php esc_html_e('Default layout with global timer', 'inspirepulse-quotes'); ?></p>
                            <p><code>[inspqu design="Gradient Glow Box"]</code> - <?php esc_html_e('Specific design with global timer', 'inspirepulse-quotes'); ?></p>
                            <p><code>[inspqu timer="10"]</code> - <?php esc_html_e('Default design with 10-second rotation', 'inspirepulse-quotes'); ?></p>
                            <p><code>[inspqu design="Paper Vintage Look" timer="8"]</code> - <?php esc_html_e('Custom design and timer', 'inspirepulse-quotes'); ?></p>
                            <p><code>[inspqu category="Motivation" limit="5"]</code> - <?php esc_html_e('5 quotes from Motivation category', 'inspirepulse-quotes'); ?></p>
                            <p><code>[inspqu author="Einstein" timer="15"]</code> - <?php esc_html_e('Quotes by Einstein with 15-second rotation', 'inspirepulse-quotes'); ?></p>
                            <p><code>[inspqu category="Success" orderby="date" order="DESC"]</code> - <?php esc_html_e('Latest Success quotes', 'inspirepulse-quotes'); ?></p>
                            <p><code>[inspqu id="42"]</code> - <?php esc_html_e('Display specific quote #42', 'inspirepulse-quotes'); ?></p>
                            <p><code>[inspqu category="Motivation,Success" limit="10"]</code> - <?php esc_html_e('Combined filters with sharing', 'inspirepulse-quotes'); ?></p>
                        </div>
                    </div>
                </div>
                <div class="inspqu-modal-actions">
                    <button type="button" class="inspqu-modal-btn inspqu-modal-close"><?php esc_html_e('Close', 'inspirepulse-quotes'); ?></button>
                </div>
            </div>
        </div>
    </main>
    <?php INSPQU_Layout::inspqu_get_footer(); ?>
</div>

<style>
.inspqu-shortcode-guide {
    font-size: 14px;
    line-height: 1.6;
}

.inspqu-shortcode-guide h3 {
    color: #0073aa;
    margin-top: 25px;
    margin-bottom: 15px;
    font-size: 18px;
}

.inspqu-shortcode-guide h4 {
    color: #333;
    margin-top: 20px;
    margin-bottom: 10px;
    font-size: 16px;
}

.inspqu-guide-table {
    width: 100%;
    border-collapse: collapse;
    margin: 15px 0;
    background: #fff;
}

.inspqu-guide-table thead {
    background: #f5f5f5;
}

.inspqu-guide-table th,
.inspqu-guide-table td {
    padding: 12px;
    text-align: left;
    border: 1px solid #ddd;
}

.inspqu-guide-table th {
    font-weight: 600;
    color: #333;
}

.inspqu-guide-table code {
    background: #f0f0f0;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 13px;
    color: #c7254e;
}

.inspqu-examples {
    background: #f9f9f9;
    padding: 15px;
    border-left: 4px solid #0073aa;
    margin: 15px 0;
}

.inspqu-examples p {
    margin: 8px 0;
}

.inspqu-examples code {
    background: #fff;
    padding: 4px 8px;
    border-radius: 3px;
    font-size: 13px;
    color: #c7254e;
    display: inline-block;
    margin-right: 10px;
}
</style>

<script>
jQuery(document).ready(function($) {
    $('#inspqu-open-shortcode-guide').on('click', function() {
        $('#inspqu-shortcode-guide-modal').fadeIn(300);
    });

    $(document).on('click', '#inspqu-shortcode-guide-modal .inspqu-modal-close, #inspqu-shortcode-guide-modal', function(e) {
        if (e.target === this) {
            $('#inspqu-shortcode-guide-modal').fadeOut(300);
        }
    });
});
</script>
