<?php
use owthub\inspqu\INSPQU_App_Helper;
use owthub\inspqu\INSPQU_Layout; 
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/admin/partials
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */

if ( ! defined( 'ABSPATH' ) ) exit;

$inspqu_ranges = get_option('inspqu_import_ranges');
$inspqu_data_exists = !empty($inspqu_ranges) && isset($inspqu_ranges['quotes_range']['start_id']);
$inspqu_exists_attr = $inspqu_data_exists ? 'data-exists=1' : 'data-exists=0';
?>
<div class="inspqu-dashboard">
    <main class="inspqu-cards-wrap">
        <div class="inspqu-header-card">
            <div class="inspqu-header">

                <h2><?php esc_html_e('All Settings', 'inspirepulse-quotes'); ?></h2>
                
                <div class="inspqu-header-btns">

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-add-quote' ) ); ?>" class="inspqu-add-btn">
                        <span class="inspqu-add-icon">＋</span>
                        <?php esc_html_e( 'Add New Quote', 'inspirepulse-quotes' ); ?>
                    </a>

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-all-quotes' ) ); ?>" class="inspqu-add-btn alt">
                        <span class="inspqu-add-icon">👁️</span>
                        <?php esc_html_e( 'View My Quotes', 'inspirepulse-quotes' ); ?>
                    </a>

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-categories' ) ); ?>" class="inspqu-add-btn alt">
                        <span class="inspqu-add-icon">📁</span>
                        <?php esc_html_e( 'View Categories', 'inspirepulse-quotes' ); ?>
                    </a>

                    <?php if ( INSPQU_App_Helper::inspqu_has_backup_data() ) : ?>
                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-show-backups' ) ); ?>" class="inspqu-add-btn alt">
                            <span class="inspqu-add-icon">👁️</span>
                            <?php esc_html_e( 'Show Backup Files', 'inspirepulse-quotes' ); ?>
                        </a>
                    <?php endif; ?>

                </div>

            </div>
        </div>

        <div class="inspqu-data-card inspqu-settings">
            <?php if ($inspqu_data_exists): ?>
                <div class="inspqu-settings-header installed">
                    <div class="inspqu-data">
                        ⚡ <?php
                                printf(
                                    /* translators: 1: Start quote ID, 2: End quote ID */
                                    esc_html__(
                                        'Test data installed in your database (Quotes ID: %1$s → %2$s)',
                                        'inspirepulse-quotes'
                                    ),
                                    esc_html( $inspqu_ranges['quotes_range']['start_id'] ),
                                    esc_html( $inspqu_ranges['quotes_range']['end_id'] )
                                );
                            ?>
                    </div>
                    <div class="inspqu-settings-btns">
                        <a
                            href="javascript:void(0);"
                            id="inspqu-btn-reinstall-data"
                            class="inspqu-reinstall-btn"
                            <?php echo esc_attr( $inspqu_exists_attr ); ?>
                        >
                            🔄 <?php esc_html_e( 'Reinstall Quotes', 'inspirepulse-quotes' ); ?>
                        </a>

                        <a
                            href="javascript:void(0);"
                            id="inspqu-btn-remove-data"
                            class="inspqu-remove-btn"
                        >
                            🗑 <?php esc_html_e( 'Remove Default Quotes', 'inspirepulse-quotes' ); ?>
                        </a>
                    </div>
                </div>
            <?php else: ?>
                <div class="inspqu-settings-header not-installed">
                    <div class="inspqu-data">✨ <?php esc_html_e('No default quotes installed yet. Click the card below to import curated quotes.', 'inspirepulse-quotes'); ?></div>
                </div>
            <?php endif; ?>

            <div class="inspqu-settings-grid">

                <div class="inspqu-setting-item install">
                    <div class="inspqu-icon">⚡</div>
                    <h3><?php esc_html_e('Install Default Quotes', 'inspirepulse-quotes'); ?></h3>
                    <p><?php esc_html_e('Load premium curated quotes instantly', 'inspirepulse-quotes'); ?></p>
                    <a href="javascript:void(0)" <?php echo esc_attr($inspqu_exists_attr); ?> id="inspqu-link-install-data" class="inspqu-overlay-link"></a>
                </div>

                <div class="inspqu-setting-item backup">
                    <div class="inspqu-icon">💾</div>
                    <h3><?php esc_html_e('Generate Data Backup', 'inspirepulse-quotes'); ?></h3>
                    <p><?php esc_html_e('Generate full SQL backup (.sql)', 'inspirepulse-quotes'); ?></p>
                    <a href="javascript:void(0)" id="inspqu-btn-generate-backup" class="inspqu-overlay-link"></a>
                </div>

                <div class="inspqu-setting-item shortcode-layout">
                    <div class="inspqu-icon">🔗<span class="inspqu-icon-plus">＋</span>🎨</div>
                    <h3><?php esc_html_e('My Shortcodes + Layout', 'inspirepulse-quotes'); ?></h3>
                    <p><?php esc_html_e('View & copy shortcode with customize quote layouts', 'inspirepulse-quotes'); ?></p>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-shortcodes' ) ); ?>" class="inspqu-overlay-link"></a>
                </div>

                <div class="inspqu-setting-item timer-settings">
                    <div class="inspqu-icon">⏱️</div>
                    <h3><?php esc_html_e('Quote Timer Settings', 'inspirepulse-quotes'); ?></h3>
                    <p><?php esc_html_e('Set auto-refresh timing for quote slider', 'inspirepulse-quotes'); ?></p>
                    <a href="javascript:void(0)" id="inspqu-open-timer-modal" class="inspqu-overlay-link"></a>
                </div>

                <div class="inspqu-setting-item import-backup">
                    <div class="inspqu-icon">📥</div>
                    <h3><?php esc_html_e('Import Backup File', 'inspirepulse-quotes'); ?></h3>
                    <p><?php esc_html_e('Restore quotes from SQL backup file', 'inspirepulse-quotes'); ?></p>
                    <a href="javascript:void(0)" id="inspqu-open-import-modal" class="inspqu-overlay-link"></a>
                </div>
            </div>
        </div>
        
        <div id="inspqu-timer-modal" class="inspqu-modal">
            <div class="inspqu-modal-content">
                <div class="inspqu-modal-header">
                    <h2 id="inspqu-modal-title"><?php esc_html_e('Auto-Refresh Timer', 'inspirepulse-quotes'); ?></h2>
                    <span class="inspqu-modal-close">&times;</span>
                </div>
                <form id="inspqu-timer-form" action="javascript:void(0);" class="inspqu-modal-form">
                    <div class="inspqu-form-group">
                        <label><?php esc_html_e('Auto-Refresh Timer (in seconds)', 'inspirepulse-quotes'); ?></label>
                        <input type="text" id="timer_seconds" required name="timer_seconds" 
                               placeholder="<?php echo esc_attr__('Enter seconds...', 'inspirepulse-quotes'); ?>" 
                               value="<?php echo intval(get_option('inspqu_timer_miliseconds')) > 0 ? (intval(get_option('inspqu_timer_miliseconds'))/1000) : (INSPQU_App_Helper::inspqu_get_default_timer_value()/1000); ?>">
                    </div>
                    <button class="inspqu-modal-btn"><?php esc_html_e('Save Settings', 'inspirepulse-quotes'); ?></button>
                </form>
            </div>
        </div>

        <div id="inspqu-import-modal" class="inspqu-modal">
            <div class="inspqu-modal-content">
                <div class="inspqu-modal-header">
                    <h2 id="inspqu-import-modal-title"><?php esc_html_e('Import Backup File', 'inspirepulse-quotes'); ?></h2>
                    <span class="inspqu-modal-close">&times;</span>
                </div>
                <form id="inspqu-import-form" action="javascript:void(0);" class="inspqu-modal-form" enctype="multipart/form-data">
                    <div class="inspqu-form-group">
                        <label><?php esc_html_e('Select SQL Backup File', 'inspirepulse-quotes'); ?></label>
                        <input type="file" id="backup_file" name="backup_file" accept=".sql" required>
                        <small class="inspqu-help-text"><?php esc_html_e('Only .sql files are allowed. Maximum file size: 10MB', 'inspirepulse-quotes'); ?></small>
                    </div>
                    
                    <div class="inspqu-form-group">
                        <label class="inspqu-checkbox-label">
                            <input type="checkbox" id="create_backup_before_import" name="create_backup_before_import" checked>
                            <span><?php esc_html_e('Create backup of current data before importing', 'inspirepulse-quotes'); ?></span>
                        </label>
                        <small class="inspqu-help-text"><?php esc_html_e('Recommended: This will create a backup of your current quotes and categories before importing new data.', 'inspirepulse-quotes'); ?></small>
                    </div>

                    <div class="inspqu-warning-box">
                        <strong>⚠️ <?php esc_html_e('Warning:', 'inspirepulse-quotes'); ?></strong>
                        <p><?php esc_html_e('Importing a backup file will replace all existing quotes, categories, and their relationships in your database. This action cannot be undone unless you have a backup.', 'inspirepulse-quotes'); ?></p>
                    </div>

                    <div class="inspqu-form-group">
                        <label class="inspqu-checkbox-label">
                            <input type="checkbox" id="confirm_import" name="confirm_import" required>
                            <span><?php esc_html_e('I understand that importing will replace my current data', 'inspirepulse-quotes'); ?></span>
                        </label>
                    </div>

                    <div class="inspqu-modal-actions">
                        <button type="button" class="inspqu-modal-btn-cancel inspqu-modal-close"><?php esc_html_e('Cancel', 'inspirepulse-quotes'); ?></button>
                        <button type="submit" class="inspqu-modal-btn inspqu-btn-import"><?php esc_html_e('Import Backup', 'inspirepulse-quotes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </main>
    <?php INSPQU_Layout::inspqu_get_footer(); ?>
</div>
