<?php
/**
 * @link       https://onlinewebtutorblog.com
 * @since      1.0
 * @package    InspirePulse_Quotes
 * @subpackage InspirePulse_Quotes/admin/partials
 * @copyright  Copyright (c) 2025, Sanjay Kumar
 * @license    GPL-2.0+ https://www.gnu.org/licenses/gpl-2.0.html
 * @author     Online Web Tutor
 */
use owthub\inspqu\INSPQU_Layout;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="inspqu-dashboard">
    <main class="inspqu-cards-wrap">

        <div class="inspqu-header-card">
            <div class="inspqu-header">
                <?php
                $inspqu_cat    = isset( $inspqu_query_params['category_name'] ) ? sanitize_text_field( $inspqu_query_params['category_name'] ) : '';
                $inspqu_author = isset( $inspqu_query_params['author_name'] ) ? sanitize_text_field( $inspqu_query_params['author_name'] ) : '';
                ?>

                <h2>
                    <?php esc_html_e( 'Quotes List', 'inspirepulse-quotes' ); ?>

                    <?php if ( ! empty( $inspqu_cat ) ) : ?>
                        <?php esc_html_e( 'of Category', 'inspirepulse-quotes' ); ?>
                        <span class="category-title">"<?php echo esc_html( $inspqu_cat ); ?>"</span>

                    <?php elseif ( ! empty( $inspqu_author ) ) : ?>
                        <?php esc_html_e( 'by Author', 'inspirepulse-quotes' ); ?>
                        <span class="author-title">"<?php echo esc_html( ucwords( $inspqu_author ) ); ?>"</span>
                    <?php endif; ?>
                </h2>

                <div class="inspqu-header-btns">

                    <?php if ( ! empty( $inspqu_cat ) || ! empty( $inspqu_author ) ) : ?>
                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-all-quotes' ) ); ?>" class="inspqu-add-btn">
                            <svg width="14" height="14" viewBox="0 0 24 24" fill="none"
                                 stroke="currentColor" stroke-width="2"
                                 stroke-linecap="round" stroke-linejoin="round"
                                 style="vertical-align:middle;">
                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                <line x1="6" y1="6" x2="18" y2="18"></line>
                            </svg>
                            <?php esc_html_e( 'Clear Filter', 'inspirepulse-quotes' ); ?>
                        </a>
                    <?php endif; ?>

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-add-quote' ) ); ?>" class="inspqu-add-btn">
                        <span class="inspqu-add-icon">＋</span>
                        <?php esc_html_e( 'Add New Quote', 'inspirepulse-quotes' ); ?>
                    </a>

                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=inspqu-categories' ) ); ?>" class="inspqu-add-btn alt">
                        <span class="inspqu-add-icon">👁️</span>
                        <?php esc_html_e( 'View Categories', 'inspirepulse-quotes' ); ?>
                    </a>

                </div>
            </div>
        </div>

        <div class="inspqu-data-card">
            <div class="inspqu-table-top">
                <input
                    type="text"
                    id="inspqu-search"
                    placeholder="<?php echo esc_attr__( 'Search...', 'inspirepulse-quotes' ); ?>"
                />
            </div>

            <div class="inspqu-table-wrap">
                <table id="inspqu-table" class="inspqu-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'ID', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Quote', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Author', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Category', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Date Added', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Status', 'inspirepulse-quotes' ); ?></th>
                            <th><?php esc_html_e( 'Action', 'inspirepulse-quotes' ); ?></th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php if ( ! empty( $inspqu_quotes ) ) : ?>
                            <?php foreach ( $inspqu_quotes as $inspqu_single_quote ) :

                                $inspqu_status_label = ( (int) $inspqu_single_quote['status'] === 1 )
                                    ? esc_html__( 'Active', 'inspirepulse-quotes' )
                                    : esc_html__( 'Draft', 'inspirepulse-quotes' );

                                $inspqu_status_class = ( (int) $inspqu_single_quote['status'] === 1 ) ? 'success' : 'draft';

                                $inspqu_created = ! empty( $inspqu_single_quote['created_at'] )
                                    ? esc_html( gmdate( 'Y-m-d', strtotime( $inspqu_single_quote['created_at'] ) ) )
                                    : '-';
                                    
                                $inspqu_author_url = wp_nonce_url(
                                                    add_query_arg(
                                                        [
                                                            'page'   => 'inspqu-all-quotes',
                                                            'author' => sanitize_text_field( $inspqu_single_quote['quote_author'] ),
                                                        ],
                                                        admin_url( 'admin.php' )
                                                    ),
                                                    'inspqu_filter_quotes',
                                                    'inspqu_nonce'
                                                );

                                $inspqu_category_url = wp_nonce_url(
                                    add_query_arg(
                                        [
                                            'page'   => 'inspqu-all-quotes',
                                            'cat_id' => absint( $inspqu_single_quote['category_id'] ),
                                        ],
                                        admin_url( 'admin.php' )
                                    ),
                                    'inspqu_filter_quotes',
                                    'inspqu_nonce'
                                );

                                $inspqu_edit_quote_url = wp_nonce_url(
                                    add_query_arg(
                                        [
                                            'page'   => 'inspqu-edit-quote',
                                            'id' => intval( $inspqu_single_quote['id'] ),
                                        ],
                                        admin_url( 'admin.php' )
                                    ),
                                    'inspqu_edit_quote',
                                    'inspqu_nonce'
                                );
                                ?>

                                <tr>
                                    <td><?php echo esc_html( $inspqu_single_quote['id'] ); ?></td>

                                    <td>
                                        <div class="inspqu-quote-truncate">
                                            <?php echo esc_html( $inspqu_single_quote['quote_text'] ); ?>
                                        </div>
                                    </td>

                                    <td>
                                        <a href="<?php echo esc_url( $inspqu_author_url ); ?>" class="inspqu-link-badge inspqu-author-badge">
                                            <?php echo esc_html( ucwords( $inspqu_single_quote['quote_author'] ) ); ?>
                                        </a>
                                    </td>

                                    <td>
                                        <a href="<?php echo esc_url( $inspqu_category_url ); ?>" class="inspqu-link-badge inspqu-category-badge">
                                            <?php echo esc_html( ucwords( $inspqu_single_quote['category_name'] ) ); ?>
                                        </a>
                                    </td>

                                    <td><?php echo esc_html( $inspqu_created ); ?></td>

                                    <td>
                                        <span class="inspqu-status <?php echo esc_attr( $inspqu_status_class ); ?>">
                                            <?php echo esc_html( $inspqu_status_label ); ?>
                                        </span>
                                    </td>

                                    <td class="inspqu-actions">
                                        <a
                                            href="<?php echo esc_url( $inspqu_edit_quote_url ); ?>"
                                            class="inspqu-action-btn edit"
                                        >
                                            ✏️ <?php esc_html_e( 'Edit', 'inspirepulse-quotes' ); ?>
                                        </a>

                                        <a
                                            href="javascript:void(0)"
                                            class="inspqu-action-btn delete inspqu-btn-delete-action"
                                            data-id="<?php echo esc_attr( $inspqu_single_quote['id'] ); ?>"
                                            data-module="quotes"
                                        >
                                            🗑️ <?php esc_html_e( 'Delete', 'inspirepulse-quotes' ); ?>
                                        </a>
                                    </td>
                                </tr>

                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="7" style="text-align:center; padding:20px; color:#888;">
                                    <?php esc_html_e( 'No Quote Found.', 'inspirepulse-quotes' ); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>

                </table>
            </div>
        </div>
    </main>

    <?php INSPQU_Layout::inspqu_get_footer(); ?>
</div>
